/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.util.Rectangle;
import jcurses.widgets.DefaultLayoutManager;
import jcurses.widgets.Grid;
import jcurses.widgets.GridLayoutConstraint;
import jcurses.widgets.LayoutManager;
import jcurses.widgets.Widget;
import jcurses.widgets.WidgetContainer;
import jcurses.widgets.WidgetsConstants;

public class GridLayoutManager
implements LayoutManager,
WidgetsConstants {
    private DefaultLayoutManager _defLayout = new DefaultLayoutManager();
    private WidgetContainer _father = null;
    private int _width = 0;
    private int _height = 0;
    private Grid _grid = null;

    @Override
    public void bindToContainer(WidgetContainer container) {
        if (this._father != null) {
            throw new RuntimeException("Already bound!!!");
        }
        this._father = container;
    }

    @Override
    public void unbindFromContainer() {
        this._father = null;
    }

    public GridLayoutManager(int width, int height) {
        this._width = width;
        this._height = height;
    }

    @Override
    public void layout(Widget widget, Object constraint) {
        if (!(constraint instanceof GridLayoutConstraint)) {
            throw new RuntimeException("unknown constraint: " + constraint.getClass().getName());
        }
        Rectangle rect = this._father.getChildsRectangle() == null ? this._father.getSize() : this._father.getChildsRectangle();
        this._grid = new Grid(rect, this._width, this._height);
        this._defLayout.layout(widget, ((GridLayoutConstraint)constraint).getDefaultLayoutConstraint(this._grid));
    }

    public void addWidget(Widget widget, int x, int y, int width, int height, int verticalConstraint, int horizontalConstraint) {
        this._father.addWidget(widget, new GridLayoutConstraint(x, y, width, height, horizontalConstraint, verticalConstraint));
    }

    public void removeWidget(Widget widget) {
        this._father.removeWidget(widget);
    }
}

