/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.io.File;
import jcurses.event.ActionEvent;
import jcurses.event.ActionListener;
import jcurses.event.ItemEvent;
import jcurses.event.ItemListener;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Message;
import jcurses.widgets.Button;
import jcurses.widgets.DefaultFileFilterFactory;
import jcurses.widgets.DefaultLayoutManager;
import jcurses.widgets.Dialog;
import jcurses.widgets.FileDialogFileFilter;
import jcurses.widgets.FilterTextField;
import jcurses.widgets.GridLayoutManager;
import jcurses.widgets.JCursesFileFilterFactory;
import jcurses.widgets.Label;
import jcurses.widgets.List;
import jcurses.widgets.Panel;
import jcurses.widgets.TextField;
import jcurses.widgets.WidgetsConstants;

public class FileDialog
extends Dialog
implements WidgetsConstants,
ItemListener,
ActionListener {
    private String _directory = null;
    private String _file = null;
    private String _filterString = null;
    private boolean _inRoots = false;
    private String _result = null;
    String _ioErrorText = "Input/Output Error is occured!";
    String _ioErrorTitle = "I/O Error";
    JCursesFileFilterFactory _filterFactory = new DefaultFileFilterFactory();
    List _directories = new List();
    List _files = null;
    Label _fileLabel = null;
    Label _filterLabel = null;
    TextField _fileField = null;
    TextField _filterField = null;
    Button _okButton = null;
    Button _cancelButton = null;
    private static InputChar __returnChar = new InputChar('\n');

    public FileDialog(int x, int y, int width, int height, String title) {
        super(x, y, width, height, true, title);
        this._directories.setSelectable(false);
        this._directories.setTitle("Directories");
        this._directories.addListener(this);
        this._files = new List();
        this._files.setSelectable(false);
        this._files.setTitle("Files");
        this._files.addListener(this);
        this._fileLabel = new Label("File: ");
        this._filterLabel = new Label("Filter: ");
        this._fileField = new TextField();
        this._fileField.setText(this.getCurrentFileContent());
        this._filterField = new FilterTextField(this);
        this._okButton = new Button("OK");
        this._okButton.addListener(this);
        this._cancelButton = new Button("Cancel");
        this._cancelButton.addListener(this);
        Panel topPanel = new Panel();
        GridLayoutManager topManager = new GridLayoutManager(2, 1);
        topPanel.setLayoutManager(topManager);
        topManager.addWidget(this._directories, 0, 0, 1, 1, 4, 4);
        topManager.addWidget(this._files, 1, 0, 1, 1, 4, 4);
        Panel bottomPanel = new Panel();
        GridLayoutManager bottomManager = new GridLayoutManager(4, 4);
        bottomPanel.setLayoutManager(bottomManager);
        bottomManager.addWidget(this._fileLabel, 0, 0, 1, 1, 4, 3);
        bottomManager.addWidget(this._filterLabel, 0, 2, 1, 1, 4, 3);
        bottomManager.addWidget(this._fileField, 1, 0, 2, 1, 4, 4);
        bottomManager.addWidget(this._filterField, 1, 2, 2, 1, 4, 4);
        bottomManager.addWidget(this._okButton, 3, 0, 1, 1, 4, 4);
        bottomManager.addWidget(this._cancelButton, 3, 2, 1, 1, 4, 4);
        DefaultLayoutManager manager = (DefaultLayoutManager)this.getRootPanel().getLayoutManager();
        manager.addWidget(topPanel, 0, 0, width - 2, height - 6, 4, 4);
        manager.addWidget(bottomPanel, 0, height - 6, width - 2, 4, 4, 4);
        this.fillListWidgets(this.getCurrentDirectory());
    }

    public FileDialog(String title) {
        this(Toolkit.getScreenWidth() / 4, Toolkit.getScreenHeight() / 4, Toolkit.getScreenWidth() / 2, Toolkit.getScreenHeight() / 2, title);
    }

    public FileDialog() {
        this(null);
    }

    public void setDirectory(String directory) {
        this._directory = directory;
    }

    public String getDirectory() {
        return this._directory;
    }

    public void setIOErrorMessageText(String message) {
        this._ioErrorText = message;
    }

    public void setIOErrorMessageTitle(String message) {
        this._ioErrorTitle = message;
    }

    protected void directoryReadErrorMessage() {
        new Message(this._ioErrorTitle, this._ioErrorText, "OK").show();
    }

    public void setDefaultFile(String file) {
        this._file = file;
    }

    public String getDefaultFile() {
        return this._file;
    }

    public File getChoosedFile() {
        if (this._result == null) {
            return null;
        }
        return new File(this._result);
    }

    public void setFilterString(String filterString) {
        this._filterString = filterString;
    }

    public String getFilterString() {
        return this._filterString;
    }

    public void setFilterFactory(JCursesFileFilterFactory filterFactory) {
        this._filterFactory = filterFactory;
    }

    private String getCurrentDirectory() {
        File directoryFile;
        String directoryPath;
        if (this._directory == null) {
            this._directory = System.getProperty("user.dir");
        }
        if (!(directoryPath = (directoryFile = new File(this._directory)).getAbsolutePath().trim()).endsWith(File.separator)) {
            directoryPath = String.valueOf(directoryPath) + File.separator;
        }
        return directoryPath;
    }

    private String getRelativePath(File file, String directoryPath) {
        String path = file.getAbsolutePath().trim();
        if (path.startsWith(directoryPath)) {
            path = path.substring(directoryPath.length(), path.length());
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private void saveResult() {
        this._result = this._fileField.getText();
    }

    private String getCurrentFileContent() {
        String content = this._file != null ? this._file : this.getCurrentDirectory();
        return content;
    }

    private void updateFileField() {
        this._fileField.setText(this.getCurrentFileContent());
        this._fileField.paint();
    }

    private void updateFilterField() {
        this._filterField.setText(this._filterString);
        this._filterField.paint();
    }

    private void updateListWidgets() {
        this.updateListWidgets(false);
    }

    private void updateListWidgets(boolean roots) {
        this._directories.clear();
        this._files.clear();
        if (!roots) {
            this.fillListWidgets(this.getCurrentDirectory());
        } else {
            this.fillDirectoriesWidgetWithRoots();
        }
        this._directories.paint();
        this._files.paint();
    }

    private void fillDirectoriesWidgetWithRoots() {
        File[] roots = File.listRoots();
        int i = 0;
        while (i < roots.length) {
            this._directories.add(roots[i].getAbsolutePath());
            ++i;
        }
    }

    private void fillListWidgets(String directory) {
        File directoryFile = new File(directory);
        if (directoryFile.isDirectory()) {
            File[] files = directoryFile.listFiles(new FileDialogFileFilter(this._filterFactory.generateFileFilter(this._filterString)));
            if (directoryFile.getParentFile() != null || this.isWindows()) {
                this._directories.add("..");
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this._directories.add(this.getRelativePath(files[i], directory));
                } else {
                    this._files.add(this.getRelativePath(files[i], directory));
                }
                ++i;
            }
        } else {
            new Message("Error", "An error is occured trying to read the directory\n " + directory, "OK");
        }
    }

    private boolean isWindows() {
        return File.separatorChar == '\\';
    }

    @Override
    public void stateChanged(ItemEvent event) {
        if (event.getSource() == this._directories) {
            this._file = null;
            String item = ((String)event.getItem()).trim();
            String backupDirectory = this._directory;
            if (item.equals("..")) {
                File directoryFile = new File(this._directory);
                if (directoryFile.getParentFile() == null) {
                    this._inRoots = true;
                    this.updateListWidgets(true);
                    return;
                }
                this._directory = new File(this._directory).getParentFile().getAbsolutePath();
            } else {
                this._directory = !this._inRoots ? String.valueOf(this.getCurrentDirectory()) + event.getItem() : (String)event.getItem();
            }
            if (!this.checkDirectory(this._directory)) {
                this.directoryReadErrorMessage();
                this._directory = backupDirectory;
                return;
            }
            this._inRoots = false;
            this.updateListWidgets();
            this.updateFileField();
        } else if (event.getSource() == this._files) {
            String item = ((String)event.getItem()).trim();
            this._file = String.valueOf(this.getCurrentDirectory()) + event.getItem();
            this.updateFileField();
        }
    }

    private boolean checkDirectory(String directory) {
        File file = new File(directory);
        return file.exists() && file.isDirectory() && file.canRead();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton) {
            this.saveResult();
            this.close();
        } else {
            this.close();
        }
    }

    @Override
    protected void onChar(InputChar inp) {
        if (inp.equals(__returnChar)) {
            if (this._filterField.hasFocus()) {
                this.setFilterString(this._filterField.getText());
                this.updateListWidgets();
            } else {
                this.saveResult();
                this.close();
            }
        }
    }
}

