/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.event.ValueChangedEvent;
import jcurses.event.ValueChangedListener;
import jcurses.event.ValueChangedListenerManager;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.Widget;

public class CheckBox
extends Widget {
    private boolean _checked = false;
    private ValueChangedListenerManager _listenerManager = new ValueChangedListenerManager();
    private static CharColor __checkBoxDefaultColors = new CharColor(7, 0);
    private static CharColor __focusedCheckBoxDefaultColors = new CharColor(4, 7, 1);
    private CharColor _focusedCheckboxColors = this.getFocusedCheckboxDefaultColors();
    private static InputChar __changeStatusChar = new InputChar(' ');

    @Override
    public CharColor getDefaultColors() {
        return __checkBoxDefaultColors;
    }

    private CharColor getFocusedCheckboxDefaultColors() {
        return __focusedCheckBoxDefaultColors;
    }

    public CharColor getFocusedCheckboxColors() {
        return this._focusedCheckboxColors;
    }

    public void setFocusedCheckboxColors(CharColor colors) {
        this._focusedCheckboxColors = colors;
    }

    public CheckBox(boolean checked) {
        this._checked = checked;
    }

    public CheckBox() {
        this(false);
    }

    public boolean getValue() {
        return this._checked;
    }

    public void setValue(boolean value) {
        boolean oldValue = this._checked;
        this._checked = value;
        if (oldValue != this._checked) {
            this._listenerManager.handleEvent(new ValueChangedEvent(this));
        }
        this.paint();
    }

    @Override
    protected Rectangle getPreferredSize() {
        return new Rectangle(3, 1);
    }

    @Override
    protected void doPaint() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        String text = "[" + (this._checked ? "X" : " ") + "]";
        CharColor colors = this.hasFocus() ? this.getFocusedCheckboxColors() : this.getColors();
        Toolkit.printString(text, rect, colors);
    }

    @Override
    protected boolean isFocusable() {
        return true;
    }

    @Override
    protected void doRepaint() {
        this.doPaint();
    }

    @Override
    protected boolean handleInput(InputChar ch) {
        if (ch.equals(__changeStatusChar)) {
            this.setValue(!this._checked);
            this.paint();
            return true;
        }
        return false;
    }

    private void changeColors() {
        CharColor colors = this.hasFocus() ? this.getFocusedCheckboxColors() : this.getColors();
        Toolkit.changeColors(this.getRectangle(), colors);
    }

    @Override
    protected void focus() {
        this.changeColors();
    }

    @Override
    protected void unfocus() {
        this.changeColors();
    }

    public void addListener(ValueChangedListener listener) {
        this._listenerManager.addListener(listener);
    }

    public void removeListener(ValueChangedListener listener) {
        this._listenerManager.removeListener(listener);
    }
}

