/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.util.Rectangle;
import jcurses.widgets.BorderLayoutConstraint;
import jcurses.widgets.LayoutManager;
import jcurses.widgets.Widget;
import jcurses.widgets.WidgetContainer;

public class BorderLayoutManager
implements LayoutManager {
    public static final int CENTER = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int EAST = 4;
    private WidgetContainer mFather = null;
    private BorderLayoutConstraint[] mSlots = new BorderLayoutConstraint[5];
    private int[] mXSep = new int[2];
    private int[] mYSep = new int[2];

    @Override
    public void bindToContainer(WidgetContainer container) {
        if (this.mFather != null) {
            throw new IllegalStateException("Already bound!!!");
        }
        this.mFather = container;
    }

    @Override
    public void unbindFromContainer() {
        this.mFather = null;
    }

    @Override
    public void layout(Widget widget, Object constraint) {
        if (!(constraint instanceof BorderLayoutConstraint)) {
            throw new IllegalArgumentException("unknown constraint: " + constraint.getClass().getName());
        }
        this.updateAllSeparators();
        Rectangle rect = this.mFather.getChildsRectangle() == null ? this.mFather.getSize() : this.mFather.getChildsRectangle();
        BorderLayoutConstraint cstr = (BorderLayoutConstraint)constraint;
        Rectangle prefSize = widget.getPreferredSize();
        int prefWidth = prefSize.getWidth();
        int prefHeight = prefSize.getHeight();
        int maxWidth = rect.getWidth();
        int maxHeight = rect.getHeight();
        int x = 0;
        int y = 0;
        switch (cstr.mPosition) {
            case 1: {
                x = 0;
                y = 0;
                maxHeight = this.mYSep[0];
                break;
            }
            case 2: {
                x = 0;
                y = this.mYSep[1];
                maxHeight -= this.mYSep[1];
                break;
            }
            case 0: {
                x = this.mXSep[0];
                y = this.mYSep[0];
                maxWidth = this.mXSep[1] - this.mXSep[0];
                maxHeight = this.mYSep[1] - this.mYSep[0];
                break;
            }
            case 3: {
                x = 0;
                y = this.mYSep[0];
                maxWidth = this.mXSep[0];
                maxHeight = this.mYSep[1] - this.mYSep[0];
                break;
            }
            case 4: {
                x = this.mXSep[1];
                y = this.mYSep[0];
                maxWidth -= this.mXSep[1];
                maxHeight = this.mYSep[1] - this.mYSep[0];
                break;
            }
            default: {
                throw new IllegalStateException("Unknown position for widget: " + cstr.mPosition);
            }
        }
        if (prefWidth <= 0) {
            prefWidth = maxWidth;
        }
        if (prefHeight <= 0) {
            prefHeight = maxHeight;
        }
        int width = 0;
        int height = 0;
        if (prefWidth < maxWidth) {
            widget.setX(this.getAlignedCoordinate(prefWidth, maxWidth, x, cstr.mHorizontalConstraint));
            width = prefWidth;
        } else {
            widget.setX(x);
            width = maxWidth;
        }
        if (prefHeight < maxHeight) {
            widget.setY(this.getAlignedCoordinate(prefHeight, maxHeight, y, cstr.mVerticalConstraint));
            height = prefHeight;
        } else {
            widget.setY(y);
            height = maxHeight;
        }
        widget.setSize(new Rectangle(width, height));
    }

    private void updateAllSeparators() {
        Rectangle rect = this.mFather.getChildsRectangle() == null ? this.mFather.getSize() : this.mFather.getChildsRectangle();
        this.updateSeparatorsDimension(this.mXSep, this.mSlots[3], this.mSlots[0], this.mSlots[4], rect.getWidth(), true);
        this.updateSeparatorsDimension(this.mYSep, this.mSlots[1], this.mSlots[0], this.mSlots[2], rect.getHeight(), false);
    }

    private void updateSeparatorsDimension(int[] sep, BorderLayoutConstraint w1, BorderLayoutConstraint w2, BorderLayoutConstraint w3, int max, boolean width) {
        int pref;
        sep[0] = 0;
        sep[1] = max;
        if (w2 == null) {
            if (w1 == null) {
                if (w3 == null) {
                    return;
                }
                sep[1] = 0;
                return;
            }
            if (w3 == null) {
                sep[0] = max;
                return;
            }
        }
        if (w1 != null) {
            pref = width ? w1.mWidget.getPreferredSize().getWidth() : w1.mWidget.getPreferredSize().getHeight();
            sep[0] = pref < 0 ? -1 : sep[0] + pref;
        }
        if (w3 != null) {
            pref = width ? w3.mWidget.getPreferredSize().getWidth() : w3.mWidget.getPreferredSize().getHeight();
            sep[1] = pref < 0 ? -1 : sep[1] - pref;
        }
        if (w2 == null) {
            if (sep[0] < 0) {
                if (sep[1] < 0) {
                    sep[0] = max / 2;
                    sep[1] = max / 2;
                } else {
                    sep[0] = sep[1];
                }
            } else if (sep[1] < 0) {
                sep[1] = sep[0];
            }
        } else if (sep[0] < 0) {
            if (sep[1] < 0) {
                sep[0] = max / 3;
                sep[1] = max - sep[0];
            } else {
                sep[0] = sep[1] / 2;
            }
        } else if (sep[1] < 0) {
            sep[1] = max - (max - sep[0]) / 2;
        }
    }

    private int getAlignedCoordinate(int prefG, int contG, int contC, int alignment) {
        if (alignment == 4) {
            return contC + (contG - prefG) / 2;
        }
        if (alignment == 1 || alignment == 3) {
            return contC + contG - prefG;
        }
        return contC;
    }

    public void addWidget(Widget widget, int position, int verticalConstraint, int horizontalConstraint) {
        if (position != 1 && position != 2 && position != 3 && position != 4 && position != 0) {
            throw new IllegalArgumentException("Must specify position of NORTH, SOUTH, WEST, EAST, or CENTER.");
        }
        this.mSlots[position] = new BorderLayoutConstraint(widget, position, horizontalConstraint, verticalConstraint);
        this.mFather.addWidget(widget, this.mSlots[position]);
    }

    public void removeWidget(Widget widget) {
        this.mFather.removeWidget(widget);
        int i = 0;
        while (i < this.mSlots.length) {
            if (this.mSlots[i].mWidget == widget) {
                this.mSlots[i] = null;
            }
            ++i;
        }
    }
}

