/*
 * Decompiled with CFR 0.152.
 */
package jcurses.util;

public class Rectangle {
    int _x = 0;
    int _y = 0;
    int _width = 0;
    int _height = 0;

    public Rectangle(int x, int y, int width, int height) {
        this._x = x;
        this._y = y;
        this._width = width;
        this._height = height;
    }

    public Rectangle(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setX(int x) {
        this._x = x;
    }

    public void setY(int y) {
        this._y = y;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public boolean isEmpty() {
        return this._width <= 0 || this._height <= 0;
    }

    public boolean contains(int X, int Y, int W, int H) {
        int width = this._width;
        int height = this._height;
        if (width <= 0 || height <= 0 || W <= 0 || H <= 0) {
            return false;
        }
        int x = this._x;
        int y = this._y;
        return X >= x && Y >= y && X + W <= x + width && Y + H <= y + height;
    }

    public boolean contains(Rectangle rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public Rectangle intersection(Rectangle r) {
        if (this.isEmpty()) {
            return (Rectangle)this.clone();
        }
        if (r.isEmpty()) {
            return (Rectangle)r.clone();
        }
        int x1 = Math.max(this._x, r.getX());
        int x2 = Math.min(this._x + this._width, r.getX() + r.getWidth());
        int y1 = Math.max(this._y, r.getY());
        int y2 = Math.min(this._y + this._height, r.getY() + r.getHeight());
        if (x2 - x1 < 0 || y2 - y1 < 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public Rectangle union(Rectangle r) {
        if (this.isEmpty()) {
            return (Rectangle)r.clone();
        }
        if (r.isEmpty()) {
            return (Rectangle)this.clone();
        }
        int x1 = Math.min(this._x, r.getX());
        int x2 = Math.max(this._x + this._width, r.getX() + r.getWidth());
        int y1 = Math.min(this._y, r.getY());
        int y2 = Math.max(this._y + this._height, r.getY() + r.getHeight());
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean inside(int x, int y) {
        return x >= this._x && x - this._x < this._width && y >= this._y && y - this._y < this._height;
    }

    public void setLocation(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void resize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public Object clone() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public String toString() {
        return "[x=" + this._x + ",y=" + this._y + ",width=" + this._width + ",height=" + this._height + ",isEmpty=" + this.isEmpty() + "]";
    }
}

