/*
 * Decompiled with CFR 0.152.
 */
package jcurses.util;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashSet;

public class Protocol {
    public static final String SYSTEM_PROPERTY_NAME = "jcurses.protocol.filename";
    public static final String DEBUG = "debug";
    public static final String SYSTEM = "system";
    private static HashSet __activatedChannels = new HashSet();
    private static PrintStream __logStream = null;

    static {
        Protocol.initLogStreamIfPossible();
        Protocol.initLogging();
    }

    private static void initLogStreamIfPossible() {
        try {
            String fileName = System.getProperty(SYSTEM_PROPERTY_NAME);
            if (fileName != null) {
                __logStream = new PrintStream(new FileOutputStream(fileName, true));
                System.setErr(__logStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initLogging() {
        Protocol.activateChannel(SYSTEM);
    }

    public static void activateChannel(String channel) {
        __activatedChannels.add(channel);
    }

    public static void log(String message, String channel) {
        if (Protocol.isLoggingActivated() && Protocol.isChannelActivated(channel)) {
            String outputMessage = String.valueOf(Protocol.getPrefix(channel)) + " " + message;
            __logStream.println(outputMessage);
            __logStream.flush();
        }
    }

    private static String getPrefix(String channel) {
        Calendar cal = Calendar.getInstance();
        String prefix = "[" + cal.get(5) + "." + (cal.get(2) + 1) + "." + cal.get(1) + "  " + cal.get(10) + ":" + cal.get(12) + ":" + cal.get(13) + "  channel=" + channel + "]";
        return prefix;
    }

    private static boolean isLoggingActivated() {
        if (__logStream == null) {
            Protocol.initLogStreamIfPossible();
        }
        return __logStream != null;
    }

    private static boolean isChannelActivated(String channel) {
        return true;
    }

    public static void system(String message) {
        Protocol.log(message, SYSTEM);
    }

    public static void debug(String message) {
        Protocol.log(message, DEBUG);
    }
}

