/*
 * Decompiled with CFR 0.152.
 */
package dyorgio.runtime.run.as.root;

import dyorgio.runtime.out.process.CallableSerializable;
import dyorgio.runtime.out.process.OneRunOutProcess;
import dyorgio.runtime.out.process.RunnableSerializable;
import dyorgio.runtime.run.as.root.NotAuthorizedException;
import dyorgio.runtime.run.as.root.RootProcessBuilderFactory;
import dyorgio.runtime.run.as.root.UserCanceledException;
import dyorgio.runtime.run.as.root.impl.LinuxRootProcessBuilderFactory;
import dyorgio.runtime.run.as.root.impl.MacRootProcessBuilderFactory;
import dyorgio.runtime.run.as.root.impl.WinRootProcessBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.Callable;

public class RootExecutor
implements Serializable {
    public static final String RUNNING_AS_ROOT = "$RunnningAsRoot";
    private static final RootProcessBuilderFactory MANAGER;
    private final OneRunOutProcess outProcess;

    static {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.contains("mac") || OS.contains("darwin")) {
            MANAGER = new MacRootProcessBuilderFactory();
        } else if (OS.contains("win")) {
            MANAGER = new WinRootProcessBuilderFactory();
        } else if (OS.contains("nux")) {
            MANAGER = new LinuxRootProcessBuilderFactory();
        } else {
            throw new RuntimeException("Unsupported OS:" + OS);
        }
    }

    public RootExecutor(String ... javaOptions) throws IOException {
        this((String)null, javaOptions);
    }

    public RootExecutor(String classpath, String[] javaOptions) throws IOException {
        this((File)null, classpath, javaOptions);
    }

    public RootExecutor(File tmpDir, String classpath, String ... javaOptions) throws IOException {
        this.outProcess = new OneRunOutProcess(tmpDir, MANAGER, classpath, javaOptions);
    }

    public void run(RunnableSerializable runnable) throws Exception, UserCanceledException, NotAuthorizedException {
        this.execute(runnable, false);
    }

    public <T extends Serializable> T call(CallableSerializable<T> callable) throws Exception, UserCanceledException, NotAuthorizedException {
        return (T)this.execute(callable, true);
    }

    private Serializable execute(Serializable command, boolean hasResult) throws Exception, UserCanceledException, NotAuthorizedException {
        if (System.getProperty(RUNNING_AS_ROOT) != null) {
            if (hasResult) {
                Callable callable = (Callable)((Object)command);
                return (Serializable)callable.call();
            }
            ((Runnable)((Object)command)).run();
            return null;
        }
        OneRunOutProcess.OutProcessResult<Serializable> result = this.outProcess.call(new RemoteCall(command, hasResult));
        MANAGER.handleCode(result.getReturnCode());
        return result.getResult();
    }

    private static final class RemoteCall
    implements CallableSerializable<Serializable> {
        private final Serializable command;
        private final boolean hasResult;

        private RemoteCall(Serializable command, boolean hasResult) {
            this.command = command;
            this.hasResult = hasResult;
        }

        @Override
        public Serializable call() throws Exception {
            System.setProperty(RootExecutor.RUNNING_AS_ROOT, "true");
            if (this.hasResult) {
                Callable callable = (Callable)((Object)this.command);
                return (Serializable)callable.call();
            }
            ((Runnable)((Object)this.command)).run();
            return null;
        }
    }
}

