/*
 * Decompiled with CFR 0.152.
 */
package dyorgio.runtime.out.process;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class OutProcessDiedException
extends RuntimeException
implements Serializable {
    private final CauseInfo[] causeData;

    OutProcessDiedException(String message, Throwable cause) {
        super(message);
        ArrayList<CauseInfo> causeDataList = new ArrayList<CauseInfo>();
        while (cause != null && cause != this) {
            StackTraceElement[] stackTraceOriginal = cause.getStackTrace();
            CauseStackTraceElement[] causeStackTrace = null;
            if (stackTraceOriginal != null) {
                causeStackTrace = new CauseStackTraceElement[stackTraceOriginal.length];
                int i = 0;
                while (i < stackTraceOriginal.length) {
                    StackTraceElement stackTraceElement = stackTraceOriginal[i];
                    causeStackTrace[i] = new CauseStackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
                    ++i;
                }
            }
            causeDataList.add(new CauseInfo(cause.getClass().getName(), cause.getMessage(), causeStackTrace));
            cause = cause.getCause();
        }
        this.causeData = causeDataList.toArray(new CauseInfo[causeDataList.size()]);
    }

    public Throwable getOriginalCause() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        if (this.causeData != null && this.causeData.length > 0) {
            Throwable lastCause = null;
            int i = this.causeData.length - 1;
            while (i >= 0) {
                CauseInfo causeInfo = this.causeData[i];
                try {
                    lastCause = (Throwable)Class.forName(causeInfo.causeClass).getConstructor(Throwable.class, String.class).newInstance(lastCause, causeInfo.causeMessage);
                }
                catch (NoSuchMethodException nsme1) {
                    try {
                        lastCause = (Throwable)Class.forName(causeInfo.causeClass).getConstructor(String.class, Throwable.class).newInstance(causeInfo.causeMessage, lastCause);
                    }
                    catch (NoSuchMethodException nsme2) {
                        lastCause = (Throwable)Class.forName(causeInfo.causeClass).getConstructor(String.class).newInstance(causeInfo.causeMessage);
                    }
                }
                CauseStackTraceElement[] causeStackTrace = causeInfo.causeStackTrace;
                StackTraceElement[] stackTraceOriginal = null;
                if (causeStackTrace != null) {
                    stackTraceOriginal = new StackTraceElement[causeStackTrace.length];
                    int j = 0;
                    while (j < causeStackTrace.length) {
                        CauseStackTraceElement stackTraceElement = causeStackTrace[j];
                        stackTraceOriginal[j] = new StackTraceElement(stackTraceElement.declaringClass, stackTraceElement.methodName, stackTraceElement.fileName, stackTraceElement.lineNumber);
                        ++j;
                    }
                }
                lastCause.setStackTrace(stackTraceOriginal);
                --i;
            }
            return lastCause;
        }
        return null;
    }

    private class CauseInfo
    implements Serializable {
        private final String causeClass;
        private final String causeMessage;
        private final CauseStackTraceElement[] causeStackTrace;

        private CauseInfo(String causeClass, String causeMessage, CauseStackTraceElement[] causeStackTrace) {
            this.causeClass = causeClass;
            this.causeMessage = causeMessage;
            this.causeStackTrace = causeStackTrace;
        }
    }

    private final class CauseStackTraceElement
    implements Serializable {
        private final String declaringClass;
        private final String methodName;
        private final String fileName;
        private final int lineNumber;

        public CauseStackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber) {
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }
    }
}

