/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.swproductkey;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.supermicro.swproductkey.InvalidProductKeyListFormatException;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductKeyListInstance {
    private static Logger logger = LoggerFactory.getLogger(ProductKeyListInstance.class);
    String mac = null;
    String ip = null;
    String id = null;
    String pw = null;
    byte[] key = null;
    private static final String IPMIIDPWPATTERN = "\\p{Print}{3,20}";
    private static final String MACADDRPATTERN = "^([0-9A-Fa-f]{2}[\\.:-]|[0-9A-Fa-f]{2}){5}([0-9A-Fa-f]{2})$";
    private static final String IPADDRPATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    public ProductKeyListInstance(String aMac, String aIp, String aId, String aPw, byte[] aKey) {
        this.mac = aMac;
        this.ip = aIp;
        this.id = aId;
        this.pw = aPw;
        this.key = aKey;
        logger.debug(this.toString());
    }

    public String getMacAddress() {
        return this.mac;
    }

    public String getIpAddress() {
        return this.ip;
    }

    public String getId() {
        return this.id;
    }

    public String getPw() {
        return this.pw;
    }

    public byte[] getKey() {
        return this.key;
    }

    public static boolean validMacAddress(String aMacAddr) {
        return aMacAddr.matches(MACADDRPATTERN);
    }

    public static boolean validIpAddress(String aIPAddr) {
        return aIPAddr.matches(IPADDRPATTERN);
    }

    public static boolean validIpmiIdOrPw(String aIdOrPw) {
        return aIdOrPw.matches(IPMIIDPWPATTERN);
    }

    public static ProductKeyListInstance parseAProductKeyListInstance(String aLine) throws InvalidProductKeyListFormatException {
        String[] results = aLine.split(";");
        String productKey = "";
        String retMac = null;
        String retIp = null;
        String retId = null;
        String retPw = null;
        byte[] retKey = null;
        if (results.length == 3) {
            retMac = results[0].trim();
            retIp = results[1].trim();
            productKey = results[2].trim();
        } else if (results.length == 5) {
            retMac = results[0].trim();
            retIp = results[1].trim();
            retId = results[2].trim();
            retPw = results[3].trim();
            productKey = results[4].trim();
        } else {
            throw new InvalidProductKeyListFormatException(aLine, "Each product key in list file must contain 3 or 5 parts. 1)MAC;IP;KEY, or 2)MAC;IP;ID;PW;KEY.");
        }
        if (!ProductKeyListInstance.validMacAddress(retMac)) {
            throw new InvalidProductKeyListFormatException(aLine, "Invalid MAC address:" + retMac);
        }
        if (!ProductKeyListInstance.validIpAddress(retIp)) {
            throw new InvalidProductKeyListFormatException(aLine, "Invalid IP address:" + retIp);
        }
        if (retId != null && !ProductKeyListInstance.validIpmiIdOrPw(retId)) {
            throw new InvalidProductKeyListFormatException(aLine, "Invalid IPMI ID:" + retId);
        }
        if (retPw != null && !ProductKeyListInstance.validIpmiIdOrPw(retPw)) {
            throw new InvalidProductKeyListFormatException(aLine, "Invalid IPMI PW:" + retPw);
        }
        if (productKey.length() == 0) {
            throw new InvalidProductKeyListFormatException(aLine, "Product key can not be empty!");
        }
        try {
            retKey = Base64.decode(productKey.getBytes("UTF-8"));
            if (retKey.length != 256) {
                throw new InvalidProductKeyListFormatException(aLine, "Invalid product key length! [" + retKey.length + "]");
            }
        }
        catch (Base64DecodingException e) {
            e.printStackTrace();
            throw new InvalidProductKeyListFormatException(aLine, e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new InvalidProductKeyListFormatException(aLine, e.getMessage());
        }
        return new ProductKeyListInstance(retMac, retIp, retId, retPw, retKey);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mac).append(";");
        sb.append(this.ip).append(";");
        if (this.id != null) {
            sb.append(this.id).append(";");
        }
        if (this.pw != null) {
            sb.append(this.pw).append(";");
        }
        sb.append(Base64.encode(this.key));
        return sb.toString();
    }
}

