/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.regex.Pattern;

public class SMTPRedfishHelper {
    public static final String URI_SUFFIX = "/redfish/v1/EventService";
    public static final String SMTP_NODE_PORT = "SMTP/Port";
    public static final String SMTP_NODE_SERVER_ADDRESS = "SMTP/ServerAddress";
    public static final String SMTP_NODE_SENDER_ADDRESS = "SMTP/FromAddress";
    public static final String SMTP_NODE_CONNECTION_PROTOCOL = "SMTP/ConnectionProtocol";
    public static final String SMTP_NODE_AUTHENTICATION_PROTOCOL = "SMTP/Authentication";
    public static final String SMTP_NODE_USERNAME = "SMTP/Username";
    public static final String SMTP_NODE_PASSWORD = "SMTP/Password";
    public static final String SMTP_CONNECTION_NONE = "None";
    public static final String SMTP_CONNECTION_AUTO = "AutoDetect";
    public static final String SMTP_CONNECTION_START_TLS = "StartTLS";
    public static final String SMTP_CONNECTION_TLS_SSL = "TLS_SSL";
    public static final String SMTP_AUTH_NONE = "None";
    public static final String SMTP_AUTH_AUTO = "AutoDetect";
    public static final String SMTP_AUTH_CRAM_MD5 = "CRAM_MD5";
    public static final String SMTP_AUTH_LOGIN = "Login";
    public static final String SMTP_AUTH_PLAIN = "Plain";
    public static final int SMTP_CONNECTION_ENUM_NONE = 0;
    public static final int SMTP_CONNECTION_ENUM_AUTO = 1;
    public static final int SMTP_CONNECTION_ENUM_START_TLS = 2;
    public static final int SMTP_CONNECTION_ENUM_TLS_SSL = 3;
    public static final int SMTP_AUTH_ENUM_NONE = 0;
    public static final int SMTP_AUTH_ENUM_AUTO = 1;
    public static final int SMTP_AUTH_ENUM_CRAM_MD5 = 2;
    public static final int SMTP_AUTH_ENUM_LOGIN = 3;
    public static final int SMTP_AUTH_ENUM_PLAIN = 4;

    public static boolean isSupportedRedfishSMTP(IPMIInterfaceConfig config) throws Exception {
        ObjectMapper mapper;
        JsonNode node;
        JsonNode version;
        String versionStr;
        String[] versionToken;
        BasicAuthClient bc = new BasicAuthClient(config);
        String url = "https://" + RedfishHttpUtils.getUrlIP(config.getIp()) + "/redfish/v1/";
        int result = bc.send_https_get(url);
        if (result >= 200 && result <= 210 && (versionToken = (versionStr = (version = (node = (mapper = new ObjectMapper()).readTree(bc.getResponseString())).path("RedfishVersion")).asText()).split("\\.")).length >= 3) {
            int firstVer = Integer.valueOf(versionToken[0]);
            int secondVer = Integer.valueOf(versionToken[1]);
            if (firstVer > 1 || firstVer == 1 && secondVer >= 9) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPort(String portStr) {
        try {
            int port = Integer.valueOf(portStr);
            if (1 <= port || port <= 65535) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isValidServerAddress(String address) {
        return SMTPRedfishHelper.isValidIPv4(address) || SMTPRedfishHelper.isValidIPv6(address);
    }

    public static boolean isValidEMailAddress(String address) {
        return address.contains("@") && address.contains(".");
    }

    public static boolean isValidConnectionProtocol(String protocolEnum) {
        try {
            int protocol = Integer.valueOf(protocolEnum);
            return SMTPRedfishHelper.getConnectionStr(protocol) != null;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidAuthenticationProtocol(String protocolEnum) {
        try {
            int protocol = Integer.valueOf(protocolEnum);
            return SMTPRedfishHelper.getAuthenticationStr(protocol) != null;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isValidIPv4(String ip) {
        String chunkIPv4 = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
        Pattern IPV4_STD_REGEX = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$");
        return IPV4_STD_REGEX.matcher(ip).matches();
    }

    private static boolean isValidIPv6(String ip) {
        if (ip.contains("/")) {
            ip = ip.split("/")[0];
        }
        String chunkIPv6 = "[0-9a-fA-F]{1,4}";
        Pattern IPV6_STD_REGEX = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        Pattern IPV6_COMPRESS_REGEX = Pattern.compile("^((?:[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)::((?:([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?)$");
        Pattern IPV6_COMPRESS_REGEX_BORDER = Pattern.compile("^(::(?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5})|((?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5}::)$");
        return IPV6_STD_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX_BORDER.matcher(ip).matches();
    }

    public static int getConnectionEnum(String value) {
        if (value.equals("None")) {
            return 0;
        }
        if (value.equals("AutoDetect")) {
            return 1;
        }
        if (value.equals(SMTP_CONNECTION_START_TLS)) {
            return 2;
        }
        if (value.equals(SMTP_CONNECTION_TLS_SSL)) {
            return 3;
        }
        return -1;
    }

    public static int getAuthenticationEnum(String value) {
        if (value.equals("None")) {
            return 0;
        }
        if (value.equals("AutoDetect")) {
            return 1;
        }
        if (value.equals(SMTP_AUTH_CRAM_MD5)) {
            return 2;
        }
        if (value.equals(SMTP_AUTH_LOGIN)) {
            return 3;
        }
        if (value.equals(SMTP_AUTH_PLAIN)) {
            return 4;
        }
        return -1;
    }

    public static String getConnectionStr(String value) {
        try {
            int protocol = Integer.valueOf(value);
            return SMTPRedfishHelper.getConnectionStr(protocol);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String getConnectionStr(int value) {
        if (value == 0) {
            return "None";
        }
        if (value == 1) {
            return "AutoDetect";
        }
        if (value == 2) {
            return SMTP_CONNECTION_START_TLS;
        }
        if (value == 3) {
            return SMTP_CONNECTION_TLS_SSL;
        }
        return null;
    }

    public static String getAuthenticationStr(String value) {
        try {
            int protocol = Integer.valueOf(value);
            return SMTPRedfishHelper.getAuthenticationStr(protocol);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String getAuthenticationStr(int value) {
        if (value == 0) {
            return "None";
        }
        if (value == 1) {
            return "AutoDetect";
        }
        if (value == 2) {
            return SMTP_AUTH_CRAM_MD5;
        }
        if (value == 3) {
            return SMTP_AUTH_LOGIN;
        }
        if (value == 4) {
            return SMTP_AUTH_PLAIN;
        }
        return null;
    }
}

