/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.kvm.authentication.KVMSessionConnection;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.awt.Desktop;
import java.net.URI;

public class RedfishHTML5KVMCommand
extends RedfishCommand {
    @Override
    public void runCommand() throws Exception {
        ISessionController sessionController = IPMIVersion.getSessionController(this.config);
        IPMINetworkInterface rmcp = sessionController.startup(this.config);
        LicenseManager lm = new LicenseManager(rmcp, this.config);
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (IPMIMessagingCommand.isBeforeX12(guid) && !lm.checkIfDCMSLicenseExist()) {
            MOut.G(this).println("DCMS-single needs to be activated for this device");
            this.statusCode = 155;
            return;
        }
        KVMSessionConnection kvmSession = new KVMSessionConnection(this.config.getIp(), this.config.getUserName(), this.config.getPassword());
        boolean switchResult = kvmSession.switchKVMInterface(1);
        if (!switchResult) {
            this.statusCode = 149;
            return;
        }
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String root = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = root + "/redfish/v1/Managers/1/";
        int result = bc.send_https_get(url);
        if (result == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode oem = node.path("Oem");
            JsonNode supermicro = oem.path("Supermicro");
            JsonNode ikvm = supermicro.path("IKVM");
            JsonNode ikvmOdataId = ikvm.path("@odata.id");
            String ikvmOdataIdValue = ikvmOdataId.textValue();
            int KVMResult = bc.send_https_get(root + ikvmOdataIdValue);
            if (KVMResult >= 200 || KVMResult <= 210) {
                node = mapper.readTree(bc.getResponseString());
                String uri = node.path("URI").textValue();
                String kvmRUI = root + uri;
                this.openKVM(kvmRUI);
            } else {
                this.printFailMessage(KVMResult, bc.getResponseString());
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else {
            this.printFailMessage(result, bc.getResponseString());
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }

    void openKVM(String kvmRUI) {
        block4: {
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(kvmRUI));
                    break block4;
                }
                if (Runtime.getRuntime().exec(new String[]{"which", "xdg-open"}).getInputStream().read() != -1) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", kvmRUI});
                    break block4;
                }
                MOut.G(this).println("Can't launch HTML version KVM in this environment due to no available browser found");
                this.statusCode = 149;
                return;
            }
            catch (Exception e) {
                MOut.G(this).println("Open KVM exception " + e.getMessage());
                this.statusCode = 149;
                return;
            }
        }
        this.statusCode = 0;
    }
}

