/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MELListCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.HashMap;
import java.util.List;

public class EventListCommand
extends RedfishCommand {
    public static final String HEL_URI_SUFFIX = "/redfish/v1/Systems/1/LogServices/Log1/Entries/";
    public static final String MEL_URI_SUFFIX = "/redfish/v1/Managers/1/LogServices/Log1/Entries/";
    public static final int EVENT_LOG_HEALTH = 0;
    public static final int EVENT_LOG_MAINTENANCE = 1;
    public static final String HEL_NODE_ID = "Id";
    public static final String HEL_NODE_SEVERITY = "Severity";
    public static final String HEL_NODE_DATETIME = "Created";
    public static final String HEL_NODE_SENSOR_TYPE = "SensorType";
    public static final String HEL_NODE_SENSOR_TYPE_OEM = "OemSensorType";
    public static final String HEL_NODE_MESSAGE = "Message";
    public static final String HEL_NODE_ENTRY_CODE = "EntryCode";
    public static final String MEL_NODE_ID = "Id";
    public static final String MEL_NODE_SEVERITY = "Severity";
    public static final String MEL_NODE_DATETIME = "Created";
    public static final String MEL_NODE_INTERFACE = "Oem/Supermicro/Interface";
    public static final String MEL_NODE_USER = "Oem/Supermicro/User";
    public static final String MEL_NODE_SOURCE = "Oem/Supermicro/Source";
    public static final String MEL_NODE_MESSAGE_X11 = "Description";
    public static final String MEL_NODE_MESSAGE_X12 = "Message";
    private int eventType;
    private int beginIndex;
    private int endIndex;
    private int lastEvents;
    private RedfishHttpUtils utils = new RedfishHttpUtils();

    public EventListCommand(int type) {
        this.eventType = type;
    }

    @Override
    public boolean preValidate() {
        this.beginIndex = -1;
        this.endIndex = -1;
        this.lastEvents = -1;
        if (null != this.parameters) {
            for (int index = 0; index < this.parameters.length; ++index) {
                try {
                    switch (index) {
                        case 0: {
                            this.lastEvents = Integer.valueOf(this.parameters[index]);
                            this.beginIndex = -1;
                            this.endIndex = -1;
                            break;
                        }
                        case 1: {
                            this.lastEvents = -1;
                            this.beginIndex = Integer.valueOf(this.parameters[index - 1]);
                            this.endIndex = Integer.valueOf(this.parameters[index]);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    MOut.G(this).println("Parameter format is invalid.");
                    this.statusCode = 147;
                    return false;
                }
                if (this.endIndex >= this.beginIndex) continue;
                MOut.G(this).println("Parameter range is invalid.");
                this.statusCode = 147;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid;
        if (this.eventType == 1 && IPMIMessagingCommand.isBeforeX12(guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp()))) {
            ISessionController sessionController = null;
            MELListCommand command = new MELListCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.config, command, 10);
            if (sessionController == null) {
                MOut.G(this).println("Session create failed");
                this.statusCode = 149;
                return;
            }
            this.statusCode = command.runCommand(this.beginIndex, this.endIndex, this.lastEvents);
            sessionController.closeSession();
            return;
        }
        int result = this.utils.sendRedfishGet(super.getConfig(), this.getRedfishURL(this.eventType));
        if (result == 200) {
            this.outputEvents(this.utils.getEntryList());
            this.statusCode = 0;
        } else if (result == 404) {
            MOut.G(this).println(this.getEventType() + " is not supported on this device");
            this.statusCode = 153;
        } else {
            this.printFailMessage(result, this.utils.getRedfishResponse());
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }

    public String getRedfishURL(int type) {
        String suffixURL = type == 0 ? HEL_URI_SUFFIX : MEL_URI_SUFFIX;
        return "https://" + RedfishHttpUtils.getUrlIP(super.getConfig().getIp()) + suffixURL;
    }

    private void outputEvents(List<HashMap<String, String>> entryList) {
        this.utils.reviseIndex(this.beginIndex, this.endIndex, this.lastEvents);
        int rIndex = this.utils.getRightIndex();
        int lIndex = this.utils.getLeftIndex();
        if (entryList.size() == 0) {
            System.out.println(this.getEventType() + " empty");
        } else if (rIndex == lIndex) {
            System.out.println("No events in the range");
        } else {
            this.outputMaintenanceEvents(entryList, lIndex, rIndex);
        }
    }

    private void outputMaintenanceEvents(List<HashMap<String, String>> entryList, int leftIndex, int rightIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = leftIndex; index < rightIndex; ++index) {
            stringBuilder.setLength(0);
            stringBuilder.append("--------------------------------------------------------------------");
            stringBuilder.append("\n");
            stringBuilder.append("Event:");
            stringBuilder.append(entryList.get(index).get("Id"));
            stringBuilder.append(" Time:");
            stringBuilder.append(this.utils.convertDatetimeFormat(entryList.get(index).get("Created")));
            stringBuilder.append(" Severity:");
            stringBuilder.append(entryList.get(index).get("Severity"));
            stringBuilder.append(" Interface:");
            stringBuilder.append(entryList.get(index).get(MEL_NODE_INTERFACE));
            stringBuilder.append(" User:");
            stringBuilder.append(entryList.get(index).get(MEL_NODE_USER));
            stringBuilder.append("\n");
            stringBuilder.append("Source:");
            stringBuilder.append(entryList.get(index).get(MEL_NODE_SOURCE));
            stringBuilder.append(" Desc:");
            stringBuilder.append(entryList.get(index).get("Message") != null ? entryList.get(index).get("Message") : entryList.get(index).get(MEL_NODE_MESSAGE_X11));
            System.out.println(stringBuilder.toString());
        }
    }

    private String getEventType() {
        return this.eventType == 0 ? "HEL" : "MEL";
    }
}

