/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.redfish.AuthClient;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.BasicAuthForAndroid;
import com.supermicro.redfish.SessionLoginClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RedfishHttpUtils {
    public static final int UNDEFINE_INDEX = -1;
    private int leftIndex;
    private int rightIndex;
    private String responseStr;
    private HashMap<String, String> entryMap = new HashMap();
    private List<HashMap<String, String>> entryMapList = new ArrayList<HashMap<String, String>>();

    public static String getUrlIP(String ip) {
        if (ip != null && !ip.contains(".") && RedfishHttpUtils.isIPv6(ip)) {
            return "[" + ip + "]";
        }
        return ip;
    }

    public static boolean isIPv6(String ip) {
        String chunkIPv6 = "[0-9a-fA-F]{1,4}";
        Pattern IPV6_STD_REGEX = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        Pattern IPV6_COMPRESS_REGEX = Pattern.compile("^((?:[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)::((?:([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?)$");
        Pattern IPV6_COMPRESS_REGEX_BORDER = Pattern.compile("^(::(?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5})|((?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5}::)$");
        return IPV6_STD_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX_BORDER.matcher(ip).matches();
    }

    public int sendRedfishGet(IPMIInterfaceConfig config, String url) throws Exception {
        BasicAuthClient client = new BasicAuthClient(config);
        int result = client.send_https_get(url);
        this.setRedfishResponse(client.getResponseString());
        return result;
    }

    public int sendRedfishGet(IPMIInterfaceConfig config, String url, String reserve) throws Exception {
        BasicAuthForAndroid client = new BasicAuthForAndroid(config);
        int result = client.send_https_get(url);
        this.setRedfishResponse(client.getResponseString());
        return result;
    }

    public int sendRedfishGet(AuthClient client, String url) throws Exception {
        if (client instanceof BasicAuthClient) {
            int result = ((BasicAuthClient)client).send_https_get(url);
            this.setRedfishResponse(((BasicAuthClient)client).getResponseString());
            return result;
        }
        if (client instanceof SessionLoginClient) {
            int result = ((SessionLoginClient)client).send_https_get(url);
            this.setRedfishResponse(((SessionLoginClient)client).getResponseString());
            return result;
        }
        return 405;
    }

    public int sendRedfishPatch(IPMIInterfaceConfig config, String url, String patchBody) throws Exception {
        BasicAuthClient client = new BasicAuthClient(config);
        int result = client.send_https_patch(url, patchBody);
        this.setRedfishResponse(client.getResponseString());
        return result;
    }

    public int sendRedfishPatch(AuthClient client, String url, String patchBody) throws Exception {
        if (client instanceof BasicAuthClient) {
            int result = ((BasicAuthClient)client).send_https_patch(url, patchBody);
            this.setRedfishResponse(((BasicAuthClient)client).getResponseString());
            return result;
        }
        if (client instanceof SessionLoginClient) {
            int result = ((SessionLoginClient)client).send_https_patch(url, patchBody);
            this.setRedfishResponse(((SessionLoginClient)client).getResponseString());
            return result;
        }
        return 405;
    }

    public HashMap<String, String> getEntry() throws Exception {
        return this.collect();
    }

    public HashMap<String, String> getEntry(JsonNode rootNode) throws Exception {
        return this.collect(rootNode);
    }

    public List<HashMap<String, String>> getEntryList() throws Exception {
        return this.collectList();
    }

    public List<HashMap<String, String>> getEntryListInNode(JsonNode rootNode) throws Exception {
        return this.collectList(rootNode);
    }

    public List<HashMap<String, String>> getEntryList(int last) throws Exception {
        return this.getEntryList(null, last);
    }

    public List<HashMap<String, String>> getEntryList(String response, int last) throws Exception {
        this.setRedfishResponse(response);
        this.collectList();
        this.reviseIndex(-1, -1, last);
        return this.entryMapList.subList(this.getLeftIndex(), this.getRightIndex());
    }

    public List<HashMap<String, String>> getEntryList(int beginIdx, int endIdx) throws Exception {
        return this.getEntryList(null, beginIdx, endIdx);
    }

    public List<HashMap<String, String>> getEntryList(String response, int beginIdx, int endIdx) throws Exception {
        this.setRedfishResponse(response);
        this.collectList();
        this.reviseIndex(beginIdx, endIdx, -1);
        return this.entryMapList.subList(this.getLeftIndex(), this.getRightIndex());
    }

    public int getEntryListCount() throws Exception {
        this.getEntryList();
        return this.entryMapList.size();
    }

    public String getRedfishResponse() {
        return this.responseStr;
    }

    public String updateEntryValue(String body, String keyPath, String value) throws Exception {
        return this.updateEntryValue(body, keyPath, (Object)value);
    }

    public String updateEntryValue(String body, String keyPath, Integer value) throws Exception {
        return this.updateEntryValue(body, keyPath, (Object)value);
    }

    public String updateEntryValue(String body, String keyPath, Boolean value) throws Exception {
        return this.updateEntryValue(body, keyPath, (Object)value);
    }

    public String updateEntryValue(String body, String keyPath, Object value) throws Exception {
        JsonNode rootNode = new ObjectMapper().readTree(body);
        JsonNode parentNode = this.getTargetNode(rootNode, keyPath);
        String nodeKey = this.getNodeKey(keyPath);
        ((ObjectNode)parentNode).remove(nodeKey);
        if (value instanceof String) {
            ((ObjectNode)parentNode).put(nodeKey, (String)value);
        } else if (value instanceof Integer) {
            ((ObjectNode)parentNode).put(nodeKey, (Integer)value);
        } else if (value instanceof Boolean) {
            ((ObjectNode)parentNode).put(nodeKey, (Boolean)value);
        }
        return rootNode.toString();
    }

    public String updateEntryValue(String body, HashMap<String, Object> entrySet) throws Exception {
        JsonNode rootNode = new ObjectMapper().readTree(body);
        entrySet.forEach((k, v) -> {
            JsonNode parentNode = this.getTargetNode(rootNode, (String)k);
            String nodeKey = this.getNodeKey((String)k);
            ((ObjectNode)parentNode).remove(nodeKey);
            if (v instanceof String) {
                ((ObjectNode)parentNode).put(nodeKey, (String)v);
            } else if (v instanceof Integer) {
                ((ObjectNode)parentNode).put(nodeKey, (Integer)v);
            } else if (v instanceof Boolean) {
                ((ObjectNode)parentNode).put(nodeKey, (Boolean)v);
            }
        });
        return rootNode.toString();
    }

    public String appendEntryArray(String body, String keyPath, String value) throws Exception {
        JsonNode rootNode = new ObjectMapper().readTree(body);
        JsonNode parentNode = this.getTargetNode(rootNode, keyPath);
        String nodeKey = this.getNodeKey(keyPath);
        ArrayNode nodes = (ArrayNode)((ObjectNode)parentNode).get(nodeKey);
        nodes.add(value);
        return rootNode.toString();
    }

    public String replaceEntryArray(String body, String key, String oldValue, String newValue) throws Exception {
        JsonNode rootNode = new ObjectMapper().readTree(body);
        JsonNode parentNode = this.getTargetNode(rootNode, key);
        String nodeKey = this.getNodeKey(key);
        ArrayNode nodes = (ArrayNode)((ObjectNode)parentNode).get(nodeKey);
        ArrayList nodeList = new ArrayList();
        ArrayList valueList = new ArrayList();
        nodes.iterator().forEachRemaining(nodeList::add);
        nodeList.forEach(n -> valueList.add(n.asText()));
        int removeIdx = valueList.indexOf(oldValue);
        if (removeIdx >= 0) {
            nodes.remove(removeIdx);
            if (null != newValue) {
                nodes.insert(removeIdx, newValue);
            }
        }
        return rootNode.toString();
    }

    public String removeEntryArray(String body, String key, String value) throws Exception {
        return this.replaceEntryArray(body, key, value, null);
    }

    public String appendEntryObject(String body, String key, HashMap<String, String> entrySet) throws Exception {
        JsonNode rootNode = new ObjectMapper().readTree(body);
        JsonNode targetNode = this.getTargetNode(rootNode, key);
        String nodeKey = this.getNodeKey(key);
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        Set<String> keySet = entrySet.keySet();
        keySet.forEach(k -> node.put((String)k, (String)entrySet.get(k)));
        JsonNode arrayNode = targetNode.get(nodeKey);
        ((ArrayNode)arrayNode).add(node);
        return rootNode.toString();
    }

    public String replaceEntryObject(String body, String keyPath, HashMap<String, String> oldEntrySet, HashMap<String, String> newEntrySet) throws Exception {
        JsonNode rootNode = new ObjectMapper().readTree(body);
        JsonNode targetNode = this.getTargetNode(rootNode, keyPath);
        String nodeKey = this.getNodeKey(keyPath);
        JsonNode arrayNode = targetNode.get(nodeKey);
        for (int index = 0; index < arrayNode.size(); ++index) {
            JsonNode node = arrayNode.get(index);
            Iterator<Map.Entry<String, JsonNode>> nodeIter = node.fields();
            ArrayList entrySetList = new ArrayList();
            nodeIter.forEachRemaining(entrySetList::add);
            boolean match = false;
            if (entrySetList.size() != oldEntrySet.size()) {
                match = false;
            } else {
                for (Map.Entry entry : entrySetList) {
                    String k2 = (String)entry.getKey();
                    String v = ((JsonNode)entry.getValue()).asText();
                    if (!oldEntrySet.get(k2).equals(v)) {
                        match = false;
                        break;
                    }
                    match = true;
                }
            }
            if (!match) continue;
            ((ArrayNode)arrayNode).remove(index);
            if (null == newEntrySet) break;
            ObjectNode newNode = JsonNodeFactory.instance.objectNode();
            Set<String> keySet = newEntrySet.keySet();
            keySet.forEach(k -> newNode.put((String)k, (String)newEntrySet.get(k)));
            ((ArrayNode)arrayNode).insert(index, newNode);
            break;
        }
        return rootNode.toString();
    }

    public String removeEntryObject(String body, String keyPath, HashMap<String, String> entrySet) throws Exception {
        return this.replaceEntryObject(body, keyPath, entrySet, null);
    }

    public String getPatchBody(IPMIInterfaceConfig config, String url) throws Exception {
        return this.getPatchBody(config, url, false);
    }

    public String getPatchBody(IPMIInterfaceConfig config, String url, boolean ignoreTypeError) throws Exception {
        int result = 0;
        String jsonBody = null;
        BasicAuthClient client = new BasicAuthClient(config);
        result = client.send_https_get(url);
        if (result >= 200 && 300 > result) {
            String get_response = client.getResponseString();
            result = client.send_https_patch(url, get_response);
            String patch_response = client.getResponseString();
            List<String> unknownPropertyList = this.getUnknownProperty(patch_response, ignoreTypeError);
            jsonBody = this.getJsonBody(unknownPropertyList, get_response);
        }
        return jsonBody;
    }

    public String getPatchBody(SessionLoginClient client, String url) throws Exception {
        return this.getPatchBody(client, url, false);
    }

    public String getPatchBody(SessionLoginClient client, String url, boolean ignoreTypeError) throws Exception {
        int result = 0;
        String jsonBody = null;
        result = client.send_https_get(url);
        if (result >= 200 && 300 > result) {
            String get_response = client.getResponseString();
            result = client.send_https_patch(url, get_response);
            String patch_response = client.getResponseString();
            List<String> unknownPropertyList = this.getUnknownProperty(patch_response, ignoreTypeError);
            jsonBody = this.getJsonBody(unknownPropertyList, get_response);
        }
        return jsonBody;
    }

    public String convertDatetimeFormat(String datetime) {
        if (null != datetime) {
            String datetimeDelimiter = "T";
            String timezoneDelimiter = "[-|+|Z]";
            String dateString = null;
            String timeString = null;
            String[] datetimeArray = datetime.split("T");
            if (datetimeArray.length > 0) {
                dateString = datetimeArray[0];
            }
            if (datetimeArray.length > 1) {
                String[] timezoneArray = datetimeArray[1].split("[-|+|Z]");
                timeString = timezoneArray.length > 0 ? timezoneArray[0] : datetimeArray[1];
            }
            return dateString + " " + timeString;
        }
        return datetime;
    }

    public void reviseIndex(int beginIdx, int endIdx, int last) {
        int lIndex = 0;
        int rIndex = 0;
        int entrySize = this.entryMapList.size();
        if (last < 0) {
            lIndex = beginIdx < entrySize ? beginIdx - 1 : entrySize;
            lIndex = lIndex < 0 ? 0 : lIndex;
            rIndex = endIdx <= entrySize ? endIdx : entrySize;
            rIndex = rIndex < 0 ? entrySize : rIndex;
        } else {
            lIndex = entrySize < last ? 0 : entrySize - last;
            rIndex = entrySize;
        }
        this.leftIndex = lIndex;
        this.rightIndex = rIndex;
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    private HashMap<String, String> collect() throws Exception {
        if (this.responseStr == null || this.responseStr.isEmpty()) {
            throw new Exception("Response buffer cannot be empty.");
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(this.responseStr);
        this.entryMap.clear();
        this.entryMap.putAll(this.collectEntry(rootNode));
        return this.entryMap;
    }

    private HashMap<String, String> collect(JsonNode rootNode) throws Exception {
        this.entryMap.clear();
        this.entryMap.putAll(this.collectEntry(rootNode));
        return this.entryMap;
    }

    private List<HashMap<String, String>> collectList() throws Exception {
        if (this.responseStr == null || this.responseStr.isEmpty()) {
            throw new Exception("Response buffer cannot be empty.");
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(this.responseStr);
        this.entryMapList.clear();
        this.entryMapList.addAll(this.collectEntryList(rootNode));
        return this.entryMapList;
    }

    private List<HashMap<String, String>> collectList(JsonNode rootNode) throws Exception {
        this.entryMapList.clear();
        this.entryMapList.addAll(this.collectEntryList(rootNode));
        return this.entryMapList;
    }

    private HashMap<String, String> collectEntry(JsonNode rootNode) throws Exception {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        entryMap = this.collectJsonNode(entryMap, rootNode, null);
        return entryMap;
    }

    private List<HashMap<String, String>> collectEntryList(JsonNode rootNode) throws Exception {
        ArrayList<HashMap<String, String>> entryList = new ArrayList<HashMap<String, String>>();
        for (JsonNode currentNode : rootNode) {
            if (!currentNode.isArray()) continue;
            for (JsonNode item : currentNode) {
                HashMap<String, String> entryMap = new HashMap<String, String>();
                entryMap = this.collectJsonNode(entryMap, item, null);
                entryList.add(entryMap);
            }
        }
        return entryList;
    }

    private HashMap<String, String> collectJsonNode(HashMap<String, String> collection, JsonNode currentNode, String keyPath) {
        Iterator<Map.Entry<String, JsonNode>> fields = currentNode.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> jsonField = fields.next();
            if (jsonField.getValue().isContainerNode() && !jsonField.getValue().isArray()) {
                collection = this.collectJsonNode(collection, jsonField.getValue(), this.updateKeyPath(keyPath, jsonField.getKey()));
                continue;
            }
            collection.put(this.updateKeyPath(keyPath, jsonField.getKey()), this.getJsonStringValue(jsonField.getValue()));
        }
        return collection;
    }

    private void setRedfishResponse(String resp) {
        if (null != resp) {
            this.responseStr = resp;
        }
    }

    private String getJsonStringValue(JsonNode node) {
        String value = null;
        if (node.isTextual()) {
            value = node.textValue();
        } else if (node.isBoolean()) {
            value = String.valueOf(node.asBoolean());
        } else if (node.isInt()) {
            value = String.valueOf(node.asInt());
        } else if (node.isNumber()) {
            value = node.asText();
        } else if (node.isArray()) {
            for (JsonNode curNode : node) {
                if (curNode.isObject()) {
                    Iterator<Map.Entry<String, JsonNode>> fields = curNode.fields();
                    while (fields.hasNext()) {
                        Map.Entry<String, JsonNode> jsonField = fields.next();
                        if (null == value) {
                            value = jsonField.getValue().textValue();
                            continue;
                        }
                        value = value + "\\" + jsonField.getValue().textValue();
                    }
                    continue;
                }
                if (!curNode.isTextual()) continue;
                if (null == value) {
                    value = curNode.textValue();
                    continue;
                }
                value = value + "\\" + curNode.textValue();
            }
        }
        return value;
    }

    private String updateKeyPath(String path, String currentKey) {
        return path == null ? currentKey : path + "/" + currentKey;
    }

    private List<String> getUnknownProperty(String patchResponse, boolean ignoreTypeError) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(patchResponse);
        JsonNode extendedInfoNode = rootNode.findPath("@Message.ExtendedInfo");
        ArrayList<String> unknownPropertyList = new ArrayList<String>();
        if (extendedInfoNode.isArray()) {
            for (int index = 0; index < extendedInfoNode.size(); ++index) {
                JsonNode element = extendedInfoNode.get(index);
                JsonNode messageIdProp = element.findValue("MessageId");
                String messageIdPropText = messageIdProp.asText();
                if (!messageIdPropText.contains("PropertyUnknown") && !messageIdPropText.contains("PropertyNotWritable") && (ignoreTypeError || !messageIdPropText.contains("PropertyValueTypeError"))) continue;
                JsonNode messageArgsNode = element.path("MessageArgs");
                if (messageArgsNode.isArray()) {
                    for (JsonNode node : messageArgsNode) {
                        if (node == null) continue;
                        unknownPropertyList.add(node.asText());
                    }
                    continue;
                }
                String unknownProp = messageArgsNode.get(0).asText();
                unknownPropertyList.add(unknownProp);
            }
        }
        return unknownPropertyList;
    }

    private String getJsonBody(List<String> unknownPropList, String response) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        for (String unknownPropKey : unknownPropList) {
            this.removeNode(rootNode, unknownPropKey);
        }
        return rootNode.toString();
    }

    private void removeNode(JsonNode jsonNode, String removeKey) {
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator<Map.Entry<String, JsonNode>> iter = objectNode.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                if (removeKey.equals(entry.getKey())) {
                    ((ObjectNode)jsonNode).remove(removeKey);
                    break;
                }
                this.removeNode(entry.getValue(), removeKey);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.removeNode(arrayNode.get(i), removeKey);
            }
        } else if (jsonNode.isValueNode()) {
            // empty if block
        }
    }

    private JsonNode getTargetNode(JsonNode rootNode, String keyPath) {
        JsonNode targetNode = rootNode;
        String targetKey = keyPath;
        if (keyPath.contains("/")) {
            String[] keys = keyPath.split("/");
            for (int index = 0; index < keys.length - 1; ++index) {
                targetNode = targetNode.findPath(keys[index]);
            }
            targetKey = keys[keys.length - 1];
        }
        return targetNode.findParent(targetKey);
    }

    private String getNodeKey(String keyPath) {
        String[] keys = keyPath.split("/");
        return keys[keys.length - 1];
    }
}

