/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.parser;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.trap.AsnDecodingException;
import com.supermicro.ipmi.trap.auth.AuthFactory;
import com.supermicro.ipmi.trap.auth.AuthGeneric;
import com.supermicro.ipmi.trap.parser.BaseParser;
import com.supermicro.ipmi.trap.privacy.PrivAES128;
import com.supermicro.ipmi.trap.privacy.PrivDES;
import com.supermicro.ipmi.trap.traps.BaseTrap;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import com.supermicro.ipmi.trap.traps.VariableBindings;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SNMPv3Parser
extends BaseParser {
    public static final byte PARSER_OK = 0;
    public static final byte PARSER_USERNAME_MISMATCH = 1;
    public static final byte PARSER_AUTHENTICATION_OK = 2;
    public static final byte PARSER_AUTHENTICATION_FAILED = 3;
    public static final byte PARSER_AUTHENTICATION_NOT_SUPPORT = 4;
    public static final byte PARSER_PRIVACY_OK = 5;
    public static final byte PARSER_PRIVACY_FAILED = 6;
    public static final byte PARSER_PRIVACY_NOT_SUPPORT = 7;
    public static final byte PARSER_LOAD_PDU_OK = 8;
    private byte errorCode = 0;
    private final Map<Byte, String> errorMessageMap = new HashMap<Byte, String>(){
        {
            this.put((byte)1, "Username is mismatch.");
            this.put((byte)2, "Authentication is OK.");
            this.put((byte)3, "Failed to authenticate, wrong authentication protocol or key?");
            this.put((byte)4, "Authentication protocol is not supported.");
            this.put((byte)5, "Privacy is OK.");
            this.put((byte)6, "Failed to decrypt, wrong decryption protocol or key?");
            this.put((byte)7, "Decryption protocol is not supported.");
            this.put((byte)8, "PDU load ok.");
        }
    };

    @Override
    public BaseTrap decode(byte[] dataBuffer, int dataLength) {
        SNMPv3Trap trap = new SNMPv3Trap();
        if (!this.preloadTrap(trap, dataBuffer)) {
            System.out.println("SNMPv3 trap load failed.");
            return null;
        }
        return trap;
    }

    public boolean isUsernameMatch(SNMPv3Trap trap, String username) {
        boolean isMatch = false;
        if (Arrays.equals(trap.getMsgUserName(), username.getBytes())) {
            isMatch = true;
        } else {
            this.setErrorCode((byte)1);
        }
        return isMatch;
    }

    public boolean isAuthenticated(SNMPv3Trap trap, byte[] authPassword, int authProtocol) {
        boolean result = false;
        AuthGeneric authGeneric = AuthFactory.getAuthenticator(authProtocol);
        if (null == authGeneric) {
            this.setErrorCode((byte)4);
            result = false;
        } else if (null == authPassword || authPassword.length < 8) {
            this.setErrorCode((byte)6);
            result = false;
        } else {
            byte[] localKey = this.getLocalizedKey(trap, authGeneric, authPassword, authProtocol);
            if (null == localKey) {
                result = false;
            } else {
                try {
                    result = authGeneric.isAuthentic(trap, localKey);
                    if (result) {
                        this.setErrorCode((byte)2);
                    } else {
                        this.setErrorCode((byte)3);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    this.setErrorCode((byte)4);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public byte[] decrypt(SNMPv3Trap trap, byte[] privPassword, int privacyProtocol, int authProtocol) {
        void var8_11;
        byte[] decryptedData = null;
        AuthGeneric authGeneric = AuthFactory.getAuthenticator(authProtocol);
        if (null == authGeneric) {
            this.setErrorCode((byte)4);
            return decryptedData;
        }
        if (null == privPassword || privPassword.length < 8) {
            this.setErrorCode((byte)6);
            return decryptedData;
        }
        byte[] localKey = this.getLocalizedKey(trap, authGeneric, privPassword, authProtocol);
        if (null == localKey) {
            return decryptedData;
        }
        Object var8_8 = null;
        if (privacyProtocol == 0) {
            PrivDES privDES = new PrivDES();
        } else {
            if (privacyProtocol != 1) {
                this.setErrorCode((byte)7);
                return decryptedData;
            }
            PrivAES128 privAES128 = new PrivAES128();
        }
        decryptedData = var8_11.decrypt(trap, localKey);
        if (null == decryptedData) {
            this.setErrorCode((byte)6);
            return decryptedData;
        }
        this.setErrorCode((byte)5);
        return decryptedData;
    }

    public boolean loadPDU(SNMPv3Trap trap, byte[] decryptedPDU) {
        int offset = 0;
        try {
            Object[] value = this.berDecoder.parseHeader(decryptedPDU, offset);
            offset = (Integer)value[0];
            value = this.berDecoder.parseString(decryptedPDU, offset);
            offset = (Integer)value[0];
            trap.setContextEngineID(ByteUtility.bytesToHex((byte[])value[2]));
            value = this.berDecoder.parseString(decryptedPDU, offset);
            offset = (Integer)value[0];
            trap.setContextName(ByteUtility.bytesToHex((byte[])value[2]));
            value = this.berDecoder.parseHeader(decryptedPDU, offset);
            offset = (Integer)value[0];
            value = this.berDecoder.parseInteger32(decryptedPDU, offset);
            offset = (Integer)value[0];
            value = this.berDecoder.parseInteger32(decryptedPDU, offset);
            offset = (Integer)value[0];
            value = this.berDecoder.parseInteger32(decryptedPDU, offset);
            offset = (Integer)value[0];
            this.getPDUBody(trap, decryptedPDU, offset, decryptedPDU.length);
        }
        catch (Exception e) {
            this.setErrorCode((byte)6);
            return false;
        }
        this.setErrorCode((byte)8);
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessageMap.get(this.errorCode);
    }

    public void setup() {
        this.errorCode = 0;
    }

    public boolean isLoadSuccessful() {
        return this.errorCode == 8;
    }

    private void setErrorCode(byte code) {
        if (code > this.errorCode) {
            this.errorCode = code;
        }
    }

    private int getPDUBody(SNMPv3Trap trap, byte[] databuff, int offset, int datalength) throws Exception {
        offset = this.getVariableBindingsLength(trap, this.berDecoder.parseHeader(databuff, offset));
        while (offset < datalength) {
            VariableBindings varBindings = new VariableBindings();
            offset = this.getBindLength(trap, varBindings, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getBind(trap, varBindings, databuff, offset);
            trap.setVariableBindingsList(varBindings);
        }
        return offset;
    }

    private boolean preloadTrap(SNMPv3Trap trap, byte[] dataBuffer) {
        try {
            int offset = 0;
            offset = this.getHeader(dataBuffer, offset, trap);
            offset = this.getMsgVersion(dataBuffer, offset, trap);
            offset = this.getMsgGlobalData(dataBuffer, offset);
            offset = this.getMsgAuthoritativeEngineID(dataBuffer, offset, trap);
            offset = this.getMsgAuthoritativeEngineBoots(dataBuffer, offset, trap);
            offset = this.getMsgAuthoritativeEngineTime(dataBuffer, offset, trap);
            offset = this.getMsgUsername(dataBuffer, offset, trap);
            offset = this.getMsgAuthoritativeParameters(dataBuffer, offset, trap);
            offset = this.getMsgPrivacyParameters(dataBuffer, offset, trap);
            offset = this.getMsgData(dataBuffer, offset, trap);
            trap.setMsgWholeMsg(dataBuffer, trap.getWholeMsgLength());
            return true;
        }
        catch (AsnDecodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    private byte[] getLocalizedKey(SNMPv3Trap trap, AuthGeneric authGeneric, byte[] password, int authProtocol) {
        byte[] localKey = null;
        if (null == authGeneric) {
            this.setErrorCode((byte)4);
        } else {
            try {
                localKey = authGeneric.passwordToKey(authProtocol, password, trap.getMsgAuthoritativeEngineID());
                if (null == localKey) {
                    this.setErrorCode((byte)4);
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                this.setErrorCode((byte)4);
            }
        }
        return localKey;
    }

    private int getHeader(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseHeader(dataBuffer, offset);
        trap.setWholeMsgLength((Integer)value[2] + (Integer)value[0]);
        return (Integer)value[0];
    }

    private int getMsgVersion(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseInteger32(dataBuffer, offset);
        trap.setMsgVersion((Integer)value[2]);
        return (Integer)value[0];
    }

    private int getMsgGlobalData(byte[] dataBuffer, int offset) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseHeader(dataBuffer, offset);
        offset = (Integer)value[0];
        value = this.berDecoder.parseInteger32(dataBuffer, offset);
        offset = (Integer)value[0];
        value = this.berDecoder.parseInteger32(dataBuffer, offset);
        offset = (Integer)value[0];
        value = this.berDecoder.parseInteger32(dataBuffer, offset);
        offset = (Integer)value[0];
        value = this.berDecoder.parseInteger32(dataBuffer, offset);
        offset = (Integer)value[0];
        offset += this.getUnknownOctetString(dataBuffer, offset);
        return offset;
    }

    private int getMsgAuthoritativeEngineID(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseString(dataBuffer, offset);
        byte[] valusByte = (byte[])value[2];
        trap.setMsgAuthoritativeEngineID(valusByte);
        return (Integer)value[0];
    }

    private int getMsgAuthoritativeEngineBoots(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseInteger32(dataBuffer, offset);
        trap.setMsgAuthoritativeEngineBoots(((Integer)value[2]).intValue());
        return (Integer)value[0];
    }

    private int getMsgAuthoritativeEngineTime(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseInteger32(dataBuffer, offset);
        trap.setMsgAuthoritativeEngineTime(((Integer)value[2]).intValue());
        return (Integer)value[0];
    }

    private int getMsgUsername(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseString(dataBuffer, offset);
        byte[] valusByte = (byte[])value[2];
        trap.setMsgAuthenticationParametersOffset((Integer)value[0] + 2);
        trap.setMsgUserName(valusByte);
        return (Integer)value[0];
    }

    private int getMsgAuthoritativeParameters(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseString(dataBuffer, offset);
        byte[] valusByte = (byte[])value[2];
        trap.setMsgAuthenticationParameters(valusByte);
        return (Integer)value[0];
    }

    private int getMsgPrivacyParameters(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] value = this.berDecoder.parseString(dataBuffer, offset);
        byte[] valusByte = (byte[])value[2];
        trap.setMsgPrivacyParameters(valusByte);
        return (Integer)value[0];
    }

    private int getMsgData(byte[] dataBuffer, int offset, SNMPv3Trap trap) throws AsnDecodingException {
        Object[] hdrVals = this.berDecoder.parseHeader(dataBuffer, offset);
        Object[] value = this.berDecoder.parseString(dataBuffer, offset);
        byte[] valusByte = (byte[])value[2];
        trap.setEncryptedPDULength(valusByte.length);
        trap.setEncryptedPDUOffset((Integer)hdrVals[0]);
        return (Integer)value[0];
    }

    private int getUnknownOctetString(byte[] wholeMsg, int offset) {
        if (wholeMsg[offset] == 4) {
            int oft = 1;
            for (int idx = 0; idx < 64 && wholeMsg[offset + oft] != 4; ++idx) {
                ++oft;
            }
            return oft;
        }
        return -1;
    }

    private int getVariableBindingsLength(SNMPv3Trap trap, Object[] value) {
        int objValue = (Integer)value[0];
        trap.setVariableBindingsLength((Integer)value[2]);
        return objValue;
    }

    private int getBindLength(SNMPv3Trap trap, VariableBindings varBindings, Object[] value) {
        int objValue = (Integer)value[0];
        varBindings.setVarBindLength((Integer)value[2]);
        return objValue;
    }

    private int getBind(SNMPv3Trap trap, VariableBindings varBindings, byte[] dataBuffer, int oidOffset) throws AsnDecodingException, UnsupportedEncodingException {
        String oIDKey = null;
        int oIDValueOffset = 0;
        int nextSMIOffset = 0;
        Object[] value = this.berDecoder.parseObjectId(dataBuffer, oidOffset);
        oIDKey = this.getOIDName(value);
        oIDValueOffset = this.getOIDValueOffset(value);
        nextSMIOffset = this.SMIHandler(trap, varBindings, dataBuffer, oIDKey, oIDValueOffset);
        return nextSMIOffset;
    }

    private String getOIDName(Object[] objValues) {
        String oidName = "";
        int[] oidValues = (int[])objValues[2];
        for (int i = 0; i < oidValues.length; ++i) {
            oidName = oidName + oidValues[i];
            if (i == oidValues.length - 1) continue;
            oidName = oidName + ".";
        }
        return oidName;
    }

    private int getOIDValueOffset(Object[] objValues) {
        return (Integer)objValues[0];
    }

    private int SMIHandler(SNMPv3Trap trap, VariableBindings varBindings, byte[] dataBuffer, String oIDKey, int oIDValueOffset) throws AsnDecodingException, UnsupportedEncodingException {
        varBindings.setVarBindOID(oIDKey);
        if (oIDKey.contentEquals("1.3.6.1.2.1.1.3.0")) {
            return this.getSystemUpTime(varBindings, dataBuffer, oIDValueOffset);
        }
        if (oIDKey.contentEquals("1.3.6.1.6.3.1.1.4.1.0")) {
            return this.getSNMPTrapOID(varBindings, dataBuffer, oIDValueOffset);
        }
        if (oIDKey.contentEquals("1.3.6.1.4.1.21317.1.0") || oIDKey.startsWith("1.3.6.1.4.1.3183.1.1") && oIDKey.endsWith("0")) {
            return this.getPETEVT(varBindings, dataBuffer, oIDValueOffset);
        }
        if (oIDKey.contentEquals("1.3.6.1.4.1.21317.1.3.1.1") || oIDKey.startsWith("1.3.6.1.4.1.3183.1.1") && oIDKey.endsWith("2")) {
            return this.getSensorNumber(varBindings, trap, dataBuffer, oIDValueOffset);
        }
        if (oIDKey.contentEquals("1.3.6.1.4.1.21317.1.18.1.3")) {
            return this.getSensorName(varBindings, trap, dataBuffer, oIDValueOffset, false);
        }
        if (oIDKey.startsWith("1.3.6.1.4.1.3183.1.1") && oIDKey.endsWith("1")) {
            return this.getSensorName(varBindings, trap, dataBuffer, oIDValueOffset, true);
        }
        if (oIDKey.contentEquals("1.3.6.1.4.1.21317.1.18.1.4") || oIDKey.startsWith("1.3.6.1.4.1.3183.1.1") && oIDKey.endsWith("4")) {
            return this.getSensorType(varBindings, trap, dataBuffer, oIDValueOffset);
        }
        if (oIDKey.contentEquals("1.3.6.1.4.1.21317.1.18.1.5") || oIDKey.startsWith("1.3.6.1.4.1.3183.1.1") && oIDKey.endsWith("5")) {
            return this.getDescription(varBindings, trap, dataBuffer, oIDValueOffset);
        }
        if (oIDKey.contentEquals("1.3.6.1.4.1.21317.1.18.1.6") || oIDKey.startsWith("1.3.6.1.4.1.3183.1.1") && oIDKey.endsWith("3")) {
            return this.getRawData(varBindings, trap, dataBuffer, oIDValueOffset);
        }
        return -1;
    }

    private int getSystemUpTime(VariableBindings varBindings, byte[] dataBuffer, int oIDValueOffset) throws AsnDecodingException {
        Object[] objs = this.berDecoder.parseInteger32(dataBuffer, oIDValueOffset);
        varBindings.setVarBindValue(String.valueOf(objs[2]));
        return (Integer)objs[0];
    }

    private int getSNMPTrapOID(VariableBindings varBindings, byte[] dataBuffer, int oIDValueOffset) throws AsnDecodingException {
        Object[] objs = this.berDecoder.parseObjectId(dataBuffer, oIDValueOffset);
        varBindings.setVarBindValue(this.getOIDName(objs));
        return (Integer)objs[0];
    }

    private int getPETEVT(VariableBindings varBindings, byte[] dataBuffer, int oIDValueOffset) throws AsnDecodingException {
        Object[] objs = this.berDecoder.parseString(dataBuffer, oIDValueOffset);
        byte[] bytes = (byte[])objs[2];
        varBindings.setVarBindValue(ByteUtility.bytesToHex(bytes));
        return (Integer)objs[0];
    }

    private int getSensorNumber(VariableBindings varBindings, SNMPv3Trap trap, byte[] dataBuffer, int oIDValueOffset) throws AsnDecodingException {
        Object[] objs = this.berDecoder.parseInteger32(dataBuffer, oIDValueOffset);
        varBindings.setVarBindValue(String.valueOf(objs[2]));
        return (Integer)objs[0];
    }

    private int getSensorName(VariableBindings varBindings, SNMPv3Trap trap, byte[] dataBuffer, int oIDValueOffset, boolean isHW1Case) throws AsnDecodingException, UnsupportedEncodingException {
        Object[] objs = null;
        if (isHW1Case) {
            objs = this.berDecoder.parseInteger32(dataBuffer, oIDValueOffset);
            trap.setSelSensorName(String.valueOf((Integer)objs[2]));
        } else {
            objs = this.berDecoder.parseString(dataBuffer, oIDValueOffset);
            byte[] bytes = (byte[])objs[2];
            trap.setSelSensorName(new String(bytes, "UTF-8"));
        }
        varBindings.setVarBindValue(trap.getSelSensorName());
        return (Integer)objs[0];
    }

    private int getSensorType(VariableBindings varBindings, SNMPv3Trap trap, byte[] dataBuffer, int oIDValueOffset) throws AsnDecodingException, UnsupportedEncodingException {
        Object[] objs = this.berDecoder.parseString(dataBuffer, oIDValueOffset);
        byte[] bytes = (byte[])objs[2];
        trap.setSelSensorType(new String(bytes, "UTF-8"));
        varBindings.setVarBindValue(trap.getSelSensorType());
        return (Integer)objs[0];
    }

    private int getDescription(VariableBindings varBindings, SNMPv3Trap trap, byte[] dataBuffer, int oIDValueOffset) throws AsnDecodingException, UnsupportedEncodingException {
        Object[] objs = this.berDecoder.parseString(dataBuffer, oIDValueOffset);
        byte[] btyes = (byte[])objs[2];
        trap.setSelDescription(new String(btyes, "UTF-8"));
        varBindings.setVarBindValue(trap.getSelDescription());
        return (Integer)objs[0];
    }

    private int getRawData(VariableBindings varBindings, SNMPv3Trap trap, byte[] dataBuffer, int oIDValueOffset) throws AsnDecodingException, UnsupportedEncodingException {
        Object[] objs = this.berDecoder.parseString(dataBuffer, oIDValueOffset);
        byte[] btyes = (byte[])objs[2];
        trap.setSelRawData(ByteUtility.bytesToHex(btyes));
        varBindings.setVarBindValue(trap.getSelRawData());
        return (Integer)objs[0];
    }
}

