/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.deploy;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.deploy.DeployAbstractTask;

public class DeployTarget {
    public String name;
    public IPMIInterfaceConfig lanConfig;
    public DeployAbstractTask deployTask = null;

    public DeployTarget(IPMIInterfaceConfig lanConfig, String name) {
        this.lanConfig = lanConfig;
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDeployTask(DeployAbstractTask deployTask) {
        this.deployTask = deployTask;
    }

    public void setConfig(IPMIInterfaceConfig config) {
        this.lanConfig = config;
    }

    public String getName() {
        return this.name;
    }

    public DeployAbstractTask getDeployTask() {
        return this.deployTask;
    }

    public IPMIInterfaceConfig getConfig() {
        return this.lanConfig;
    }

    public String getStatus() throws IPMIException {
        String filename = "";
        String status = "";
        int action = 0;
        if (this.deployTask != null) {
            try {
                action = this.deployTask.getAction();
                filename = this.deployTask.getFilename();
                if (filename == null) {
                    filename = "";
                }
            }
            catch (IPMIException ex) {
                action = -1;
                filename = "";
            }
        }
        String formatTemplate = "%-24s | %-15s | %-28s\n";
        StringBuffer formatedString = new StringBuffer();
        String title = this.lanConfig.getIp() + "(" + this.name + ")";
        switch (action) {
            case -1: {
                status = "Unknown";
                break;
            }
            case 0: {
                status = "Action 0x00";
                break;
            }
            case 1: {
                status = "Refresh BIOS in progress";
                break;
            }
            case 2: {
                status = "Checking BIOS version";
                break;
            }
            case 3: {
                status = "Refresh BIOS OK";
                break;
            }
            case 4: {
                status = "Refresh BIOS failed";
                break;
            }
            default: {
                status = "Unknown";
            }
        }
        formatedString.append(String.format(formatTemplate, title, filename, status));
        return formatedString.toString();
    }
}

