/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.deploy;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.deploy.DeployTarget;

public abstract class DeployAbstractTask
implements Runnable {
    public static final byte INVALID_ACTION = 0;
    public static final byte REFRESH_BIOS_ACTION = 1;
    public static final byte CHECK_BIOS_VERSION_ACTION = 2;
    public static final byte SUCCESS_REFRESH_BIOS = 3;
    public static final byte FAIL_REFRESH_BIOS = 4;
    public static final byte REFRESH_IPMI_ACTION = 17;
    public static final byte CHECK_IPMI_VERSION_ACTION = 18;
    public static final byte SUCCESS_REFRESH_IPMI = 19;
    public static final byte FAIL_REFRESH_IPMI = 20;
    public DeployTarget deployTarget;
    public String isoFilename;

    public DeployAbstractTask(DeployTarget deployTarget) {
        this.deployTarget = deployTarget;
    }

    public abstract void mountVM() throws Exception;

    public abstract void unMountVM() throws Exception;

    public void doTask() {
        try {
            this.mountVM();
            this.wait(2);
            this.setAction((byte)1);
            this.wait(2);
            try {
                this.setAttachMode();
                this.setBootOption();
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
            this.powerUpTarget();
            this.wait(5);
            this.resetTarget();
        }
        catch (IPMIException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void wait(int sec) {
        try {
            Thread.sleep(sec * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.doTask();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setAction(byte action) throws IPMIException {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiMessagingCommand);
        ipmiMessagingCommand.setUserNameBinByID((byte)10, action);
        sessionController.closeSession();
    }

    public byte getAction() throws IPMIException {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiMessagingCommand);
        byte value = ipmiMessagingCommand.getUserNameBinByID((byte)10);
        sessionController.closeSession();
        return value;
    }

    public String getFilename() throws IPMIException {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiMessagingCommand);
        String value = ipmiMessagingCommand.getUserNameByID((byte)9);
        sessionController.closeSession();
        return value;
    }

    public void clear() throws IPMIException, Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiMessagingCommand);
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.deployTarget.getConfig().getIp());
        if (IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
            ipmiMessagingCommand.clearUserNameByFill0XFF((byte)9);
            ipmiMessagingCommand.clearUserNameByFill0XFF((byte)10);
        } else {
            ipmiMessagingCommand.setUserNameByID((byte)9, "");
            ipmiMessagingCommand.setUserNameByID((byte)10, "");
        }
        sessionController.closeSession();
        this.unMountVM();
    }

    private void resetTarget() throws IPMIException {
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiChassisCommand);
        ipmiChassisCommand.reset();
        sessionController.closeSession();
    }

    private void powerUpTarget() throws IPMIException {
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiChassisCommand);
        ipmiChassisCommand.powerUp();
        sessionController.closeSession();
    }

    private void setAttachMode() throws IPMIException {
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiAMIOEMCommand);
        ipmiAMIOEMCommand.setVirtualMediaAttachMode((byte)0);
        sessionController.closeSession();
    }

    private void setBootOption() throws IPMIException {
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerEx(this.deployTarget.getConfig(), ipmiChassisCommand);
        ipmiChassisCommand.setBootDeviceOption(GlobalDefine.BootDevice.FLOPPY_REMOVABLE_MEDIA);
        sessionController.closeSession();
    }

    public String getIsoFilename() {
        return this.isoFilename;
    }

    public void setIsoFilename(String isoFilename) {
        this.isoFilename = isoFilename;
    }
}

