/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.UserAccountHelper;

public class UserDeleteCommand
extends SuperBladeCommand {
    byte userID;
    private UserAccountHelper helper = new UserAccountHelper();

    @Override
    public boolean preValidate() {
        if (this.config.getPrivilege() != 4) {
            MOut.G(this).println("Your privilege is not enough to do this action");
            return false;
        }
        String usage = "Usage: user delete <user id>";
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!UserAccountHelper.isValidUserID(this.parameters[0])) {
            MOut.G(this).println("user id is out of range");
            MOut.G(this).println(usage);
            return false;
        }
        if (UserAccountHelper.isReservedUserID(this.parameters[0])) {
            MOut.G(this).println("The user id has been reserved.");
            MOut.G(this).println(usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        boolean isLegacyDevice = IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid);
        int result = this.helper.deleteUser(ipmiMessagingCommand, this.userID, isLegacyDevice);
        switch (result) {
            case 0: {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                break;
            }
            case 17: {
                MOut.G(this).println("user id should be 1-" + this.helper.getNumberOfAvailableUser(ipmiMessagingCommand));
                this.statusCode = 149;
                break;
            }
            case 13: {
                MOut.G(this).println("disable user failed");
                this.statusCode = 149;
                break;
            }
            case 14: {
                MOut.G(this).println("clear user privilege failed");
                this.statusCode = 149;
                break;
            }
            case 15: {
                MOut.G(this).println("clear user password failed");
                this.statusCode = 149;
                break;
            }
            case 16: {
                MOut.G(this).println("clear user name failed");
                this.statusCode = 149;
                break;
            }
            default: {
                MOut.G(this).println("Unknown error");
                this.statusCode = 149;
            }
        }
    }
}

