/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMStatCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        byte id = -1;
        if (this.parameters != null && this.parameters.length == 1) {
            try {
                id = Byte.parseByte(this.parameters[0]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).print(ex.getMessage());
                this.statusCode = 147;
                return;
            }
        }
        IPMIDCMOEMCommand.NodeManagerStatistics stat = null;
        try {
            stat = ipmiDCMOEMCommand.getNodeManagerStatistics((byte)(this.parameters == null ? 1 : 17), (byte)0, id);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (stat == null) {
            MOut.G(this).println("Call getNodeManagerStatistics failed");
        }
        if (this.parameters == null) {
            MOut.G(this).println("Global Power statistic");
        } else {
            MOut.G(this).println("Policy Id = " + id);
        }
        if ((stat.domainIdAndPolicyState & 0x40) != 64) {
            MOut.G(this).println("Measurements are suspended");
            this.statusCode = 0;
            return;
        }
        MOut.G(this).println("Current = " + ByteUtility.twoBytesToInt(stat.current) + " w");
        MOut.G(this).println("Minimum = " + ByteUtility.twoBytesToInt(stat.minimum) + " w");
        MOut.G(this).println("Maximum = " + ByteUtility.twoBytesToInt(stat.maximum) + " w");
        MOut.G(this).println("Average = " + ByteUtility.twoBytesToInt(stat.average) + " w");
        MOut.G(this).println("Time    = " + ByteUtility.fourByteToDateFormat2(stat.timeStamp));
        MOut.G(this).println("Reporting Period = " + ByteUtility.fourBytesToIntByLSBFirst(stat.statisticsReportingPeriod) + " sec");
        if (id == -1) {
            if ((stat.domainIdAndPolicyState & 0x10) == 16) {
                MOut.G(this).println("Node Manager is enabled");
            } else {
                MOut.G(this).println("Node Manager is not enabled");
            }
        } else if ((stat.domainIdAndPolicyState & 0x10) == 16) {
            MOut.G(this).println("Policy is enabled and Node Manager is Globally Enabled");
        } else {
            MOut.G(this).println("Policy is not enabled");
        }
        if ((stat.domainIdAndPolicyState & 0x40) == 64) {
            MOut.G(this).println("Measurements in progress");
        } else {
            MOut.G(this).println("Measurements are suspended");
        }
        this.statusCode = 0;
    }
}

