/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;

public class NMPolicyDto {
    public final int domainId;
    public final int state;
    public final int triggerTypeId;
    public final int aggMode;
    public final int expAction;
    public final byte[] targetLimit;
    public final int corrTime;
    public final int triggerLimit;
    public final int statPeriod;

    public NMPolicyDto(IPMINM20Command.NodeManagerPolicy policy) {
        this.domainId = policy.domainIDAndPolicyState & 0xF;
        this.state = (policy.domainIDAndPolicyState & 0xF0) >> 4;
        this.triggerTypeId = policy.policyAndTriggerType & 0xF;
        this.aggMode = (policy.policyAndTriggerType & 0x60) >> 5;
        this.expAction = policy.policyException & 3;
        this.targetLimit = policy.powerLimit;
        this.corrTime = ByteUtility.fourBytesToIntByLSBFirst(policy.correctionTimeLimit);
        this.triggerLimit = ByteUtility.twoBytesToIntLSB(policy.policyTriggerLimit);
        this.statPeriod = ByteUtility.twoBytesToIntLSB(policy.statisticsReportingPeriod);
    }

    public static String domainParse(int id) {
        return Common.Domain.getDesc(id);
    }

    public static String triggerTypeParse(int id) {
        switch (id) {
            case 0: {
                return "No Policy Trigger";
            }
            case 1: {
                return "Inlet Temperature Limit";
            }
            case 2: {
                return "Missing Power Reading Timeout";
            }
            case 3: {
                return "Time After Host Reset";
            }
            case 4: {
                return "Boot Time Policy";
            }
            case 6: {
                return "MGPIO Policy Trigger";
            }
        }
        return "Undefined";
    }

    public static String aggressiveCPUModeParse(int mode) {
        switch (mode) {
            case 0: {
                return "Backward compatible with NMV1.5";
            }
            case 2: {
                return "NM is not allowed to use T-states";
            }
            case 4: {
                return "NM is allowed to use T-states";
            }
        }
        return "Undefined";
    }

    public static String exceptionActionParse(int actCode) {
        switch (actCode) {
            case 1: {
                return "Send alert";
            }
            case 2: {
                return "Shutdown system";
            }
        }
        return "Undefined";
    }

    public static String targetLimitParse(int triggerTypeId, byte[] limitInBytes) {
        switch (triggerTypeId) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                return ByteUtility.twoBytesToIntLSB(limitInBytes) + " W";
            }
            case 2: {
                return ByteUtility.twoBytesToIntLSB(limitInBytes) + " %";
            }
            case 4: {
                return (limitInBytes[0] & 1) == 1 ? "perf" : "pw";
            }
        }
        return "N/A";
    }

    public static String triggerLimitParse(int triggerTypeId, int limit) {
        switch (triggerTypeId) {
            case 1: {
                return limit + " C";
            }
            case 2: 
            case 3: {
                return String.format("%.1f s", Float.valueOf((float)limit / 10.0f));
            }
        }
        return "N/A";
    }

    public String getDomain() {
        return NMPolicyDto.domainParse(this.domainId);
    }

    public boolean isGlobalEnable() {
        return (this.state & 4) == 4;
    }

    public boolean isDomainEnable() {
        return (this.state & 2) == 2;
    }

    public boolean isPolicyEnable() {
        return (this.state & 1) == 1;
    }

    public String getTriggerType() {
        return NMPolicyDto.triggerTypeParse(this.triggerTypeId);
    }

    public String getAggressiveCPUMode() {
        return NMPolicyDto.aggressiveCPUModeParse(this.aggMode);
    }

    public String getExceptionAction() {
        return NMPolicyDto.exceptionActionParse(this.expAction);
    }

    public int getTargetLimit() {
        return ByteUtility.twoBytesToIntLSB(this.targetLimit);
    }

    public String targetLimitWithUnit() {
        return NMPolicyDto.targetLimitParse(this.triggerTypeId, this.targetLimit);
    }

    public String triggerLimitWithUnit() {
        return NMPolicyDto.triggerLimitParse(this.triggerTypeId, this.triggerLimit);
    }
}

