/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.nm.GetNodeManagerPolicySuspendPeriods;
import com.supermicro.ipmi.nm.PolicySuspendPeriods;
import com.supermicro.ipmi.nm.SetNodeManagerPolicySuspendPeriods;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;
import com.supermicro.ipmi.text.nm.suspendperiod.AbstractSuspenPeriodCommand;

public class NM20SetSuspendPeriodsCommand
extends NM20AbstractCommand {
    private AbstractSuspenPeriodCommand spc;
    private ACTION act;

    public NM20SetSuspendPeriodsCommand(ACTION act) {
        this.act = act;
    }

    @Override
    public boolean preValidate() {
        try {
            this.spc = AbstractSuspenPeriodCommand.getCommand(this.act, this.parameters);
            return true;
        }
        catch (NumberFormatException ex) {
            if (ex.getMessage() != null) {
                MOut.G(this).println(ex.getMessage());
            }
            return false;
        }
        catch (IllegalArgumentException ex) {
            if (ex.getMessage() != null) {
                MOut.G(this).println(ex.getMessage());
            }
            return false;
        }
    }

    @Override
    public void runNM20Command() throws Exception {
        try {
            PolicySuspendPeriods currentPeriod = this.getSuspendPeriod();
            if (this.act == ACTION.ADD && currentPeriod.numOfPeriods == 5) {
                MOut.G(this).println("The number of periods has reached to maximum.(5)");
                this.statusCode = 0;
                return;
            }
            byte[] newPeriods = this.spc.getNewPeriod(currentPeriod.getRawOfPeriods());
            SetNodeManagerPolicySuspendPeriods command = new SetNodeManagerPolicySuspendPeriods(this.ipmiNM20Command, (byte)this.spc.getDomainId(), (byte)this.spc.getPolicyId(), newPeriods.length / 3, newPeriods);
            command.execute();
            MOut.G(this).println("Done");
            MOut.G(this).println("=============================================");
            MOut.G(this).println("Domain ID = " + this.spc.getDomainId() + " , Policy ID = " + this.spc.getPolicyId());
            MOut.G(this).println("=============================================");
            currentPeriod = this.getSuspendPeriod();
            currentPeriod.toReadableString();
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private PolicySuspendPeriods getSuspendPeriod() throws IPMIException {
        GetNodeManagerPolicySuspendPeriods command = new GetNodeManagerPolicySuspendPeriods(this.ipmiNM20Command);
        return command.execute((byte)this.spc.getDomainId(), (byte)this.spc.getPolicyId());
    }

    public static enum ACTION {
        ADD,
        UPDATE,
        DELETE,
        CLEAR;

    }
}

