/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20CapCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("cap <domain ID> <Trigger Type>");
            MOut.G(this).println("Domain ID:");
            MOut.G(this).println("0 \u00a1V Entire platform");
            MOut.G(this).println("1 \u00a1V CPU subsystem");
            MOut.G(this).println("2 \u00a1V Memory subsystem");
            MOut.G(this).println("3 \u00a1V HW Protection (NM3.0)");
            MOut.G(this).println("4 \u00a1V High Power I/O subsystem");
            MOut.G(this).println("Policy Trigger Type:");
            MOut.G(this).println("0 \u00a1V No Policy Trigger");
            MOut.G(this).println("1 \u00a1V Inlet Temperature Policy Trigger value in [Celsius]");
            MOut.G(this).println("2 \u00a1V Missing Power Reading Timeout in 1/10th of second");
            MOut.G(this).println("3 \u00a1V Time After Host Reset Trigger in 1/10th of second");
            MOut.G(this).println("4 \u00a1V Boot time policy");
            MOut.G(this).println("6 \u00a1V MGPIO Policy Trigger");
            this.statusCode = 0;
            return;
        }
        byte did = -1;
        try {
            did = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        int ptt = -1;
        try {
            ptt = Byte.parseByte(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMINM20Command.NodeManagerCapabilities cap = null;
        try {
            cap = this.ipmiNM20Command.getNodeManagerCapabilities(did, (byte)(ptt | 0x10));
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (cap == null) {
            MOut.G(this).println("Call getNodeManagerCapabilities failed");
        }
        MOut.G(this).println("Max concurrent settings            = " + cap.maxCurrentSettings);
        MOut.G(this).println("Max Power/Thermal/Time After Reset = " + ByteUtility.twoBytesToIntLSB(cap.maxValue));
        MOut.G(this).println("Min Power/Thermal/Time After Reset = " + ByteUtility.twoBytesToIntLSB(cap.minValue));
        MOut.G(this).println("Max Correction Time settable       = " + ByteUtility.fourBytesToIntByLSBFirst(cap.maxCorrectionTime) + " ms");
        MOut.G(this).println("Min Correction Time settable       = " + ByteUtility.fourBytesToIntByLSBFirst(cap.minCorrectionTime) + " ms");
        MOut.G(this).println("Max Statistics Reporting period    = " + ByteUtility.twoBytesToIntLSB(cap.maxStatisticsReportingPeriod) + " s");
        MOut.G(this).println("Min Statistics Reporting period    = " + ByteUtility.twoBytesToIntLSB(cap.minStatisticsReportingPeriod) + " s");
        MOut.G(this).println("Domain ID:");
        if ((cap.domainLimitingScope & 0xF) == 0) {
            MOut.G(this).println("    Entire platform");
        } else if ((cap.domainLimitingScope & 0xF) == 1) {
            MOut.G(this).println("    CPU subsystem");
        } else if ((cap.domainLimitingScope & 0xF) == 2) {
            MOut.G(this).println("    Memory subsystem");
        } else if ((cap.domainLimitingScope & 0xF) == 3) {
            MOut.G(this).println("    HW Protection");
        } else if ((cap.domainLimitingScope & 0xF) == 4) {
            MOut.G(this).println("    High Power I/O subsystem");
        }
        MOut.G(this).println("Limiting based on:");
        if ((byte)(cap.domainLimitingScope & 0x80) == -128) {
            MOut.G(this).println("    Wall input power. PSU input power");
        } else {
            MOut.G(this).println("    DC power - PSU output power or bladed system");
        }
        MOut.G(this).println("raw = " + ByteUtility.bytesToHex(cap.raw));
        this.statusCode = 0;
    }
}

