/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public abstract class NM20AbstractCommand
extends SuperBladeCommand {
    protected IPMINM20Command ipmiNM20Command = null;
    IPMISDRCommand ipmiSDRCommand = null;
    protected IPMIInterface ipmiInterfaceForNM = null;

    public abstract void runNM20Command() throws Exception;

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        GlobalDefine.PAUSE_DEBUG = true;
        this.ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = this.ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            this.ipmiNM20Command = new IPMINM20Command(ipmb);
            this.ipmiInterfaceForNM = ipmb;
        } else {
            this.ipmiNM20Command = new IPMINM20Command(this.ipmiCMMOEMCommand.getIPMIInterface());
            this.ipmiInterfaceForNM = this.ipmiCMMOEMCommand.getIPMIInterface();
        }
        GlobalDefine.PAUSE_DEBUG = false;
        this.runNM20Command();
    }
}

