/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.MidplaneFRUCommand;
import com.supermicro.ipmi.MidplaneSystemInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MidplaneFRUReadCommand
extends SuperBladeCommand {
    String field;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            this.printUsage();
            return false;
        }
        this.field = this.parameters[0].toUpperCase();
        if (this.field.equals("CT") || this.field.equals("CP") || this.field.equals("CS") || this.field.equals("SGP") || this.field.equals("PPM") || this.field.equals("ZON") || this.field.equals("PS") || this.field.equals("PAT") || this.field.equals("PM") || this.field.equals("PN") || this.field.equals("PV")) {
            return true;
        }
        MOut.G(this).println("Invalid field.");
        MOut.G(this).println("");
        this.printUsage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        MidplaneFRUCommand midplaneFRUCommand = new MidplaneFRUCommand(null);
        midplaneFRUCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.field.equals("SGP") || this.field.equals("ZON")) {
            MidplaneSystemInfo mid = new MidplaneSystemInfo();
            mid.fromRaw(midplaneFRUCommand.getSystemInfoStructure());
            if (this.field.equals("SGP")) {
                MOut.G(this).println("SGPIO  = " + mid.getSGPIOMode());
            } else if (this.field.equals("ZON")) {
                MOut.G(this).println("Zoning mode = " + mid.getZoneConfig());
            }
        } else {
            FRUInfo chassisFRU = midplaneFRUCommand.getChassisFRU();
            if (this.field.equals("PM")) {
                MOut.G(this).println("Product Manufacturer (PM) = " + new String(chassisFRU.fru.product.productManufacturerName));
            } else if (this.field.equals("PN")) {
                MOut.G(this).println("Product Name (PN) = " + new String(chassisFRU.fru.product.productName));
            } else if (this.field.equals("PPM")) {
                MOut.G(this).println("Product Part/Model Number (PPM) = " + new String(chassisFRU.fru.product.productPartModelNumber));
            } else if (this.field.equals("PV")) {
                MOut.G(this).println("Product Version (PV) = " + new String(chassisFRU.fru.product.productVersion));
            } else if (this.field.equals("PS")) {
                MOut.G(this).println("Product Serial Number (PS) = " + new String(chassisFRU.fru.product.productSerialNumber));
            } else if (this.field.equals("PAT")) {
                MOut.G(this).println("Product Asset Tag (PAT) = " + new String(chassisFRU.fru.product.assetTag));
            } else if (this.field.equals("CT")) {
                MOut.G(this).println("Chassis Type (CT) = " + chassisFRU.fru.chassis.getChassisTypeDesc() + " (" + ByteUtility.byteToHex(chassisFRU.fru.chassis.chassisType) + "h)");
            } else if (this.field.equals("CP")) {
                MOut.G(this).println("Chassis Part Number (CP) = " + new String(chassisFRU.fru.chassis.partNumber));
            } else if (this.field.equals("CS")) {
                MOut.G(this).println("Chassis Serial Number (CS) = " + new String(chassisFRU.fru.chassis.serialNumber));
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: midFRU read <field>");
        MOut.G(this).println("");
        MOut.G(this).println("Available Fields for FRU:");
        MOut.G(this).println("  Chassis Info Fields:");
        MOut.G(this).println("    CT  :Chassis Type");
        MOut.G(this).println("    CP  :Chassis Part number");
        MOut.G(this).println("    CS  :Chassis Serial number");
        MOut.G(this).println("  Product Info Fields:");
        MOut.G(this).println("    PM  :Product Manufacturer ");
        MOut.G(this).println("    PN  :Product Name ");
        MOut.G(this).println("    PPM :Product Part/Model Number");
        MOut.G(this).println("    PV  :Product Version ");
        MOut.G(this).println("    PS  :Product Serial Number");
        MOut.G(this).println("    PAT :Asset Tag");
        MOut.G(this).println("    SGP :SGPIO");
        MOut.G(this).println("    ZON :Zoning mode");
    }
}

