/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeNodeUIDLEDCommand
extends MicroBladeCommand {
    String bladeIndex;
    int nodeIndex = 0;
    byte bIndex = 0;
    byte isOn = 0;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length >= 3) {
                if (this.getParameters()[2].equalsIgnoreCase("on")) {
                    this.isOn = 1;
                } else if (this.getParameters()[2].equalsIgnoreCase("off")) {
                    this.isOn = 0;
                } else {
                    MOut.G(this).println("command must be 'on' or 'off'.");
                    return false;
                }
            }
            if (this.parameters.length >= 2) {
                try {
                    this.nodeIndex = Integer.parseInt(this.getParameters()[1]);
                }
                catch (Exception e) {
                    MOut.G(this).println("The node index must be 1-4");
                    return false;
                }
                if (this.nodeIndex < 1 || this.nodeIndex > 4) {
                    MOut.G(this).println("The node index must be 1-4");
                    return false;
                }
            }
            if (this.parameters.length >= 1) {
                this.bladeIndex = this.getParameters()[0];
                this.bIndex = (byte)NodeSensorInfo.getBladeIndex(this.bladeIndex);
                if (this.bIndex < 0) {
                    MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        block9: {
            block10: {
                block8: {
                    if (this.getParameters() != null) break block8;
                    MOut.G(this).println("Usage: microBlade node uid <bladeID> <nodeID> [on | off]");
                    break block9;
                }
                if (this.getParameters().length != 2) break block10;
                BladeRemoteInfo bladeRemoteInfo = this.ipmiMicroBladeOEMCommand.getBladeRemoteInfo(this.bIndex);
                NodeStatusInfo nodeStatusInfo = this.ipmiMicroBladeOEMCommand.getNodeStatus(this.bIndex, (byte)(this.nodeIndex - 1));
                if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                    MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " is not presented");
                    this.statusCode = 151;
                    return;
                }
                MOut.G(this).println("Usage: microBlade node uid <bladeID> <nodeID> [on | off]");
                byte b = this.ipmiMicroBladeOEMCommand.getNodeUIDLED(this.bIndex, this.nodeIndex - 1);
                if (b == 0) {
                    MOut.G(this).println("Current UID status: Off");
                    break block9;
                } else if (b == 1) {
                    MOut.G(this).println("Current UID status: On");
                }
                break block9;
            }
            if (this.getParameters().length == 3) {
                BladeRemoteInfo bladeRemoteInfo = this.ipmiMicroBladeOEMCommand.getBladeRemoteInfo(this.bIndex);
                NodeStatusInfo nodeStatusInfo = this.ipmiMicroBladeOEMCommand.getNodeStatus(this.bIndex, (byte)(this.nodeIndex - 1));
                if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                    MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " is not presented");
                    this.statusCode = 151;
                    return;
                }
                boolean b = this.ipmiMicroBladeOEMCommand.setNodeUIDLED(this.bIndex, this.nodeIndex - 1, this.isOn);
                if (!b) {
                    MOut.G(this).println("Update UID Fail");
                    this.statusCode = 149;
                    return;
                }
                MOut.G(this).println("set UID Successfully");
            } else {
                MOut.G(this).println("Usage: microBlade node uid <bladeID> <nodeID> [on | off]");
            }
        }
        this.statusCode = 0;
    }
}

