/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ATENFlash;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeBiosCommand;
import java.io.File;

public class MicroBladeIpmiCommand
extends Command {
    @Override
    public void execute() throws Exception {
        byte bIndex;
        String bladeIndex;
        BladeRemoteInfo[] bladeRemoteInfos;
        String bmcFile;
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        if (this.getParameters() == null || this.getParameters().length < 1) {
            MOut.G(this).println("[<blade index> [node index]] <BMCFilename> is required");
            MOut.G(this).println("");
            MOut.G(this).println("Ex: Update the ipmi of b1 node 3.");
            MOut.G(this).println("IPMI>microblade ipmi b1 3 C:\\MicroBlade_1.03.bin");
            MOut.G(this).println("Ex: Update the ipmi of all nodes of b12.");
            MOut.G(this).println("IPMI>microblade ipmi b12 C:\\MicroBlade_1.03.bin");
            MOut.G(this).println("Ex: Update the ipmi of all nodes.");
            MOut.G(this).println("IPMI>microblade ipmi C:\\MicroBlade_1.03.bin");
            MOut.G(this).println("");
            MOut.G(this).println("Please use \"task\" command to manage the IPMI update tasks.");
            this.statusCode = 0;
            return;
        }
        int nodeIndex = 0;
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        if (this.getParameters().length == 1) {
            bmcFile = this.getParameters()[0];
            bladeRemoteInfos = ipmiMicroBladeOEMCommand.getAllBladeRemoteInfo(28);
        } else if (this.getParameters().length == 2) {
            bladeIndex = this.getParameters()[0];
            bmcFile = this.getParameters()[1];
            bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            bladeRemoteInfos = new BladeRemoteInfo[]{ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex)};
            if (!bladeRemoteInfos[0].isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
        } else {
            bladeIndex = this.getParameters()[0];
            nodeIndex = Integer.parseInt(this.getParameters()[1]);
            bmcFile = this.getParameters()[2];
            bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            if (nodeIndex < 1 || nodeIndex > 4) {
                MOut.G(this).println("The node index must be 1-4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            bladeRemoteInfos = new BladeRemoteInfo[]{ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex)};
            if (!bladeRemoteInfos[0].isPresent() || nodeIndex < 1 || nodeIndex > 4) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
        }
        sessionController.closeSession();
        File file = new File(bmcFile);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + bmcFile + ") not found");
            return;
        }
        ATENFlash atenFlash = new ATENFlash();
        atenFlash.setMOut(MOut.G(this));
        MOut.G(this).print("Check firmware file...");
        String firmwareVersion = null;
        try {
            firmwareVersion = atenFlash.checkFirmwareVersionMicroBladeNode(bmcFile);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        MOut.G(this).println("Done (ver:" + firmwareVersion + ")");
        for (int i = 0; i < bladeRemoteInfos.length; ++i) {
            BladeRemoteInfo bladeRemoteInfo = bladeRemoteInfos[i];
            if (nodeIndex > 0) {
                NodeRemoteInfo nodeRemoteInfo = bladeRemoteInfo.getNodeRemoteInfo(nodeIndex - 1);
                String args = "task run " + nodeRemoteInfo.getBMCPIP() + " " + nodeRemoteInfo.getDecryptedUsername() + " " + nodeRemoteInfo.getDecryptedPassword() + " ipmi flasha " + bmcFile;
                MOut.G(this).println(args);
                Command command = this.getOriginalParser().parse(this.getOriginalParser().argumentRoot, MicroBladeBiosCommand.getCommandArray(args));
                if (command == null) {
                    this.statusCode = 180;
                    return;
                }
                if (!command.isSupportBackgroundModeForTaskRunCommand) {
                    this.statusCode = 154;
                    return;
                }
                command.setConfig(this.config);
                command.setOriginalParser(this.getOriginalParser());
                command.execute();
                break;
            }
            for (int j = 0; j < bladeRemoteInfo.nodeCount; ++j) {
                NodeRemoteInfo nodeRemoteInfo = bladeRemoteInfo.getNodeRemoteInfo(j);
                String args = "task run " + nodeRemoteInfo.getBMCPIP() + " " + nodeRemoteInfo.getDecryptedUsername() + " " + nodeRemoteInfo.getDecryptedPassword() + " ipmi flasha " + bmcFile;
                MOut.G(this).println(args);
                Command command = this.getOriginalParser().parse(this.getOriginalParser().argumentRoot, MicroBladeBiosCommand.getCommandArray(args));
                if (command == null) {
                    this.statusCode = 180;
                    return;
                }
                if (!command.isSupportBackgroundModeForTaskRunCommand) {
                    this.statusCode = 154;
                    return;
                }
                command.setConfig(this.config);
                command.setOriginalParser(this.getOriginalParser());
                command.execute();
            }
        }
        this.statusCode = 0;
    }

    public boolean validateForCMM() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (!IPMIMessagingCommand.isMicroBladeCMMGUID(guid) && !IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid)) {
            MOut.G(this).println("This command only supports MicroCMM devices.");
            return false;
        }
        return true;
    }
}

