/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMICMMDiagCommand;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMISDRCommandForCMMDiag;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.cmmdiag.CMMDiagScenario;
import com.supermicro.ipmi.microblade.cmmdiag.Discrete;
import com.supermicro.ipmi.text.IPMISensorDisplayForCMMDiag;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class MicroBladeCMMDiagCommand
extends MicroBladeCommand {
    String formatTemplate = "  %-6s | %-24s | %12s | %9s | %10s |\n";
    String formatTemplateThreshold = "  %-6s | %6s | %8s | %-24s | %12s | %8s | %8s | %9s | %9s |\n";
    HashMap ipToSDRs = new HashMap();
    public static int passTest = 0;

    public boolean preValidateFile(String[] parameters) {
        if (parameters != null && parameters.length == 1) {
            File file = new File(parameters[0]);
            return file.exists();
        }
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        boolean isFileMode = this.preValidateFile(this.parameters);
        int totalTest = 0;
        if (isFileMode) {
            List<Object> ipList = new ArrayList();
            String fileName = this.parameters[0];
            try (BufferedReader br = Files.newBufferedReader(Paths.get(fileName, new String[0]));){
                ipList = br.lines().collect(Collectors.toList());
                try {
                    for (String string : ipList) {
                        this.config.setIp(string);
                        IPMIInterface inteface = this.getIPMIInterface(this.config);
                        this.diagForOneCMM(inteface, passTest, totalTest++);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            IPMIInterface inteface = this.getIPMIInterface(this.config);
            this.diagForOneCMM(inteface, passTest, totalTest++);
        }
        MOut.G(this).println("Dignosing Pass: " + passTest + "/" + totalTest);
    }

    void diagForOneCMM(IPMIInterface inteface, int passTest, int totalTest) throws IPMIException, IOException {
        IPMISDRCommandForCMMDiag ipmiSDRCommand = new IPMISDRCommandForCMMDiag(inteface);
        IPMISensorDisplayForCMMDiag ipmiDisplay = new IPMISensorDisplayForCMMDiag(inteface);
        byte[] guid = new IPMIMessagingCommand(ipmiSDRCommand.getIPMIInterface()).getSystemGUID();
        boolean ispowerOn = new IPMIChassisCommand(inteface).isPowerOn();
        ArrayList<String> sdrRecordList = new ArrayList<String>();
        ArrayList sdrList = null;
        Discrete discrete = null;
        MOut.G(this).print("Diagnosing " + this.config.getIp() + "...");
        if (this.ipToSDRs.get(this.config.getIp()) == null) {
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            if (sdrInfo == null) {
                MOut.G(this).println("Get SDR Repository error");
                this.statusCode = 149;
                return;
            }
            try {
                sdrList = ipmiSDRCommand.getSDRbyLine(sdrInfo.getRecordCount(), false, ispowerOn, guid, this.config);
            }
            catch (IPMIException iPMIException) {
            }
            catch (Exception e) {
                e.printStackTrace();
                MOut.G(this).println("Get SDR failed:" + e.getMessage());
                this.statusCode = 149;
                return;
            }
            this.ipToSDRs.put(this.config.getIp(), sdrList);
        } else {
            sdrList = (ArrayList)this.ipToSDRs.get(this.config.getIp());
            Discrete systemStatusDiscrete = null;
            for (SDRRecord item : sdrList) {
                try {
                    discrete = ipmiDisplay.print(item, false, ispowerOn, guid, sdrRecordList);
                    if (discrete == null || !discrete.isSystemStatus()) continue;
                    systemStatusDiscrete = discrete;
                }
                catch (IPMIException iPMIException) {}
            }
            CMMDiagScenario cmmdiag = new CMMDiagScenario();
            byte systemStatusDiscreteReading = systemStatusDiscrete == null ? (byte)-1 : (byte)systemStatusDiscrete.getReading();
            cmmdiag.run(new IPMICMMDiagCommand(this.ipmiMicroBladeOEMCommand.getIPMIInterface()), systemStatusDiscreteReading, sdrRecordList, this.config);
        }
        this.statusCode = 0;
    }

    public IPMIInterface getIPMIInterface(IPMIInterfaceConfig config) throws Exception {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiGlobalCommand);
        if (ipmiGlobalCommand.getIPMIInterface() != null) {
            return ipmiGlobalCommand.getIPMIInterface();
        }
        return null;
    }
}

