/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.HostCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MgSortCommand
extends SuperBladeCommand {
    public void usage() {
        MOut.G(this).println("Usage: mg sort <IP|BOARD|LOC|BMC> [desc]");
        MOut.G(this).println("Options: ");
        MOut.G(this).println("        IP:    sort by IP address");
        MOut.G(this).println("        BOARD: sort by MB name");
        MOut.G(this).println("        BMC:   sort by BMC type");
        MOut.G(this).println("        LOC:   sort by Location Tag");
        MOut.G(this).println("        desc:  sort as descending. Default is ascending");
    }

    @Override
    public void runCommand() throws Exception {
        if (this.parameters == null || this.parameters.length < 1) {
            this.usage();
            this.statusCode = 147;
            return;
        }
        if (this.parameters[0].toUpperCase().equals("IP")) {
            IPMIInterfaceConfig.sortType = IPMIInterfaceConfig.SORT_TYPE.IP;
        } else if (this.parameters[0].toUpperCase().equals("BOARD")) {
            IPMIInterfaceConfig.sortType = IPMIInterfaceConfig.SORT_TYPE.BOARD;
        } else if (this.parameters[0].toUpperCase().equals("LOC")) {
            IPMIInterfaceConfig.sortType = IPMIInterfaceConfig.SORT_TYPE.LOC;
        } else if (this.parameters[0].toUpperCase().equals("BMC")) {
            IPMIInterfaceConfig.sortType = IPMIInterfaceConfig.SORT_TYPE.BMC;
        }
        IPMIInterfaceConfig.isAscending = this.parameters.length < 2 || !this.parameters[1].toUpperCase().equals("DESC");
        HostCenter.getInstance().sort();
        this.list();
    }

    public void list() {
        String tag = "";
        tag = HostCenter.getInstance().getCurrHostBuffer() == HostCenter.getInstance().getDefaultHostBuffer() ? "Default Group" : (HostCenter.getInstance().getCurrHostBuffer() == HostCenter.getInstance().getFoundHostBuffer() ? "Found Group" : "File :" + HostCenter.getInstance().getCurrHostBuffer().filename);
        MOut.G(this).println("Current managed system(s): (" + tag + ") ");
        MOut.G(this).println("");
        MOut.G(this).println(HostCenter.getInstance().toFormatedStringWithTagLoc());
    }
}

