/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class MBTLinkService {
    public static boolean setColdReset(SuperBladeCommand command) {
        boolean result = false;
        command.ignoreSessionClose(false);
        IPMIGlobalCommand globalCommand = new IPMIGlobalCommand(command.ipmiCMMOEMCommand.getIPMIInterface());
        result = globalCommand.coldReset();
        if (!result) {
            MOut.G(command).println("Cold reset failed");
            return false;
        }
        command.ignoreSessionClose(true);
        MOut.G(command).println("Cold reset is done. Wait for connection recovery ...");
        return true;
    }

    public static boolean isLinkRecovery(SuperBladeCommand command) {
        return MBTLinkService.isLinkRecovery(command, 30);
    }

    public static boolean isLinkRecovery(SuperBladeCommand command, int linkTTL) {
        boolean result = false;
        long linkupRecoverTimestamp = 0L;
        long linkupTimeToLive = linkTTL * 1000;
        long monitorBeginTimestamp = System.currentTimeMillis();
        long monitorTimeToLive = 1800000L;
        do {
            boolean isReachable = false;
            try {
                Thread.sleep(1000L);
                InetAddress address = InetAddress.getByName(command.getConfig().getIp());
                isReachable = address.isReachable(100);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            if (isReachable) {
                if (linkupRecoverTimestamp == 0L) {
                    linkupRecoverTimestamp = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - linkupRecoverTimestamp < linkupTimeToLive) continue;
                MOut.G(command).println("Recover connection elapsed time: " + MBTLinkService.getTimeElapsed(monitorBeginTimestamp));
                result = true;
                break;
            }
            linkupRecoverTimestamp = 0L;
        } while (System.currentTimeMillis() - monitorBeginTimestamp <= 1800000L);
        MOut.G(command).println(result ? "Connection is recovered." : "Recover connection failed");
        return result;
    }

    private static String getTimeElapsed(long monitorBeginTimestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis() - monitorBeginTimestamp);
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
        return sdf.format(calendar.getTime());
    }
}

