/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMISoftwareFRUCommand;
import com.supermicro.ipmi.activation.CSWProductKey;
import com.supermicro.ipmi.text.ActivationAPI;
import com.supermicro.redfish.RedfishActAPI;
import java.util.ArrayList;

public class LicenseManager {
    IPMIInterface ipmiInterface;
    IPMIInterfaceConfig ipmiInterfaceConfig;
    boolean isHSM = false;

    public LicenseManager(IPMIInterface ipmiInterface, IPMIInterfaceConfig ipmiInterfaceConfig) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        IPMISoftwareFRUCommand ipmisoftwareFRUCommand = new IPMISoftwareFRUCommand(ipmiInterface);
        try {
            IPMISoftwareFRUCommand.Type type;
            boolean bl = this.isHSM = !ipmisoftwareFRUCommand.checkIfSoftwareFRUExist();
            if (this.isHSM && (type = ipmisoftwareFRUCommand.getActivationType()) == IPMISoftwareFRUCommand.Type.NotSupported) {
                this.isHSM = false;
            }
        }
        catch (IPMIException e) {
            this.isHSM = true;
        }
    }

    public boolean checkIfLicenseExist() {
        if (this.isHSM) {
            RedfishActAPI redfishAct = new RedfishActAPI(this.ipmiInterfaceConfig);
            return redfishAct.checkIfLicenseSupported();
        }
        ActivationAPI actool = new ActivationAPI(this.ipmiInterface);
        ActivationAPI.License license = null;
        try {
            license = actool.getProductKeyLicense();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return license == ActivationAPI.License.SFT_OOB_LIC || license == ActivationAPI.License.SFT_DCMS_SINGLE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIfDCMSLicenseExist() {
        if (this.isHSM) {
            try {
                ArrayList<CSWProductKey> list = this.getProductKeyList();
                int i = 0;
                while (true) {
                    if (i >= list.size()) {
                        return false;
                    }
                    CSWProductKey ck = list.get(i);
                    if (ck.getSwName().contains("SFT-DCMS-SINGLE")) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        ActivationAPI actool = new ActivationAPI(this.ipmiInterface);
        ActivationAPI.License license = null;
        try {
            license = actool.getProductKeyLicense();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (license != ActivationAPI.License.SFT_DCMS_SINGLE) return false;
        return true;
    }

    public ArrayList<CSWProductKey> getProductKeyList() throws Exception {
        if (this.isHSM) {
            RedfishActAPI redfishAct = new RedfishActAPI(this.ipmiInterfaceConfig);
            return redfishAct.getProductKeyList();
        }
        ActivationAPI actool = new ActivationAPI(this.ipmiInterface);
        ArrayList<CSWProductKey> list = actool.getNodeProductKeyList();
        if (actool.checkOOBKey()) {
            if (list == null) {
                list = new ArrayList();
            }
            CSWProductKey ck = new CSWProductKey();
            ck.setSwName("SFT-OOB-LIC");
            ck.setExpireDate("");
            ck.setCreateDate("");
            ck.setSignature("");
            list.add(ck);
        }
        return list;
    }

    public void clearOOBLicense() throws Exception {
        if (this.isHSM) {
            RedfishActAPI redfishAct = new RedfishActAPI(this.ipmiInterfaceConfig);
            redfishAct.clearOOBLicense();
        } else {
            ActivationAPI actool = new ActivationAPI(this.ipmiInterface);
            actool.clearOOBLicense();
        }
    }

    public void clearDCMSLicense() throws Exception {
        if (this.isHSM) {
            RedfishActAPI redfishAct = new RedfishActAPI(this.ipmiInterfaceConfig);
            redfishAct.ClearLicense(2);
        } else {
            ActivationAPI actool = new ActivationAPI(this.ipmiInterface);
            actool.clearNodeProductKeyAll();
        }
    }

    public boolean activateLicense(String key) throws Exception {
        return this.activateLicense(key, true);
    }

    public int activateLicensebyFile(String fileName) throws Exception {
        RedfishActAPI redfishAct = new RedfishActAPI(this.ipmiInterfaceConfig);
        return redfishAct.ActivateLicensebyFile(fileName);
    }

    public boolean activateLicense(String key, boolean isOOB) throws Exception {
        if (this.isHSM) {
            RedfishActAPI redfishAct = new RedfishActAPI(this.ipmiInterfaceConfig);
            int result = redfishAct.ActivateLicense(key);
            return result >= 200 && result <= 210;
        }
        if (isOOB) {
            ActivationAPI actool = new ActivationAPI(this.ipmiInterface);
            return actool.activateOOBKey(key);
        }
        ActivationAPI actool = new ActivationAPI(this.ipmiInterface, key);
        try {
            actool.activateNodeProductKey();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

