/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class IPMIOEMLDAPCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte authentication;
    private byte ssl;
    private byte[] port;
    private byte[] ip;
    private byte[] bindPassword;
    private byte[] bindDN;
    private byte[] searchBase;
    private String usage = "Usage: ipmi oem x10cfg ldap [<authentication> <SSL> <port> <ip address> <bind password> <bind DN> <search base>]\nFor authentication:\nOn  : 1\nOff : 0\nFor SSL:\nOn  : 1\nOff : 0\n* When SLL is on, port number should be 636; Off, port number should be 389";

    @Override
    public boolean preValidate() {
        int tempPort;
        if (this.parameters == null) {
            return true;
        }
        if (this.parameters.length != 7) {
            MOut.G(this).println(this.usage);
            return false;
        }
        try {
            this.authentication = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("authentication should be number");
            MOut.G(this).println(this.usage);
            return false;
        }
        if (this.authentication < 0 || this.authentication > 1) {
            MOut.G(this).println("authentication should be 0 or 1");
            MOut.G(this).println(this.usage);
            return false;
        }
        try {
            this.ssl = Byte.parseByte(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("ssl should be number");
            MOut.G(this).println(this.usage);
            return false;
        }
        if (this.ssl < 0 || this.ssl > 1) {
            MOut.G(this).println("ssl should be 0 or 1");
            MOut.G(this).println(this.usage);
            return false;
        }
        try {
            tempPort = Integer.parseInt(this.parameters[2]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("port should be number");
            MOut.G(this).println(this.usage);
            return false;
        }
        if (this.ssl == 1) {
            if (tempPort != 636) {
                MOut.G(this).println("port should be 636");
                MOut.G(this).println(this.usage);
                return false;
            }
        } else if (tempPort != 389) {
            MOut.G(this).println("port should be 389");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.port = new byte[2];
        ByteUtility.intTo2Bytes(this.port, 0, tempPort);
        try {
            String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
            if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[3]).matches()) {
                throw new NumberFormatException();
            }
            this.ip = ByteUtility.ipToBytes(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("ip address should be ###.###.###.###");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.bindPassword = this.parameters[4].getBytes();
        if (this.bindPassword.length > 255) {
            MOut.G(this).println("Bind password should less then 255 characters");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.bindDN = this.parameters[5].getBytes();
        if (this.bindDN.length > 255) {
            MOut.G(this).println("Bind DN should less then 255 characters");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.searchBase = this.parameters[6].getBytes();
        if (this.searchBase.length > 255) {
            MOut.G(this).println("Search base should less then 255 characters");
            MOut.G(this).println(this.usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (!this.isBeforeX12() || IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("LDAP command is not supported on this device, you may try redfish accountService ldap command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            byte[] auth = ipmiOEMWebSettingCommand.getLdap((byte)0);
            byte[] ssl = ipmiOEMWebSettingCommand.getLdap((byte)1);
            byte[] port = ipmiOEMWebSettingCommand.getLdap((byte)2);
            byte[] ip = ipmiOEMWebSettingCommand.getLdap((byte)3);
            byte[] pwd = ipmiOEMWebSettingCommand.getLdap((byte)4);
            byte[] dn = ipmiOEMWebSettingCommand.getLdap((byte)5);
            byte[] searchBase = ipmiOEMWebSettingCommand.getLdap((byte)6);
            String formatServer = " %-50s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatServer, "Item", "Value"));
            header.append(String.format(formatServer, "----", "-----"));
            MOut.G(this).printf(formatServer, "LDAP Authentication", auth[0] == 1 ? "On" : "Off");
            MOut.G(this).printf(formatServer, "LDAP Authentication over SSL", ssl[0] == 1 ? "On" : "Off");
            MOut.G(this).printf(formatServer, "Port", ByteUtility.twoBytesToIntLSB(ByteUtility.getBytes(port, 0, 2)));
            MOut.G(this).printf(formatServer, "IP Address", (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF));
            MOut.G(this).printf(formatServer, "Bind Password", pwd == null ? "" : new String(pwd).trim());
            MOut.G(this).printf(formatServer, "Bind DN", dn == null ? "" : new String(dn).trim());
            MOut.G(this).printf(formatServer, "Bind Search Base", searchBase == null ? "" : new String(searchBase).trim());
            this.statusCode = 0;
            MOut.G(this).println("\n" + this.usage);
            return;
        }
        if (this.checkIfSystemLockdown()) {
            this.statusCode = 156;
            return;
        }
        byte adAuth = ipmiOEMWebSettingCommand.getADServer((byte)0)[0];
        if (adAuth == 1) {
            MOut.G(this).println("Active Directory has been enabled, please disable Active Directory before enabling LDAP");
            this.statusCode = 149;
            return;
        }
        byte auth = ipmiOEMWebSettingCommand.getRadius((byte)0)[0];
        if (auth == 1) {
            MOut.G(this).println("Radius has been enabled, please disable Radius before enabling LDAP");
            this.statusCode = 149;
            return;
        }
        ByteBuffer target = ByteBuffer.allocate(1);
        target.put(this.authentication);
        if (!ipmiOEMWebSettingCommand.setLdap((byte)0, target.array())) {
            MOut.G(this).println("Set LDAP authentication failed");
            this.statusCode = 149;
            return;
        }
        target = ByteBuffer.allocate(1);
        target.put(this.ssl);
        if (!ipmiOEMWebSettingCommand.setLdap((byte)1, target.array())) {
            MOut.G(this).println("Set LDAP authentication over SSL failed");
            this.statusCode = 149;
            return;
        }
        if (!ipmiOEMWebSettingCommand.setLdap((byte)2, this.port)) {
            MOut.G(this).println("Set LDAP port failed");
            this.statusCode = 149;
            return;
        }
        if (!ipmiOEMWebSettingCommand.setLdap((byte)3, this.ip)) {
            MOut.G(this).println("Set LDAP ip failed");
            this.statusCode = 149;
            return;
        }
        if (!ipmiOEMWebSettingCommand.setLdap((byte)4, this.bindPassword)) {
            MOut.G(this).println("Set bind password failed");
            this.statusCode = 149;
            return;
        }
        if (!ipmiOEMWebSettingCommand.setLdap((byte)5, this.bindDN)) {
            MOut.G(this).println("Set bind DN failed");
            this.statusCode = 149;
            return;
        }
        if (!ipmiOEMWebSettingCommand.setLdap((byte)6, this.searchBase)) {
            MOut.G(this).println("Set search base failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

