/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class IPMIOEMIpCtrlListCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (!this.isBeforeX12()) {
            MOut.G(this).println("IPCtrl command is not supported on this device, you may try redfish ipctrl command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] status = ipmiOEMWebSettingCommand.getIpCtrl();
        String formatServer = " %-30s | %20s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatServer, "Item", "Value"));
        header.append(String.format(formatServer, "----", "-----"));
        MOut.G(this).printf(formatServer, "IP Access Control", status[0] == 1 ? "On" : "Off");
        MOut.G(this).println();
        String formatTemplate = "%7s | %-40s | %-20s \n";
        MOut.G(this).printf(formatTemplate, "Rule No", "IP Address/Mask", "Policy");
        MOut.G(this).printf(formatTemplate, "-------", "---------------", "------");
        for (int i = 0; i < 10; ++i) {
            byte[] rule = ipmiOEMWebSettingCommand.getIpCtrlRule((byte)i);
            if (rule == null || rule.length != 9) {
                MOut.G(this).printf(formatTemplate, i + 1, "", "");
                continue;
            }
            MOut.G(this).printf(formatTemplate, i + 1, (rule[0] & 0xFF) + "." + (rule[1] & 0xFF) + "." + (rule[2] & 0xFF) + "." + (rule[3] & 0xFF) + "/" + (rule[4] & 0xFF) + "." + (rule[5] & 0xFF) + "." + (rule[6] & 0xFF) + "." + (rule[7] & 0xFF), rule[8] == 1 ? "Accept" : "Drop");
        }
        this.statusCode = 0;
    }
}

