/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;

public class IPMIOEMADListCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    @Override
    public void runCommand() throws Exception {
        String url;
        BasicAuthClient bc;
        int result;
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (!this.isBeforeX12()) {
            MOut.G(this).println("AD command is not supported on this device, you may try redfish accountService ad command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] adServerParams = ipmiOEMWebSettingCommand.getADServer((byte)0);
        byte[] adServerDomainName = ipmiOEMWebSettingCommand.getADServer((byte)1);
        byte[] adServer3Ip = ipmiOEMWebSettingCommand.getADServer((byte)2);
        String address1 = (adServer3Ip[0] & 0xFF) + "." + (adServer3Ip[1] & 0xFF) + "." + (adServer3Ip[2] & 0xFF) + "." + (adServer3Ip[3] & 0xFF);
        String address2 = (adServer3Ip[4] & 0xFF) + "." + (adServer3Ip[5] & 0xFF) + "." + (adServer3Ip[6] & 0xFF) + "." + (adServer3Ip[7] & 0xFF);
        String address3 = (adServer3Ip[8] & 0xFF) + "." + (adServer3Ip[9] & 0xFF) + "." + (adServer3Ip[10] & 0xFF) + "." + (adServer3Ip[11] & 0xFF);
        if ((adServer3Ip[0] == 0 && adServer3Ip[1] == 0 && adServer3Ip[2] == 0 && adServer3Ip[3] == 0 || adServer3Ip[4] == 0 && adServer3Ip[5] == 0 && adServer3Ip[6] == 0 && adServer3Ip[7] == 0 || adServer3Ip[8] == 0 && adServer3Ip[9] == 0 && adServer3Ip[10] == 0 && adServer3Ip[11] == 0) && (result = (bc = new BasicAuthClient(this.config)).send_https_get(url = "https://" + this.config.getIp() + "/redfish/v1/Managers/1/" + "ActiveDirectory")) >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode DCSaddress1 = node.path("DCSAddress1");
            JsonNode DCSaddress2 = node.path("DCSAddress2");
            JsonNode DCSaddress3 = node.path("DCSAddress3");
            if (adServer3Ip[0] == 0 && adServer3Ip[1] == 0 && adServer3Ip[2] == 0 && adServer3Ip[3] == 0 && DCSaddress1.isTextual()) {
                address1 = DCSaddress1.asText();
            }
            if (adServer3Ip[4] == 0 && adServer3Ip[5] == 0 && adServer3Ip[6] == 0 && adServer3Ip[7] == 0 && DCSaddress2.isTextual()) {
                address2 = DCSaddress2.asText();
            }
            if (adServer3Ip[8] == 0 && adServer3Ip[9] == 0 && adServer3Ip[10] == 0 && adServer3Ip[11] == 0 && DCSaddress2.isTextual()) {
                address3 = DCSaddress3.asText();
            }
        }
        String formatServer = " %-50s | %30s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatServer, "Item", "Value"));
        header.append(String.format(formatServer, "----", "-----"));
        MOut.G(this).printf(formatServer, "Activate Directory Authentication", adServerParams[0] == 1 ? "On" : "Off");
        MOut.G(this).printf(formatServer, "Active Directory Authentication over SSL", adServerParams[1] == 1 ? "On" : "Off");
        MOut.G(this).printf(formatServer, "Port", ByteUtility.twoBytesToIntLSB(ByteUtility.getBytes(adServerParams, 2, 2)));
        MOut.G(this).printf(formatServer, "Time Out", ByteUtility.twoBytesToIntLSB(ByteUtility.getBytes(adServerParams, 4, 2)));
        MOut.G(this).printf(formatServer, "User Domain Name", new String(adServerDomainName).trim());
        MOut.G(this).printf(formatServer, "Domain Controller Server Address1", address1);
        MOut.G(this).printf(formatServer, "Domain Controller Server Address2", address2);
        MOut.G(this).printf(formatServer, "Domain Controller Server Address3", address3);
        MOut.G(this).println();
        String formatTemplate = "%13s | %-20s | %-20s | %-20s \n";
        MOut.G(this).printf(formatTemplate, "Role Group ID", "Group Name", "Group Domain", "Network Privilege");
        MOut.G(this).printf(formatTemplate, "-------------", "----------", "------------", "-----------------");
        for (int i = 0; i <= 4; ++i) {
            byte[] adNetworkPrivilege = ipmiOEMWebSettingCommand.getADRoleGroup((byte)3, (byte)i);
            byte[] adGroupName = ipmiOEMWebSettingCommand.getADRoleGroup((byte)4, (byte)i);
            byte[] adGroupDomain = ipmiOEMWebSettingCommand.getADRoleGroup((byte)5, (byte)i);
            MOut.G(this).printf(formatTemplate, i + 1, new String(adGroupName).trim(), new String(adGroupDomain).trim(), this.getPriviledgeString(adNetworkPrivilege[0]));
        }
        this.statusCode = 0;
    }

    private String getPriviledgeString(int p) {
        switch (p) {
            case 4: {
                return "Administrator";
            }
            case 3: {
                return "Operator";
            }
            case 2: {
                return "User";
            }
            case 1: {
                return "Callback";
            }
            case 15: {
                return "No Access";
            }
        }
        return "Reserved";
    }
}

