/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.util.StringUtil;

public class HDDMapCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            try {
                Integer.parseInt(this.parameters[0]);
                return true;
            }
            catch (Exception e) {
                MOut.G(this).println("Usage: hdd map [device id]");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        boolean emptyHDD = false;
        try {
            if (this.parameters != null) {
                int devID = Integer.parseInt(this.parameters[0]);
                emptyHDD = this.drawAllMap(devID);
                if (emptyHDD) {
                    MOut.G(this).println("Empty HDD Info");
                }
            } else {
                for (int devID = 0; !(devID >= 3 || guid != null && IPMIMessagingCommand.isATENGUID(guid) && devID > 0); ++devID) {
                    this.drawAllMap(devID);
                }
            }
            if (!emptyHDD) {
                MOut.G(this).println("\nX: Error");
                MOut.G(this).println("O: Present");
                MOut.G(this).println("-: Not Present");
            }
            this.statusCode = 0;
        }
        catch (IPMIException e) {
            if (emptyHDD) {
                MOut.G(this).println("This device does not support HDD interface");
                this.statusCode = 153;
            }
            MOut.G(this).println("\nX: Error");
            MOut.G(this).println("O: Present");
            MOut.G(this).println("-: Not Present");
        }
    }

    private boolean drawAllMap(int devID) throws IPMIException {
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIHDDOEMCommand.HDDMap hddMap = ipmiHDDOEMCommand.getHDDMap(devID);
        if (hddMap == null) {
            throw new IPMIException();
        }
        String drawMap = hddMap.drawAllMap(devID);
        if (StringUtil.isBlank(drawMap.trim())) {
            if (devID == 0) {
                MOut.G(this).println("Empty HDD Info");
                return false;
            }
            return true;
        }
        MOut.G(this).println(drawMap);
        return false;
    }
}

