/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Properties;

public class ECOInfo {
    public String ecoNumber;
    public String boardID;
    public String biosFile;
    public String bmcFile;
    public String cpldFile;
    public String script;
    public String note;
    public String biosVer;
    public String bmcVer;
    public String ipmiUsername;
    public String ipmiPassword;

    public void load(String filename) throws Exception {
        File ff;
        String propertyFileContents = "";
        String line = "";
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while ((line = in.readLine()) != null) {
            propertyFileContents = propertyFileContents + line + "\n";
        }
        Properties p = new Properties();
        StringReader sr = new StringReader(propertyFileContents.replace("\\", "\\\\"));
        p.load(sr);
        sr.close();
        this.boardID = p.getProperty("boardID");
        this.biosFile = p.getProperty("biosFile");
        this.bmcFile = p.getProperty("bmcFile");
        this.cpldFile = p.getProperty("cpldFile");
        this.script = p.getProperty("script");
        this.note = p.getProperty("note");
        this.ecoNumber = p.getProperty("ecoNumber");
        if (this.biosFile != null && this.biosFile.length() != 0 && !(ff = new File(this.biosFile)).isFile()) {
            throw new Exception(filename + ": BIOS file " + this.biosFile + " is not exist !");
        }
        if (this.bmcFile != null && this.bmcFile.length() != 0 && !(ff = new File(this.bmcFile)).isFile()) {
            throw new Exception(filename + ": BMC file " + this.bmcFile + " is not exist !");
        }
        if (this.cpldFile != null && this.cpldFile.length() != 0) {
            ff = new File(this.cpldFile);
            if (!ff.isFile()) {
                throw new Exception(filename + ": CPLD file " + this.cpldFile + " is not exist !");
            }
        } else {
            this.cpldFile = "";
        }
        if (this.script != null && this.script.length() != 0 && !(ff = new File(this.script)).isFile()) {
            throw new Exception(filename + ": Script file " + this.script + " is not exist !");
        }
        in.close();
    }

    public String toString() {
        String result = "";
        result = result + "boardID  = " + this.boardID + "\n";
        result = result + "biosFile = " + this.biosFile + "\n";
        result = result + "bmcFile  = " + this.bmcFile + "\n";
        result = result + "script   = " + this.script + "\n";
        result = result + "note     = " + this.note + "\n";
        result = result + "ecoNumber = " + this.ecoNumber + "\n";
        return result;
    }

    public static void main(String[] args) throws Exception {
        ECOInfo eco = new ECOInfo();
        eco.load("c:\\test.eco");
        System.out.println(eco.toString());
    }
}

