/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbpbi.pattern.receiver;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.smbpbi.StatusTable;
import com.supermicro.ipmi.smbpbi.pattern.OnHandleStringEventListenser;
import com.supermicro.ipmi.smbpbi.payload.PayloadSMBPBI;
import com.supermicro.ipmi.smbpbi.payload.PayloadSMC;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Vector;

public class SMBPBIInfoReceiver {
    private boolean debugMode;
    private PayloadSMC payloadSMC = new PayloadSMC();
    private PayloadSMBPBI payloadSMBPBI = new PayloadSMBPBI();
    private IPMIMessagingCommand messagingCommand;

    public SMBPBIInfoReceiver(IPMIMessagingCommand command) {
        this.messagingCommand = command;
    }

    private int getRealSize(byte[] rawBytes) {
        int realSize = 4;
        for (int idx = 1; idx < rawBytes.length; ++idx) {
            if (rawBytes[idx] != 0) continue;
            realSize = idx - 1;
            break;
        }
        return realSize;
    }

    private boolean resultHandler(ByteBuffer result, byte[] rawBytes) {
        if (rawBytes != null && rawBytes[0] == StatusTable.SMBPBI_SUCCESS) {
            int realSize = this.getRealSize(rawBytes);
            result.put(ByteBuffer.wrap(rawBytes, 1, realSize));
            return realSize != 4;
        }
        if (this.debugMode) {
            if (rawBytes == null) {
                System.out.println("\n[Error]: getSMBPBIInfo return null\n");
            } else {
                System.out.println("\n[Error]: getSMBPBIInfo - \nStatusCode: " + rawBytes[0] + "\nDescription: " + StatusTable.DESCRIPTIOPN.get(rawBytes[0]) + "\n");
            }
        }
        return true;
    }

    private void setPayload(byte[] cmd) {
        cmd[0] = this.payloadSMC.getData1();
        cmd[1] = this.payloadSMC.getData2();
        cmd[2] = this.payloadSMC.getData3();
        cmd[3] = this.payloadSMBPBI.getOPCode();
        cmd[4] = this.payloadSMBPBI.getArgument1();
        cmd[5] = this.payloadSMBPBI.getArgument2();
        cmd[6] = this.payloadSMBPBI.getArgument3();
    }

    private void getDataByteArray(ByteBuffer result, int length) {
        byte[] cmd = new byte[7];
        int offset = 0;
        while (offset * 4 < length) {
            this.setArgument2((byte)offset);
            this.setPayload(cmd);
            byte[] rawBytes = this.messagingCommand.getSMBPBIInfo((byte)-63, cmd, true);
            if (this.resultHandler(result, rawBytes)) break;
            ++offset;
        }
    }

    public boolean detectDevices() {
        byte[] cmd = new byte[7];
        this.setArgument2((byte)0);
        this.setPayload(cmd);
        byte[] rawBytes = this.messagingCommand.getSMBPBIInfo((byte)-63, cmd, false);
        return rawBytes != null && rawBytes[0] == StatusTable.SMBPBI_SUCCESS;
    }

    public boolean getLocSlot(Vector<String> resultVector, byte type, OnHandleStringEventListenser listener) {
        byte[] cmd = new byte[]{type, this.payloadSMC.getGPUIndex()};
        byte[] rawBytes = this.messagingCommand.getSMBPBIInfo((byte)-62, cmd, true);
        if (rawBytes != null) {
            resultVector.add(listener.onResultPostHandleEvent(rawBytes));
            resultVector.add(listener.onResultPostHandleEvent(rawBytes));
        }
        return true;
    }

    public boolean getData(Vector<String> resultVector, int length, OnHandleStringEventListenser listener) {
        ByteBuffer result = ByteBuffer.allocate(length);
        this.getDataByteArray(result, length);
        if (listener == null) {
            resultVector.add(new String(result.array(), 0, result.position(), StandardCharsets.UTF_8));
        } else {
            resultVector.add(listener.onResultPostHandleEvent(result.array()));
        }
        return true;
    }

    public void setDebugMode(boolean inDebug) {
        this.debugMode = inDebug;
    }

    public boolean setType(int type) {
        return this.payloadSMC.setType(type);
    }

    public boolean setGPUCore(int core) {
        return this.payloadSMC.setGPUCore(core);
    }

    public boolean setBaseBoardNumber(int number) {
        return this.payloadSMC.setBaseBoardNumber(number);
    }

    public boolean setIndexNumber(int index, int type) {
        return this.payloadSMC.setIndexNumber(index, type);
    }

    public boolean setOPCode(byte opcode) {
        return this.payloadSMBPBI.setOPCode(opcode);
    }

    public boolean setArgument1(byte arg1) {
        return this.payloadSMBPBI.setArgument1(arg1);
    }

    public boolean setArgument2(byte arg2) {
        return this.payloadSMBPBI.setArgument2(arg2);
    }

    public boolean setArgument3(byte arg3) {
        return this.payloadSMBPBI.setArgument3(arg3);
    }
}

