/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import java.util.BitSet;
import org.apache.commons.lang3.StringUtils;

public class SystemSlots
extends TypeStruct {
    byte[] slotDesign;
    byte[] slotType;
    byte[] dataBusWidth;
    byte[] currentUsage;
    byte[] slotLength;
    byte[] slotId;
    byte[] character1;
    byte[] character2;
    byte[] segmentGroupNo;
    byte[] busNo;
    byte[] deviceFuncNo;

    public SystemSlots(byte[] dataByte) {
        super(dataByte);
        this.slotDesign = this.getTypeLength(this.BYTE);
        this.slotType = this.getTypeLength(this.BYTE);
        this.dataBusWidth = this.getTypeLength(this.BYTE);
        this.currentUsage = this.getTypeLength(this.BYTE);
        this.slotLength = this.getTypeLength(this.BYTE);
        this.slotId = this.getTypeLength(this.WORD);
        this.character1 = this.getTypeLength(this.BYTE);
        this.character2 = this.getTypeLength(this.BYTE);
        this.segmentGroupNo = this.getTypeLength(this.WORD);
        this.busNo = this.getTypeLength(this.BYTE);
        this.deviceFuncNo = this.getTypeLength(this.BYTE);
        this.strFieldCount = 3;
    }

    int SlotDesign() {
        return this.slotDesign[0];
    }

    String SlotType() {
        switch (this.slotType[0]) {
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "ISA";
            }
            case 4: {
                return "MCA";
            }
            case 5: {
                return "EISA";
            }
            case 6: {
                return "PCI";
            }
            case 7: {
                return "PC Card (PCMCIA)";
            }
            case 8: {
                return "VL-VESA";
            }
            case 9: {
                return "Proprietary";
            }
            case 10: {
                return "Processor Card Slot";
            }
            case 11: {
                return "Proprietary Memory Card Slot";
            }
            case 12: {
                return "I/O Riser Card Slot";
            }
            case 13: {
                return "NuBus";
            }
            case 14: {
                return "PCI \u00a1V 66MHz Capable";
            }
            case 15: {
                return "AGP";
            }
            case 16: {
                return "AGP 2X";
            }
            case 17: {
                return "AGP 4X";
            }
            case 18: {
                return "PCI-X";
            }
            case 19: {
                return "AGP 8X";
            }
            case 20: {
                return "M.2 Socket 1-DP (Mechanical Key A)";
            }
            case 21: {
                return "M.2 Socket 1-SD (Mechanical Key E)";
            }
            case 22: {
                return "M.2 Socket 2 (Mechanical Key B)";
            }
            case 23: {
                return "M.2 Socket 3 (Mechanical Key M)";
            }
            case 24: {
                return "MXM Type I";
            }
            case 25: {
                return "MXM Type II";
            }
            case 26: {
                return "MXM Type III (standard connector)";
            }
            case 27: {
                return "MXM Type III (HE connector)";
            }
            case 28: {
                return "MXM Type IV";
            }
            case 29: {
                return "MXM 3.0 Type A";
            }
            case 30: {
                return "MXM 3.0 Type B";
            }
            case 31: {
                return "PCI Express Gen 2 SFF-8639";
            }
            case 32: {
                return "PCI Express Gen 3 SFF-8639";
            }
            case -96: {
                return "PC-98/C20";
            }
            case -95: {
                return "PC-98/C24";
            }
            case -94: {
                return "PC-98/E";
            }
            case -93: {
                return "PC-98/Local Bus";
            }
            case -92: {
                return "PC-98/Card";
            }
            case -91: {
                return "PCI Express";
            }
            case -90: {
                return "PCI Express x1";
            }
            case -89: {
                return "PCI Express x2";
            }
            case -88: {
                return "PCI Express x4";
            }
            case -87: {
                return "PCI Express x8";
            }
            case -86: {
                return "PCI Express x16";
            }
            case -85: {
                return "PCI Express Gen 2";
            }
            case -84: {
                return "PCI Express Gen 2 x1";
            }
            case -83: {
                return "PCI Express Gen 2 x2";
            }
            case -82: {
                return "PCI Express Gen 2 x4";
            }
            case -81: {
                return "PCI Express Gen 2 x8";
            }
            case -80: {
                return "PCI Express Gen 2 x16";
            }
            case -79: {
                return "PCI Express Gen 3";
            }
            case -78: {
                return "PCI Express Gen 3 x1";
            }
            case -77: {
                return "PCI Express Gen 3 x2";
            }
            case -76: {
                return "PCI Express Gen 3 x4";
            }
            case -75: {
                return "PCI Express Gen 3 x8";
            }
            case -74: {
                return "PCI Express Gen 3 x16";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.slotType[0]) + ")";
    }

    String DataBusWidth() {
        switch (this.dataBusWidth[0]) {
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "8 bit";
            }
            case 4: {
                return "16 bit";
            }
            case 5: {
                return "32 bit";
            }
            case 6: {
                return "64 bit";
            }
            case 7: {
                return "128 bit";
            }
            case 8: {
                return "1x or x1";
            }
            case 9: {
                return "2x or x2";
            }
            case 10: {
                return "4x or x4";
            }
            case 11: {
                return "8x or x8";
            }
            case 12: {
                return "12x or x12";
            }
            case 13: {
                return "16x or x16";
            }
            case 14: {
                return "32x or x32";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.dataBusWidth[0]) + ")";
    }

    String CurrentUsage() {
        switch (this.currentUsage[0]) {
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "Available";
            }
            case 4: {
                return "In use";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.currentUsage[0]) + ")";
    }

    String SlotLength() {
        switch (this.slotLength[0]) {
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "Short Length";
            }
            case 4: {
                return "Long Length";
            }
            case 5: {
                return "2.5\" drive form factor";
            }
            case 6: {
                return "3.5\" drive form factor";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.slotLength[0]) + ")";
    }

    int SlotId() {
        return ByteUtility.twoBytesToIntLSB(this.slotId);
    }

    String Character1() {
        BitSet bitSet = BitSet.valueOf(this.character1);
        StringBuffer sb = new StringBuffer();
        if (bitSet.get(0)) {
            sb.append(" Characteristics unknown \n");
        }
        if (bitSet.get(1)) {
            sb.append(" Provides 5.0 volts \n");
        }
        if (bitSet.get(2)) {
            sb.append(" Provides 3.3 volts \n");
        }
        if (bitSet.get(3)) {
            sb.append(" Slot\u00a1\u00a6s opening is shared with another slot \n");
        }
        if (bitSet.get(4)) {
            sb.append(" PC Card slot supports PC Card-16 \n");
        }
        if (bitSet.get(5)) {
            sb.append(" PC Card slot supports CardBus \n");
        }
        if (bitSet.get(6)) {
            sb.append(" PC Card slot supports Zoom Video \n");
        }
        if (bitSet.get(7)) {
            sb.append(" PC Card slot supports Modem Ring Resume \n");
        }
        return sb.toString();
    }

    String Character2() {
        BitSet bitSet = BitSet.valueOf(this.character2);
        StringBuffer sb = new StringBuffer();
        if (bitSet.get(0)) {
            sb.append(" PCI slot supports PME# signal \n");
        }
        if (bitSet.get(1)) {
            sb.append(" Slot supports hot-plug devices \n");
        }
        if (bitSet.get(2)) {
            sb.append(" PCI slot supports SMBus signal \n");
        }
        return sb.toString();
    }

    String SegmentGroupNo() {
        return ByteUtility.bytesToHexNoSpace(this.segmentGroupNo);
    }

    String BusNo() {
        return ByteUtility.byteToHex(this.busNo[0]);
    }

    String DeviceNo() {
        int deviceNo = this.deviceFuncNo[0] >> 3;
        return ByteUtility.byteToHex((byte)deviceNo);
    }

    String FunctionNo() {
        int funcNo = this.deviceFuncNo[0] & 7;
        return ByteUtility.byteToHex((byte)funcNo);
    }

    public String getSlotDesign() {
        return this.strField[this.SlotDesign()];
    }

    public String getSlotType() {
        return this.SlotType();
    }

    public String getCurrentUsage() {
        return this.CurrentUsage();
    }

    public String getSlotLength() {
        return this.SlotLength();
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "System Slots"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "Slot Designation", this.strField[this.SlotDesign()] != null ? this.strField[this.SlotDesign()] : "N/A"));
        fStr.append(String.format(format, "Slot Type", this.SlotType()));
        fStr.append(String.format(format, "Data Bus Width", this.DataBusWidth()));
        fStr.append(String.format(format, "Current Usage", this.CurrentUsage()));
        fStr.append(String.format(format, "Slot Length", this.SlotLength()));
        fStr.append(String.format(format, "Slot ID", this.SlotId()));
        fStr.append(String.format(format, "Segment Group Number", StringUtils.isNotBlank(this.SegmentGroupNo()) ? "0x" + this.SegmentGroupNo() : "N/A"));
        fStr.append(String.format(format, "Bus Number", StringUtils.isNotBlank(this.BusNo()) ? "0x" + this.BusNo() : "N/A"));
        fStr.append(String.format(format, "Device Number", StringUtils.isNotBlank(this.DeviceNo()) ? "0x" + this.DeviceNo() : "N/A"));
        fStr.append(String.format(format, "Function Number", StringUtils.isNotBlank(this.FunctionNo()) ? "0x" + this.FunctionNo() : "N/A"));
        if (this.debug) {
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(" Slot Characteristics: \n", new Object[0]));
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(this.Character1() + this.Character2(), new Object[0]));
            fStr.append(String.format("\n", new Object[0]));
        }
        return fStr.toString();
    }
}

