/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public class MemoryDevice
extends TypeStruct {
    byte[] arrayHandle;
    byte[] errorInfoHandle;
    byte[] totalWidth;
    byte[] dataWidth;
    byte[] size;
    byte[] formFactor;
    byte[] deviceSet;
    byte[] deviceLocator;
    byte[] bankLocator;
    byte[] memoryType;
    byte[] typeDetail;
    byte[] speed;
    byte[] manufacturer;
    byte[] serialNumber;
    byte[] assetTag;
    byte[] partNumber;
    byte[] attributes;
    byte[] extendedSize;
    byte[] clockSpeed;
    byte[] minVoltage;
    byte[] maxVoltage;
    byte[] configVoltage;

    public MemoryDevice(byte[] dataByte) {
        super(dataByte);
        this.arrayHandle = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.arrayHandle);
        this.errorInfoHandle = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.errorInfoHandle);
        this.totalWidth = this.getTypeLength(this.WORD);
        this.dataWidth = this.getTypeLength(this.WORD);
        this.size = this.getTypeLength(this.WORD);
        this.formFactor = this.getTypeLength(this.BYTE);
        this.deviceSet = this.getTypeLength(this.BYTE);
        this.deviceLocator = this.getTypeLength(this.BYTE);
        this.bankLocator = this.getTypeLength(this.BYTE);
        this.memoryType = this.getTypeLength(this.BYTE);
        this.typeDetail = this.getTypeLength(this.WORD);
        this.speed = this.getTypeLength(this.WORD);
        this.manufacturer = this.getTypeLength(this.BYTE);
        this.serialNumber = this.getTypeLength(this.BYTE);
        this.assetTag = this.getTypeLength(this.BYTE);
        this.partNumber = this.getTypeLength(this.BYTE);
        this.attributes = this.getTypeLength(this.BYTE);
        this.extendedSize = this.getTypeLength(this.DWORD);
        this.clockSpeed = this.getTypeLength(this.WORD);
        this.minVoltage = this.getTypeLength(this.WORD);
        this.maxVoltage = this.getTypeLength(this.WORD);
        this.configVoltage = this.getTypeLength(this.WORD);
        this.strFieldCount = 8;
    }

    String getArrayHandle() {
        return ByteUtility.bytesToHexNoSpace(this.arrayHandle);
    }

    String getErrorInfoHandle() {
        String errorInfo = ByteUtility.bytesToHexNoSpace(this.errorInfoHandle);
        if ("FFFE".equalsIgnoreCase(errorInfo)) {
            return "Not provided";
        }
        if ("FFFF".equalsIgnoreCase(errorInfo)) {
            return "No error was detected";
        }
        return "Undefine (0x" + errorInfo + ")";
    }

    int getTotalWidth() {
        String width = ByteUtility.bytesToHexNoSpace(this.totalWidth);
        if ("FFFF".equalsIgnoreCase(width)) {
            return 0;
        }
        int widthInt = ByteUtility.twoBytesToIntLSB(this.totalWidth);
        return widthInt;
    }

    int getDataWidth() {
        String width = ByteUtility.bytesToHexNoSpace(this.dataWidth);
        if ("FFFF".equalsIgnoreCase(width)) {
            return 0;
        }
        int widthInt = ByteUtility.twoBytesToIntLSB(this.dataWidth);
        return widthInt;
    }

    String getSize() {
        String sizeHex = ByteUtility.bytesToHexNoSpace(this.size);
        if ("0000".equals(sizeHex)) {
            return "No memory device is installed";
        }
        if ("FFFF".equalsIgnoreCase(sizeHex)) {
            return "Unknown";
        }
        int sizeInt = ByteUtility.twoBytesToIntLSB(this.size);
        return sizeInt + " MB";
    }

    String getFormFactor() {
        String factor;
        switch (factor = ByteUtility.byteToHex(this.formFactor[0])) {
            case "01": {
                return "Other";
            }
            case "02": {
                return "Unknown";
            }
            case "03": {
                return "SIMM";
            }
            case "04": {
                return "SIP";
            }
            case "05": {
                return "Chip";
            }
            case "06": {
                return "DIP";
            }
            case "07": {
                return "ZIP";
            }
            case "08": {
                return "Proprietary Card";
            }
            case "09": {
                return "DIMM";
            }
            case "0A": {
                return "TSOP";
            }
            case "0B": {
                return "Row of chips";
            }
            case "0C": {
                return "RIMM";
            }
            case "0D": {
                return "SODIMM";
            }
            case "0E": {
                return "SRIMM";
            }
            case "0F": {
                return "FB-DIMM";
            }
        }
        return "Unknown (" + factor + ")";
    }

    String getDeviceSet() {
        String deviceSetHex;
        switch (deviceSetHex = ByteUtility.byteToHex(this.deviceSet[0])) {
            case "00": {
                return "Not part of a set";
            }
            case "FF": {
                return "Unknown";
            }
        }
        return "0x" + deviceSetHex;
    }

    int getDeviceLocator() {
        return this.deviceLocator[0];
    }

    int getBankLocator() {
        return this.bankLocator[0];
    }

    String getMemoryType() {
        String type;
        switch (type = ByteUtility.byteToHex(this.memoryType[0])) {
            case "01": {
                return "Other";
            }
            case "02": {
                return "Unknown";
            }
            case "03": {
                return "DRAM";
            }
            case "04": {
                return "EDRAM";
            }
            case "05": {
                return "VRAM";
            }
            case "06": {
                return "SRAM";
            }
            case "07": {
                return "RAM";
            }
            case "08": {
                return "ROM";
            }
            case "09": {
                return "FLASH";
            }
            case "0A": {
                return "EEPROM";
            }
            case "0B": {
                return "FEPROM";
            }
            case "0C": {
                return "EPROM";
            }
            case "0D": {
                return "CDRAM";
            }
            case "0E": {
                return "3DRAM";
            }
            case "0F": {
                return "SDRAM";
            }
            case "10": {
                return "SGRAM";
            }
            case "11": {
                return "RDRAM";
            }
            case "12": {
                return "DDR";
            }
            case "13": {
                return "DDR2";
            }
            case "14": {
                return "DDR2 FB-DIMM";
            }
            case "18": {
                return "DDR3";
            }
            case "19": {
                return "FBD2";
            }
            case "1A": {
                return "DDR4";
            }
            case "1B": {
                return "LPDDR";
            }
            case "1C": {
                return "LPDDR2";
            }
            case "1D": {
                return "LPDDR3";
            }
            case "1E": {
                return "LPDDR4";
            }
        }
        return "Unknown (0x" + type + ")";
    }

    String getTypeDetail() {
        BitSet bitSet = BitSet.valueOf(this.typeDetail);
        if (bitSet.get(1)) {
            return "Other";
        }
        if (bitSet.get(2)) {
            return "Unknown";
        }
        if (bitSet.get(3)) {
            return "Fast-paged";
        }
        if (bitSet.get(4)) {
            return "Static column";
        }
        if (bitSet.get(5)) {
            return "Pseudo-static";
        }
        if (bitSet.get(6)) {
            return "RAMBUS";
        }
        if (bitSet.get(7)) {
            return "Synchronous";
        }
        if (bitSet.get(8)) {
            return "CMOS";
        }
        if (bitSet.get(9)) {
            return "EDO";
        }
        if (bitSet.get(10)) {
            return "Window DRAM";
        }
        if (bitSet.get(11)) {
            return "Cache DRAM";
        }
        if (bitSet.get(12)) {
            return "Non-volatile";
        }
        if (bitSet.get(13)) {
            return "Registered (Buffered)";
        }
        if (bitSet.get(14)) {
            return "Unbuffered (Unregistered)";
        }
        if (bitSet.get(15)) {
            return "LRDIMM";
        }
        return "Unknown (0x" + ByteUtility.bytesToHexNoSpace(this.typeDetail) + ")";
    }

    int getSpeed() {
        return ByteUtility.twoBytesToIntLSB(this.speed);
    }

    int getManufacturer() {
        return this.manufacturer[0];
    }

    int getSerialNumber() {
        return this.serialNumber[0];
    }

    int getAssetTag() {
        return this.assetTag[0];
    }

    int getPartNumber() {
        return this.partNumber[0];
    }

    int getAttributes() {
        BitSet bitSet = BitSet.valueOf(this.attributes);
        BitSet bitStatus = BitSet.valueOf(new byte[]{7});
        bitSet.and(bitStatus);
        return MemoryDevice.bitsToInt(bitSet);
    }

    int getExtendedSize() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.extendedSize);
    }

    int getConfigClockSpeed() {
        return ByteUtility.twoBytesToIntLSB(this.clockSpeed);
    }

    int getMinVoltage() {
        return ByteUtility.twoBytesToIntLSB(this.minVoltage);
    }

    int getMaxVoltage() {
        return ByteUtility.twoBytesToIntLSB(this.maxVoltage);
    }

    int getConfigVoltage() {
        return ByteUtility.twoBytesToIntLSB(this.configVoltage);
    }

    public String getMemoryDeviceLocator() {
        return this.strField[this.getDeviceLocator()] != null ? this.strField[this.getDeviceLocator()] : "N/A";
    }

    public int getMemorySize() {
        return ByteUtility.twoBytesToIntLSB(this.size);
    }

    public String getMemorySpeed() {
        return this.getSpeed() != 0 ? "@" + this.getSpeed() + " MHz" : "Unknown";
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "Memory Device"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
            fStr.append(String.format(format, "Array Handle", "0x" + this.getArrayHandle()));
            fStr.append(String.format(format, "Error Info Handle", this.getErrorInfoHandle()));
        }
        fStr.append(String.format(format, "Total Width", this.getTotalWidth() != 0 ? this.getTotalWidth() + " bits" : "Unknown"));
        fStr.append(String.format(format, "Data Width", this.getDataWidth() != 0 ? this.getDataWidth() + " bits" : "Unknown"));
        fStr.append(String.format(format, "Size", this.getSize()));
        fStr.append(String.format(format, "Form Factor", this.getFormFactor()));
        fStr.append(String.format(format, "Device Set", this.getDeviceSet()));
        fStr.append(String.format(format, "Device Locator", this.strField[this.getDeviceLocator()] != null ? this.strField[this.getDeviceLocator()] : "N/A"));
        fStr.append(String.format(format, "Bank Locator", this.strField[this.getBankLocator()] != null ? this.strField[this.getBankLocator()] : "N/A"));
        fStr.append(String.format(format, "Memory Type", this.getMemoryType()));
        fStr.append(String.format(format, "Type Detail", this.getTypeDetail()));
        fStr.append(String.format(format, "Speed", this.getSpeed() != 0 ? this.getSpeed() + " MHz" : "Unknown"));
        fStr.append(String.format(format, "Manufacturer", this.strField[this.getManufacturer()] != null ? this.strField[this.getManufacturer()] : "N/A"));
        fStr.append(String.format(format, "Serial Number", this.strField[this.getSerialNumber()] != null ? this.strField[this.getSerialNumber()] : "N/A"));
        fStr.append(String.format(format, "Asset Tag", this.strField[this.getAssetTag()] != null ? this.strField[this.getAssetTag()] : "N/A"));
        fStr.append(String.format(format, "Part Number", this.strField[this.getPartNumber()] != null ? this.strField[this.getPartNumber()] : "N/A"));
        fStr.append(String.format(format, "Attributes", this.getAttributes() != 0 ? "Rank: " + this.getAttributes() : "Unknown rank information"));
        fStr.append(String.format(format, "Extended Size", this.getExtendedSize() + " MB"));
        fStr.append(String.format(format, "Config Clock Speed", this.getConfigClockSpeed() != 0 ? this.getConfigClockSpeed() + " MHz" : "Unknown"));
        fStr.append(String.format(format, "Minimum Voltage", this.getMinVoltage() != 0 ? (float)this.getMinVoltage() / 1000.0f + " V" : "Unknown"));
        fStr.append(String.format(format, "Maximum Voltage", this.getMaxVoltage() != 0 ? (float)this.getMaxVoltage() / 1000.0f + " V" : "Unknown"));
        fStr.append(String.format(format, "Configured Voltage", this.getConfigVoltage() != 0 ? (float)this.getConfigVoltage() / 1000.0f + " V" : "Unknown"));
        fStr.append(String.format("\n", new Object[0]));
        return fStr.toString();
    }
}

