/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade.cmmdiag;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMICMMDiagCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.microblade.cmmdiag.CMMDiagCpuTemp;
import com.supermicro.ipmi.microblade.cmmdiag.NodeStatus;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCMMDiagCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import nn.pp.drvredir.ByteUtility;
import org.apache.commons.lang3.StringUtils;

public class CMMDiagScenario {
    static String formatTemplate = "  %-17s | %-30s | %s  \n";
    static String formatHeaderTemplate = "  %-17s | %-30s  \n";
    boolean isShowLog = false;
    StringBuilder stringBuilder = null;
    List<String> list = new ArrayList<String>();
    boolean isHeaderShown = false;
    String errorBladeIP = "errorBladeIPMap";
    String allBladeIP = "allBladeIPMap";
    boolean isDebug = false;

    public void run(IPMICMMDiagCommand ipmiCommand, byte discreteReading, ArrayList<String> sdrRecordList, IPMIInterfaceConfig config) {
        if (discreteReading == -1) {
            String cmmFWVer = this.getCMMFW(ipmiCommand, config);
            if ("".equals(cmmFWVer)) {
                MOut.G().println("Cannot read enclosure " + config.getIp() + " health status and firmware version");
            } else {
                String firstDigit = cmmFWVer.substring(0, 1);
                int digit = Integer.parseInt(firstDigit);
                if (digit < 3) {
                    MOut.G().println("Current firmware version is " + cmmFWVer + ", please upgrade enclousure " + config.getIp() + "cmm firmware to support cmmdiag command");
                } else {
                    MOut.G().println("Cannot read enclosure " + config.getIp() + " health status for cmm firmawre version " + cmmFWVer + ", please check CMM SDR and try again");
                }
            }
            return;
        }
        String ledStatus = "";
        String failReason = "Fail";
        boolean isThrottling = this.diagThrottle(ipmiCommand) | this.diagPSUOff(ipmiCommand);
        switch (discreteReading) {
            case 0: {
                if (!isThrottling) {
                    ++MicroBladeCMMDiagCommand.passTest;
                    MOut.G().println("Pass");
                    return;
                }
                ledStatus = "Normal but Blade Throttling";
                break;
            }
            case 1: {
                ledStatus = "Warning";
                break;
            }
            case 2: {
                ledStatus = "Critical";
                break;
            }
            case 4: {
                ledStatus = "Flashing";
                break;
            }
            case 8: {
                ledStatus = "Initializing";
                break;
            }
            default: {
                if (!this.isShowLog) break;
                MOut.G().println("Unknow");
            }
        }
        if (discreteReading != 0) {
            this.cmmSensorReading(ipmiCommand, ledStatus, sdrRecordList, config);
        }
        Map<String, Map<IPMIInterfaceConfig, String>> map = this.diagBlade(ipmiCommand, isThrottling);
        MOut.G().println(ledStatus);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        String dateString = format.format(new Date());
        String fileName = config.getIp() + "_" + dateString + "_Diag_Result";
        this.writeToFile(fileName + ".log");
        MOut.G().println(ledStatus);
    }

    private boolean diagPSUOff(IPMICMMDiagCommand ipmiCommand) {
        boolean isThrottle = false;
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(ipmiCommand.getIPMIInterface());
        String psuModeName = "";
        String psuRealModelName = "";
        String psuIndex = "";
        byte[] psuLocation = new byte[]{11, 12};
        byte[] psuSubLocation = new byte[]{112, 114, 116, 118};
        try {
            for (int i = 0; i < psuLocation.length; ++i) {
                for (int j = 0; j < psuSubLocation.length; ++j) {
                    PowerSupplyInfo powerSupplyInfo = ipmiMicroBladeOEMCommand.getPowerSupply((byte)(i * psuSubLocation.length + j), (byte)1);
                    if (powerSupplyInfo.isPresent()) {
                        BufferedReader bufReader = new BufferedReader(new StringReader(powerSupplyInfo.toFormatedString()));
                        String line = null;
                        while ((line = bufReader.readLine()) != null) {
                            if (line.indexOf("Power Supply") <= -1 || line.split("\\|").length <= 1) continue;
                            psuIndex = line.split("\\|")[1].trim();
                        }
                        psuModeName = powerSupplyInfo.getModelName().trim();
                        bufReader.close();
                    }
                    IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(ipmiCommand.getIPMIInterface());
                    FRUInfo fruInfo = null;
                    try {
                        fruInfo = ipmiFRUCommand.getFRUData((byte)(i * 4 + j + 7));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    if (fruInfo != null) {
                        BufferedReader bufReader = new BufferedReader(new StringReader(fruInfo.toReadableStringForFRU1()));
                        String line = null;
                        try {
                            while ((line = bufReader.readLine()) != null) {
                                if (line.indexOf("(PPM)") <= -1 || line.split("=").length <= 1) continue;
                                psuRealModelName = line.split("=")[1].trim();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        bufReader.close();
                    }
                    boolean psuHead = false;
                    if (!psuModeName.equalsIgnoreCase(psuRealModelName)) {
                        isThrottle = true;
                        psuHead = true;
                        this.print(psuIndex, "Model Name Inconsistent", "run-time model name " + psuModeName + ", fru reading is" + psuRealModelName);
                    }
                    byte psuStatus = 0;
                    try {
                        psuStatus = ipmiCommand.getPSUStatus(psuLocation[i], psuSubLocation[j]);
                        if (psuStatus != 0 && psuStatus != 3) continue;
                        isThrottle = true;
                        if (!psuHead) {
                            this.print(psuIndex, "Power Status", "Power Off");
                            continue;
                        }
                        this.print("", "Power Status", "Power Off");
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IPMIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isThrottle;
    }

    private void zipFiles(List<String> totalList, String fileName) {
        if (totalList != null && totalList.size() > 0) {
            try {
                FileOutputStream fos = new FileOutputStream(fileName + ".zip");
                ZipOutputStream zipOut = new ZipOutputStream(fos);
                for (String srcFile : totalList) {
                    int length;
                    File fileToZip = new File(srcFile);
                    FileInputStream fis = new FileInputStream(fileToZip);
                    ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                    zipOut.putNextEntry(zipEntry);
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                    fis.close();
                }
                zipOut.close();
                fos.close();
                for (String srcFile : totalList) {
                    File file = new File(srcFile);
                    file.delete();
                }
                MOut.G().println("Zip all trouble shooting files into: " + fileName + ".zip");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<String> preCheckDownload(IPMICMMDiagCommand ipmiCommand, Map<IPMIInterfaceConfig, String> bladeIPMap) {
        ArrayList<String> logList = new ArrayList<String>();
        try {
            for (Map.Entry<IPMIInterfaceConfig, String> entry : bladeIPMap.entrySet()) {
                IPMIInterface ipmiInterface = this.getIPMIInterface(entry.getKey());
                IPMICMMDiagCommand ipmiCMMDiagCommand = new IPMICMMDiagCommand(ipmiInterface);
                if (ipmiCMMDiagCommand.getDownloadStatus() != 1) continue;
                IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(ipmiInterface);
                String filename = "Pre_download_" + entry.getValue() + "_" + entry.getKey().getIp() + ".log";
                filename = filename.replaceAll(" ", "_");
                boolean result = ipmiBMCFileCommand.generalFileDownload(Byte.parseByte("19"), filename, false, false);
                if (!result) {
                    MOut.G().println("Download fail from " + entry.getKey().getIp() + " " + entry.getValue());
                    continue;
                }
                logList.add(filename);
            }
            return logList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> generateFileDownload(String cmmIP, IPMICMMDiagCommand ipmiCommand, Map<IPMIInterfaceConfig, String> bladeIPMap) {
        ArrayList<String> logList = new ArrayList<String>();
        String bladeName = "";
        try {
            for (Map.Entry<IPMIInterfaceConfig, String> entry : bladeIPMap.entrySet()) {
                bladeName = entry.getValue();
                byte genereateReuslt = ipmiCommand.generateTroubleShooting((byte)2);
                if (genereateReuslt == 0) {
                    IPMIInterface ipmiInterface = this.getIPMIInterface(entry.getKey());
                    IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(ipmiInterface);
                    String filename = "Cur_download_" + entry.getValue() + "_" + entry.getKey().getIp() + ".log";
                    filename = filename.replaceAll(" ", "_");
                    boolean result = ipmiBMCFileCommand.generalFileDownload(Byte.parseByte("19"), filename, false, false);
                    if (!result) {
                        MOut.G().println("Trouble shooting file is not ready for " + entry.getKey().getIp() + " " + entry.getValue());
                        continue;
                    }
                    logList.add(filename);
                    continue;
                }
                if (genereateReuslt == -64) {
                    MOut.G().println("Blade is generating now, Cannot Re-generate trouble shooting for CMM " + cmmIP + " " + entry.getValue());
                    MOut.G().println("Please check blade web directly");
                    continue;
                }
                MOut.G().println("Generate result is not 00 or C0 for CMM " + cmmIP + " " + entry.getValue());
                MOut.G().println("Please check blade web directly");
            }
            return logList;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IPMIException e) {
            MOut.G().println("Cannot Generate trouble shooting for CMM " + cmmIP + " " + bladeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Map<String, Map<IPMIInterfaceConfig, String>> diagBlade(IPMICMMDiagCommand ipmiCommand, boolean isThrottling) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(ipmiCommand.getIPMIInterface());
        NodeSensorInfo[][] sensorInfoArray = new NodeSensorInfo[28][4];
        HashMap<IPMIInterfaceConfig, String> errorbladeIPMap = new HashMap<IPMIInterfaceConfig, String>();
        HashMap<IPMIInterfaceConfig, String> allBladeIPMap = new HashMap<IPMIInterfaceConfig, String>();
        HashMap<String, Map<IPMIInterfaceConfig, String>> map = new HashMap<String, Map<IPMIInterfaceConfig, String>>();
        try {
            for (int i = 0; i < 28; ++i) {
                BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo((byte)i);
                for (int j = 0; j < 4; ++j) {
                    NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus((byte)i, (byte)j);
                    if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) continue;
                    boolean isFirstBlade = false;
                    NodeSensorInfo nodeSensorInfo = ipmiMicroBladeOEMCommand.getNodeSensor((byte)i, (byte)j);
                    BufferedReader bufferReader = null;
                    bufferReader = new BufferedReader(new StringReader(nodeSensorInfo.sBEntity.toFormatedString()));
                    sensorInfoArray[i][j] = nodeSensorInfo;
                    String nodeIndex = "Blade " + NodeSensorInfo.getBladeIndex(i) + " Node " + (j + 1);
                    IPMIInterfaceConfig ipmiConfig = new IPMIInterfaceConfig();
                    ipmiConfig.setIp(nodeSensorInfo.getBMCIP());
                    ipmiConfig.setUserName(nodeSensorInfo.getDecryptedUsername());
                    ipmiConfig.setPassword(nodeSensorInfo.getDecryptedPassword());
                    IPMIInterface precheckInterface = null;
                    try {
                        precheckInterface = this.getIPMIInterface(ipmiConfig);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    try {
                        IPMICMMDiagCommand ipmiCMMDiagCommand = new IPMICMMDiagCommand(precheckInterface);
                        if (ipmiCMMDiagCommand.getDownloadStatus() == 1) {
                            allBladeIPMap.put(ipmiConfig, nodeIndex);
                        }
                    }
                    catch (Exception ipmiCMMDiagCommand) {
                        // empty catch block
                    }
                    byte bladeLocation = 0;
                    int nodeLocation = 0;
                    if (isThrottling) {
                        String hex1;
                        String nodeLocation1 = NodeSensorInfo.getBladeIndex(i).substring(0, 1);
                        String nodeLocation2 = NodeSensorInfo.getBladeIndex(i).substring(1);
                        if (nodeLocation1.equalsIgnoreCase("a")) {
                            hex1 = Integer.toHexString(Integer.parseInt(nodeLocation2));
                            byte hex2 = Byte.parseByte(hex1, 16);
                            int hexFor0xAx = -96;
                            bladeLocation = (byte)(hexFor0xAx + hex2);
                        } else if (nodeLocation1.equalsIgnoreCase("b")) {
                            hex1 = Integer.toHexString(Integer.parseInt(nodeLocation2));
                            byte hex2 = Byte.parseByte(hex1, 16);
                            int hexFor0xBx = -80;
                            bladeLocation = (byte)(hexFor0xBx + hex2);
                        }
                        switch (j) {
                            case 0: {
                                nodeLocation = 0;
                                break;
                            }
                            case 1: {
                                nodeLocation = 1;
                                break;
                            }
                            case 2: {
                                nodeLocation = 2;
                                break;
                            }
                            case 3: {
                                nodeLocation = 3;
                            }
                        }
                        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
                        config.setIp(nodeSensorInfo.getBMCIP());
                        config.setUserName(nodeSensorInfo.getDecryptedUsername());
                        config.setPassword(nodeSensorInfo.getDecryptedPassword());
                        try {
                            IPMIInterface ipmiInterface = this.getIPMIInterface(config);
                            IPMICMMDiagCommand ipmiBladeCommand = new IPMICMMDiagCommand(ipmiInterface);
                            CMMDiagCpuTemp[] cpus = ipmiBladeCommand.isCPUsHighCT();
                            for (int k = 0; k < cpus.length; ++k) {
                                if (!cpus[k].isHighCT) continue;
                                if (!isFirstBlade) {
                                    isFirstBlade = true;
                                    this.print(nodeIndex, "CPU" + (k + 1) + "Thermal", "CPU Temperature is " + cpus[k].getTemperature());
                                    continue;
                                }
                                this.print("", "CPU" + (k + 1) + "Thermal", "CPU Temperature is " + cpus[k].getTemperature());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (nodeSensorInfo.error() == 0) {
                        try {
                            if (bufferReader == null) continue;
                            bufferReader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    IPMIInterfaceConfig config = new IPMIInterfaceConfig();
                    config.setIp(nodeSensorInfo.getBMCIP());
                    config.setUserName(nodeSensorInfo.getDecryptedUsername());
                    config.setPassword(nodeSensorInfo.getDecryptedPassword());
                    errorbladeIPMap.put(config, "Blade_" + NodeSensorInfo.getBladeIndex(i) + "_Node_" + (j + 1));
                    if (!isFirstBlade) {
                        isFirstBlade = true;
                        this.print(nodeIndex, "System Health", "Error");
                    } else {
                        this.print("", "System Health", "Error");
                    }
                    this.print("", "BMC Version", nodeSensorInfo.getBMCVer());
                    this.print("", "BIOS Version", nodeSensorInfo.getBIOSVer());
                    this.print("", "BMC Model", nodeSensorInfo.getModelName());
                    FRUInfo fruInfo = null;
                    try {
                        IPMIInterface ipmiInterface = this.getIPMIInterface(config);
                        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(ipmiInterface);
                        fruInfo = ipmiFRUCommand.getFRUData();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    if (fruInfo != null) {
                        this.getSerialFromFRU(fruInfo, new String[0]);
                    }
                    String line = null;
                    try {
                        if (bufferReader != null) {
                            String name = "";
                            while ((line = bufferReader.readLine()) != null) {
                                if (line.indexOf("Normal") != -1 || line.indexOf("N/A") != -1 || line.split("\\|").length <= 1) continue;
                                int second = StringUtils.ordinalIndexOf(line, "|", 2);
                                name = line.split("\\|")[1].trim();
                                line = line.substring(second + 1).trim();
                                this.print("", name, line);
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (bufferReader == null) continue;
                        bufferReader.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.diagBladeInitial(ipmiCommand, sensorInfoArray, errorbladeIPMap, allBladeIPMap);
        }
        catch (IPMIException e) {
            e.printStackTrace();
        }
        map.put(this.errorBladeIP, errorbladeIPMap);
        map.put(this.allBladeIP, allBladeIPMap);
        return map;
    }

    private void diagBladeInitial(IPMICMMDiagCommand ipmiCommand, NodeSensorInfo[][] sensorInfoArray, Map<IPMIInterfaceConfig, String> errorbladeIPMap, Map<IPMIInterfaceConfig, String> allBladeIPMap) {
        byte[] bladeNameIndex = new byte[]{-95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66};
        byte[] nodeNameIndex = new byte[]{0, 1, 2, 3};
        NodeStatus nodeStatus = null;
        try {
            for (int i = 0; i < bladeNameIndex.length; ++i) {
                nodeStatus = ipmiCommand.checkBladeInitial(bladeNameIndex[i], (byte)0);
                boolean nonZero = false;
                for (byte data : nodeStatus.getRaw()) {
                    if (0 == data) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) continue;
                boolean bladeInitFlag = false;
                for (int j = 0; j < nodeNameIndex.length; ++j) {
                    nodeStatus = ipmiCommand.checkBladeInitial(bladeNameIndex[i], nodeNameIndex[j]);
                    String nodeFlagBit = String.format("%8s", Integer.toBinaryString(nodeStatus.getFirst() & 0xFF)).replace(' ', '0');
                    String secondBit = nodeFlagBit.substring(6, 7);
                    if ("1".equalsIgnoreCase(secondBit)) continue;
                    String nodeIndex = "Blade " + NodeSensorInfo.getBladeIndex(i) + " Node " + (j + 1);
                    byte IPMBError = nodeStatus.getFlag();
                    if (0 == IPMBError) continue;
                    boolean bladeInitIPFlag = false;
                    bladeInitFlag = true;
                    String ip = ipmiCommand.getSpecialCaseOfNodeIP(bladeNameIndex[i], (byte)1);
                    if (!"00.00.00.00".equalsIgnoreCase(ip)) {
                        bladeInitIPFlag = true;
                        this.print(nodeIndex, "System Health", "Initializing");
                        this.print("", "BMC Version", sensorInfoArray[i][j].getBMCVer());
                        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
                        config.setIp(sensorInfoArray[i][j].getBMCIP());
                        config.setUserName(sensorInfoArray[i][j].getDecryptedUsername());
                        config.setPassword(sensorInfoArray[i][j].getDecryptedPassword());
                        errorbladeIPMap.put(config, "Blade_" + NodeSensorInfo.getBladeIndex(i) + "_Node_" + (j + 1));
                        try {
                            IPMIInterface ipmiInterface = this.getIPMIInterface(config);
                            IPMICMMDiagCommand ipmiCMMDiagCommand = new IPMICMMDiagCommand(ipmiInterface);
                            try {
                                if (ipmiCMMDiagCommand.getDownloadStatus() == 1) {
                                    allBladeIPMap.put(config, nodeIndex);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(ipmiInterface);
                            FRUInfo fruInfo = ipmiFRUCommand.getFRUData();
                            if (fruInfo != null) {
                                this.getSerialFromFRU(fruInfo, new String[0]);
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (!bladeInitFlag || bladeInitIPFlag) continue;
                    this.print(nodeIndex, "System Health", "Initializing");
                    this.print("", "", "Cannot get blade ip");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean diagThrottle(IPMICMMDiagCommand ipmiCommand) {
        boolean isThrottle = false;
        String bbpFW = "";
        try {
            byte[] bbpFWByte = ipmiCommand.getBBPFW();
            if (bbpFWByte.length == 4 || bbpFWByte.length == 2) {
                bbpFW = bbpFWByte.length == 2 ? ByteUtility.byteToHex(bbpFWByte[0]) + "." + ByteUtility.byteToHex(bbpFWByte[1]) : (bbpFWByte[2] == 1 ? ByteUtility.byteToHex(bbpFWByte[0]) + "." + ByteUtility.byteToHex(bbpFWByte[1]) + "A" : ByteUtility.byteToHex(bbpFWByte[0]) + "." + ByteUtility.byteToHex(bbpFWByte[1]));
                if (ipmiCommand.isBBPThrottle()) {
                    this.print("Enclosure BBP", "Status", "BBP Throttle");
                    this.print("", "BBP Version", bbpFW);
                    isThrottle = true;
                }
            }
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        try {
            boolean isRemainPower = ipmiCommand.isCMMRemainPower();
            if (!isRemainPower) {
                this.print("Enclosure Power", "Status", "CMM doesn't have enough Power");
                isThrottle = true;
            }
        }
        catch (IPMIException e) {
            e.printStackTrace();
        }
        boolean isBladeThrottle = this.diagBladeThrottle(ipmiCommand);
        return isThrottle | isBladeThrottle;
    }

    boolean diagBladeThrottle(IPMICMMDiagCommand ipmiCommand) {
        boolean isThrottle = false;
        boolean isBladeThrottle = false;
        int totalConsumed = this.getTotalPowerComsumption(ipmiCommand);
        int availableBlade = 0;
        this.print("Enclosure", "Total Power Consumption", totalConsumed + "W");
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(ipmiCommand.getIPMIInterface());
        NodeSensorInfo[][] sensorInfoArray = new NodeSensorInfo[28][4];
        HashMap errorbladeIPMap = new HashMap();
        HashMap allBladeIPMap = new HashMap();
        HashMap map = new HashMap();
        try {
            for (int i = 0; i < 28; ++i) {
                BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo((byte)i);
                if (!bladeRemoteInfo.isPresent()) continue;
                ++availableBlade;
                for (int j = 0; j < 4; ++j) {
                    NodeSensorInfo nodeSensorInfo;
                    isBladeThrottle = false;
                    NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus((byte)i, (byte)j);
                    if (!nodeStatusInfo.initialized()) continue;
                    boolean isFirstBlade = false;
                    sensorInfoArray[i][j] = nodeSensorInfo = ipmiMicroBladeOEMCommand.getNodeSensor((byte)i, (byte)j);
                    String nodeIndex = "Blade " + NodeSensorInfo.getBladeIndex(i) + " Node " + (j + 1);
                    if (this.isDebug) {
                        System.out.println("===========================");
                        System.out.println(nodeIndex);
                    }
                    try {
                        byte hex2;
                        byte bladeLocation = 0;
                        byte nodeLocation = 0;
                        String nodeLocation1 = NodeSensorInfo.getBladeIndex(i).substring(0, 1);
                        String nodeLocation2 = NodeSensorInfo.getBladeIndex(i).substring(1);
                        if (nodeLocation1.equalsIgnoreCase("a")) {
                            String hex1 = Integer.toHexString(Integer.parseInt(nodeLocation2));
                            hex2 = Byte.parseByte(hex1, 16);
                            int hexFor0xAx = -96;
                            bladeLocation = (byte)(hexFor0xAx + hex2);
                        } else if (nodeLocation1.equalsIgnoreCase("b")) {
                            String hex1 = Integer.toHexString(Integer.parseInt(nodeLocation2));
                            hex2 = Byte.parseByte(hex1, 16);
                            int hexFor0xBx = -80;
                            bladeLocation = (byte)(hexFor0xBx + hex2);
                        }
                        switch (j) {
                            case 0: {
                                nodeLocation = 0;
                                break;
                            }
                            case 1: {
                                nodeLocation = 1;
                                break;
                            }
                            case 2: {
                                nodeLocation = 2;
                                break;
                            }
                            case 3: {
                                nodeLocation = 3;
                            }
                        }
                        byte throttle = ipmiCommand.getBladeThrottle(bladeLocation, nodeLocation);
                        byte throttleBit = (byte)(throttle & 0x40);
                        byte throttleLockBit = (byte)(throttle & 0x20);
                        byte bladeHealthBit = (byte)(throttle & 6);
                        String bladeHeath = "";
                        switch (bladeHealthBit) {
                            case 0: {
                                bladeHeath = "Normal";
                                break;
                            }
                            case 2: {
                                bladeHeath = "Initializing";
                                break;
                            }
                            case 4: {
                                bladeHeath = "Critical";
                                break;
                            }
                            case 6: {
                                bladeHeath = "Flashing";
                            }
                        }
                        byte[] cpldData = ipmiCommand.getBladeCPLDVersion(bladeLocation, nodeLocation);
                        String cpldVersion = "";
                        if (cpldData.length > 3) {
                            cpldVersion = ByteUtility.byteToHex(cpldData[3]) + "." + ByteUtility.byteToHex(cpldData[2]) + ByteUtility.byteToHex(cpldData[1]);
                        }
                        String bladeBMCVersion = nodeSensorInfo.getBMCVer();
                        String bladeBMCIP = nodeSensorInfo.getBMCIP();
                        String bladeModeName = nodeSensorInfo.getModelName();
                        String bladeBIOSVersion = nodeSensorInfo.getBIOSVer();
                        String bladeBIOSBuildDate = nodeSensorInfo.getBIOSDate();
                        byte bladePowerStatus = nodeSensorInfo.getPowerStatus();
                        int bladeCurrentPower = nodeSensorInfo.getCurPower();
                        if (bladeCurrentPower != 0) {
                            this.print(nodeIndex, "Run-time Power Consumption", bladeCurrentPower + "W");
                        }
                        byte capping = 0;
                        try {
                            capping = ipmiCommand.getPowerCapping(bladeLocation, nodeLocation);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String powerCappingDescription = "";
                        switch (capping) {
                            case 0: {
                                powerCappingDescription = "";
                                break;
                            }
                            case -64: {
                                powerCappingDescription = "CMM Read Only Model";
                                break;
                            }
                            case -127: {
                                powerCappingDescription = "";
                                break;
                            }
                            case -123: {
                                powerCappingDescription = "CMM set as 50% Model";
                                break;
                            }
                            case -122: {
                                powerCappingDescription = "CMM set as 60% Model";
                                break;
                            }
                            case -121: {
                                powerCappingDescription = "CMM set as 70% Model";
                                break;
                            }
                            case -120: {
                                powerCappingDescription = "CMM set as 80% Model";
                                break;
                            }
                            case -119: {
                                powerCappingDescription = "CMM set as 90% Model";
                            }
                        }
                        if (!"".equalsIgnoreCase(powerCappingDescription)) {
                            if (nodeSensorInfo.getPowerStatus() == 1) {
                                try {
                                    byte node_index = 1;
                                    byte[] cappingValue = ipmiCommand.getPowerCappingValue(bladeLocation, node_index);
                                    if (cappingValue.length == 16) {
                                        String powerCappingValue = ByteUtility.byteToHex(cappingValue[2]) + ByteUtility.byteToHex(cappingValue[3]);
                                        int powerCappingIntegerValue = Integer.parseInt(powerCappingValue, 16);
                                        powerCappingDescription = powerCappingDescription + " Max Pwr " + powerCappingIntegerValue + "W";
                                    } else if ("CMM Read Only Model".equals(powerCappingDescription)) {
                                        powerCappingDescription = "";
                                    }
                                }
                                catch (Exception e) {
                                    powerCappingDescription = "";
                                }
                            } else {
                                powerCappingDescription = "";
                            }
                        }
                        if (!"".equals(powerCappingDescription)) {
                            this.print("", "Power Capping Policy", powerCappingDescription);
                        }
                        byte BMCRegID = 0;
                        boolean isBMCRegIDEmpty = false;
                        byte node_index = 1;
                        try {
                            BMCRegID = ipmiCommand.getBMCRegID(bladeLocation, node_index);
                        }
                        catch (Exception e) {
                            isBMCRegIDEmpty = true;
                        }
                        if (this.isDebug) {
                            System.out.println(bladeModeName + " " + ByteUtility.byteToHex(BMCRegID));
                        }
                        if (bladeModeName.contains("B2SS1")) {
                            byte GPIOA4State = ipmiCommand.getGPIOState(bladeLocation, nodeLocation, (byte)4);
                            if (GPIOA4State == 0) {
                                isBladeThrottle = true;
                                this.print("", "BMC Throttling", "BMC pull GPIO to throttle CPU1");
                            }
                        } else {
                            byte CPLOGPO0Bit10;
                            byte CPLOGPO0Bit7;
                            byte CPLOGPO0Bit6;
                            byte GPIOA3State;
                            if (bladeModeName.contains("B11DPE") && (GPIOA3State = ipmiCommand.getGPIOState(bladeLocation, node_index, (byte)3)) == 0) {
                                isBladeThrottle = true;
                                this.print("", "BMC Throttling", "BMC PWRFAIL_FANFAIL GPIO throttle CPU");
                            }
                            if (BMCRegID == 68 || BMCRegID == 67) {
                                byte CPLOGPO2Bit1;
                                byte CPLOGPO2Bit0;
                                byte CPLOGPO2Bit3;
                                byte CPLOGPO2Bit2;
                                byte CPLOGPO2Bit5;
                                byte CPLOGPO2Bit4;
                                byte CPLOGPO2Bit7;
                                byte CPLOGPO2;
                                byte CPLOGPO2Bit6;
                                byte CPLOGPO0 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)0);
                                CPLOGPO0Bit6 = (byte)(CPLOGPO0 & 0x40);
                                CPLOGPO0Bit7 = (byte)(CPLOGPO0 & 0x80);
                                CPLOGPO0Bit10 = (byte)(throttle & 3);
                                if (CPLOGPO0Bit6 == 64) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "BMC set CPU1 Throttle");
                                }
                                if ((CPLOGPO0Bit7 & 0xFF) == 128) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "BMC set CPU2 Throttle");
                                }
                                switch (CPLOGPO0Bit10) {
                                    case 1: {
                                        isBladeThrottle = true;
                                        this.print("", "BMC Throttling", "PS_PMBUS_ALERT assert CPU Throttle");
                                        break;
                                    }
                                    case 2: {
                                        this.print("", "PWRFAIL_LED", "blinks and HDD fail");
                                    }
                                }
                                byte CPLOGPO1 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)1);
                                byte CPLOGPO1Bit5 = (byte)(CPLOGPO1 & 0x20);
                                if (this.isDebug) {
                                    System.out.println("CPLOGPO1 " + ByteUtility.byteToHex(CPLOGPO1));
                                    System.out.println("CPLOGPO1Bit5 " + ByteUtility.byteToHex(CPLOGPO1Bit5));
                                }
                                if (CPLOGPO1Bit5 == 0) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "BMC detect BBP throttle active");
                                }
                                if ((CPLOGPO2Bit6 = (byte)((CPLOGPO2 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)2)) & 0x40)) == 64) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 VR_HOT / PROC_HOT asserted");
                                }
                                if ((CPLOGPO2Bit7 = (byte)(CPLOGPO2 & 0x80)) == 128) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU2 VR_HOT / PROC_HOT asserted");
                                }
                                if ((CPLOGPO2Bit4 = (byte)(CPLOGPO2 & 0x10)) == 16) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 Thermal Trip asserted");
                                }
                                if ((CPLOGPO2Bit5 = (byte)(CPLOGPO2 & 0x20)) == 32) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU2 Thermal Trip asserted");
                                }
                                if ((CPLOGPO2Bit2 = (byte)(CPLOGPO2 & 4)) == 4) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 MEM_EVENT asserted");
                                }
                                if ((CPLOGPO2Bit3 = (byte)(CPLOGPO2 & 8)) == 8) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU2 MEM_EVENT asserted");
                                }
                                if ((CPLOGPO2Bit0 = (byte)(CPLOGPO2 & 1)) == 1) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 VR_PIN_ALT asserted");
                                }
                                if ((CPLOGPO2Bit1 = (byte)(CPLOGPO2 & 2)) == 2) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU2 VR_PIN_ALT asserted");
                                }
                            } else if (BMCRegID == 66) {
                                byte CPLOGPO2Bit1;
                                byte CPLOGPO2Bit0;
                                byte CPLOGPO2Bit3;
                                byte CPLOGPO2Bit2;
                                byte CPLOGPO2Bit5;
                                byte CPLOGPO2Bit4;
                                byte CPLOGPO2Bit7;
                                byte CPLOGPO0 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)0);
                                CPLOGPO0Bit6 = (byte)(CPLOGPO0 & 0x40);
                                if (CPLOGPO0Bit6 == 64) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "BMC set CPU1 Throttle");
                                }
                                if ((CPLOGPO0Bit7 = (byte)(CPLOGPO0 & 0x80)) == 128) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "BMC set CPU2 Throttle");
                                }
                                if ((CPLOGPO0Bit10 = (byte)(CPLOGPO0 & 3)) == 1) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "PS_PMBUS_ALERT assert CPU Throttle");
                                } else if (CPLOGPO0Bit10 == 2) {
                                    isBladeThrottle = true;
                                    this.print("", "PWRFAIL_LED", "Blinks and HDD fail");
                                }
                                byte CPLOGPO2 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)2);
                                byte CPLOGPO2Bit6 = (byte)(CPLOGPO2 & 0x40);
                                if (CPLOGPO2Bit6 == 64) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 VR_HOT / PROC_HOT asserted");
                                }
                                if ((CPLOGPO2Bit7 = (byte)(CPLOGPO2 & 0x80)) == 128) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU2 VR_HOT / PROC_HOT asserted");
                                }
                                if ((CPLOGPO2Bit4 = (byte)(CPLOGPO2 & 0x10)) == 16) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 Thermal Trip asserted");
                                }
                                if ((CPLOGPO2Bit5 = (byte)(CPLOGPO2 & 0x20)) == 32) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU2 Thermal Trip asserted");
                                }
                                if ((CPLOGPO2Bit2 = (byte)(CPLOGPO2 & 4)) == 4) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 MEM_EVENT asserted");
                                }
                                if ((CPLOGPO2Bit3 = (byte)(CPLOGPO2 & 8)) == 8) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU2 MEM_EVENT asserted");
                                }
                                if ((CPLOGPO2Bit0 = (byte)(CPLOGPO2 & 1)) == 1) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 VR_PIN_ALT asserted");
                                }
                                if ((CPLOGPO2Bit1 = (byte)(CPLOGPO2 & 2)) == 2) {
                                    isBladeThrottle = true;
                                    this.print("", "BMC Throttling", "CPU1 VR_PIN_ALT asserted");
                                }
                            } else if (isBMCRegIDEmpty) {
                                this.print("", "Reading CPLD", "CMM fail to read RegID from " + bladeModeName);
                            } else {
                                this.print("", "Reading CPLD", bladeModeName + " cannot decode BMCRegID " + ByteUtility.byteToHex(BMCRegID));
                                byte CPLOGPO0 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)0);
                                this.print("", "Reading CPLD offset 00h", ByteUtility.byteToHex(CPLOGPO0));
                                byte CPLOGPO1 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)1);
                                this.print("", "Reading CPLD offset 01h", ByteUtility.byteToHex(CPLOGPO1));
                                byte CPLOGPO2 = ipmiCommand.getCPLDGPO(bladeLocation, node_index, (byte)2);
                                this.print("", "Reading CPLD offset 02h", ByteUtility.byteToHex(CPLOGPO2));
                            }
                        }
                        if (isBladeThrottle) {
                            isThrottle = true;
                        }
                        if (this.isDebug) {
                            System.out.println("isBladeThrottle " + isBladeThrottle);
                            System.out.println("throttleBit " + ByteUtility.byteToHex(throttleBit));
                            System.out.println("throttleLockBit " + ByteUtility.byteToHex(throttleLockBit));
                        }
                        if (!isBladeThrottle && throttleBit != 64 && throttleLockBit != 32) continue;
                        if (throttleBit == 64) {
                            isThrottle = true;
                            this.print("", "BMC Throttling", "CMM detect BMC throttling");
                        } else if (throttleLockBit == 32) {
                            this.print("", "BMC Power Status", "BMC can't power on cause power not enough");
                        }
                        this.print("", "BMC Version", bladeBMCVersion);
                        this.print("", "BIOS Version", bladeBIOSVersion);
                        this.print("", "CPLD Version", cpldVersion);
                        this.print("", "BMC Model", bladeModeName);
                        IPMIInterfaceConfig ipmiConfig = new IPMIInterfaceConfig();
                        ipmiConfig.setIp(nodeSensorInfo.getBMCIP());
                        ipmiConfig.setUserName(nodeSensorInfo.getDecryptedUsername());
                        ipmiConfig.setPassword(nodeSensorInfo.getDecryptedPassword());
                        IPMIInterface precheckInterface = null;
                        try {
                            precheckInterface = this.getIPMIInterface(ipmiConfig);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        IPMICMMDiagCommand ipmiBladeCommand = new IPMICMMDiagCommand(precheckInterface);
                        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(ipmiBladeCommand.getIPMIInterface());
                        FRUInfo fruInfo = null;
                        try {
                            fruInfo = ipmiFRUCommand.getFRUData();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        if (fruInfo == null) continue;
                        if (this.isDebug) {
                            System.out.println("diagBladeThrottle ");
                        }
                        this.getSerialFromFRU(fruInfo, new String[0]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IPMIException e) {
            e.printStackTrace();
        }
        this.list.add(4, String.format(formatTemplate, "", "Total Blade Number", availableBlade));
        return isThrottle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getSerialFromFRU(FRUInfo fruInfo, String ... keys) {
        BufferedReader bufReader = new BufferedReader(new StringReader(fruInfo.toReadableStringForFRU1()));
        String line = null;
        String productSerial = "";
        String boardSerial = "";
        try {
            while ((line = bufReader.readLine()) != null) {
                if (line.indexOf("(PS)") > -1 && line.split("=").length > 1) {
                    productSerial = line.split("=")[1].trim();
                }
                if (line.indexOf("(BS)") <= -1 || line.split("=").length <= 1) continue;
                boardSerial = line.split("=")[1].trim();
            }
            if (!"".equals(productSerial)) {
                this.print("", "Blade Product Serial", productSerial);
            }
            if (!"".equals(boardSerial)) {
                this.print("", "Blade Board Serial", boardSerial);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    int getTotalPowerComsumption(IPMICMMDiagCommand ipmiCommand) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(ipmiCommand.getIPMIInterface());
        int sum = 0;
        int pc = 0;
        try {
            for (int i = 0; i < 8; ++i) {
                PowerSupplyInfo powerSupplyInfo = ipmiMicroBladeOEMCommand.getPowerSupply((byte)i, (byte)1);
                pc = 0;
                if (powerSupplyInfo.isPresent()) {
                    pc = powerSupplyInfo.getCurPowerConsumption();
                    if (this.isDebug) {
                        System.out.println(pc);
                    }
                }
                sum += pc;
            }
        }
        catch (IPMIException e) {
            e.printStackTrace();
        }
        return sum;
    }

    String getCMMFW(IPMICMMDiagCommand ipmiCommand, IPMIInterfaceConfig config) {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(ipmiCommand.getIPMIInterface());
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(config.getIp());
        String cmmFWVer = "";
        if (deviceInfo != null) {
            cmmFWVer = IPMIMessagingCommand.isAMIX9GUID(guid) || deviceInfo.usingAuxiliaryFWVesion ? deviceInfo.showFirmwareRevisionWith3rdVersionNumber() : deviceInfo.showFirmwareRevision();
        }
        return cmmFWVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cmmSensorReading(IPMICMMDiagCommand ipmiCommand, String status, ArrayList<String> sdrRecordList, IPMIInterfaceConfig config) {
        this.print("Enclosure LED", "Status", status);
        String cmmFWVer = this.getCMMFW(ipmiCommand, config);
        this.print("", "CMM Firmware Revision", cmmFWVer);
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(ipmiCommand.getIPMIInterface());
        FRUInfo fruInfo = null;
        try {
            fruInfo = ipmiFRUCommand.getFRUData((byte)1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (fruInfo == null) {
            this.print("", "CMM Model Name", "");
        } else {
            BufferedReader bufReader = new BufferedReader(new StringReader(fruInfo.toReadableStringForFRU1()));
            String line = null;
            String productModel = "";
            String productVersion = "";
            try {
                while ((line = bufReader.readLine()) != null) {
                    if (line.indexOf("(PPM)") > -1 && line.split("=").length > 1) {
                        productModel = line.split("=")[1].trim();
                    }
                    if (line.indexOf("(PV)") <= -1 || line.split("=").length <= 1) continue;
                    productVersion = line.split("=")[1].trim();
                }
                this.print("", "CMM Model Name", productModel + " v" + productVersion);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    bufReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.checkFailSensor(sdrRecordList, ipmiCommand);
    }

    void checkFailSensor(ArrayList<String> sdrRecordList, IPMICMMDiagCommand ipmiCommand) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(ipmiCommand.getIPMIInterface());
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(ipmiCommand.getIPMIInterface());
        for (String sdr : sdrRecordList) {
            String status;
            String[] strs;
            if (sdr.indexOf("FAN") > -1 && (sdr.indexOf("Fail") > -1 || sdr.indexOf("N/A") > -1)) {
                strs = sdr.split("\\|");
                String modelName = strs[1].substring(strs[1].indexOf(")") + 1).trim();
                int second = StringUtils.ordinalIndexOf(sdr, "|", 2);
                status = sdr.substring(second + 1);
                status = status.substring(1, status.lastIndexOf("|")).trim();
                this.print(modelName, "Status", status);
            }
            if (this.validateSwitch(sdr)) {
                strs = sdr.split("\\|");
                String switchIndex = strs[1].substring(strs[1].indexOf(")") + 1).trim();
                String swh = "Swh";
                switchIndex = switchIndex.substring(switchIndex.indexOf(swh) + swh.length(), switchIndex.indexOf("Status"));
                status = strs[2].trim();
                switch (Integer.parseInt(status)) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    default: {
                        this.getSwitchInfo(ipmiFRUCommand, ipmiMicroBladeOEMCommand, switchIndex);
                    }
                }
            }
            if (!this.validatePSU(sdr) || sdr.indexOf("Fail") <= -1) continue;
            strs = sdr.split("\\|");
            String psuIndex = strs[1].substring(strs[1].indexOf(")") + 1).trim();
            String psu = "PSU";
            psuIndex = psuIndex.substring(psuIndex.indexOf(psu) + psu.length(), psuIndex.indexOf("Status"));
            status = strs[2].trim();
            this.getPSUInfo(ipmiFRUCommand, ipmiMicroBladeOEMCommand, psuIndex);
            this.print("", "Status", status);
        }
    }

    void getPSUInfo(IPMIFRUCommand ipmiFRUCommand, IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand, String psuIndex) {
        String modelName;
        block21: {
            byte pIndex = (byte)PowerSupplyInfo.getIndex(psuIndex);
            modelName = "";
            try {
                PowerSupplyInfo powerSupplyInfo = ipmiMicroBladeOEMCommand.getPowerSupply(pIndex, (byte)1);
                if (powerSupplyInfo.isPresent()) {
                    BufferedReader bufReader = new BufferedReader(new StringReader(powerSupplyInfo.toFormatedString()));
                    String line = null;
                    String FWVersion = "";
                    String acInputVoltage = "N/A";
                    String maxWatt = "N/A";
                    String acInputCurrent = "N/A";
                    String dcOutputCurrent = "N/A";
                    String currentPowerUsage = "N/A";
                    try {
                        while ((line = bufReader.readLine()) != null) {
                            if (line.indexOf("FW Version") > -1 && line.split("\\|").length > 1) {
                                FWVersion = line.split("\\|")[1].trim();
                            }
                            if (line.indexOf("Model Name") > -1 && line.split("\\|").length > 1) {
                                modelName = line.split("\\|")[1].trim();
                            }
                            if (line.indexOf("AC Input Voltage") > -1 && line.split("\\|").length > 1) {
                                acInputVoltage = line.split("\\|")[1].trim();
                            }
                            if (line.indexOf("Max Watt") > -1 && line.split("\\|").length > 1) {
                                maxWatt = line.split("\\|")[1].trim();
                            }
                            if (line.indexOf("AC Input Current") > -1 && line.split("\\|").length > 1) {
                                acInputCurrent = line.split("\\|")[1].trim();
                            }
                            if (line.indexOf("DC Output Current") > -1 && line.split("\\|").length > 1) {
                                dcOutputCurrent = line.split("\\|")[1].trim();
                            }
                            if (line.indexOf("Current Power Usage") <= -1 || line.split("\\|").length <= 1) continue;
                            currentPowerUsage = line.split("\\|")[1].trim();
                        }
                        if (!"".equals(modelName) && !this.isPSUModleNameContainDF(modelName)) {
                            this.print("Power Supply " + psuIndex, "Power Supply Firmware Revision", FWVersion);
                            this.print("", "AC Input Voltage", acInputVoltage);
                            this.print("", "Max Watt", maxWatt);
                            this.print("", "AC Input Current", acInputCurrent);
                            this.print("", "DC Output Current", dcOutputCurrent);
                            this.print("", "Current Power Usage", currentPowerUsage);
                        }
                        bufReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block21;
                }
                MOut.G().println("Power Supply " + psuIndex + " is not presented");
                return;
            }
            catch (IPMIException e) {
                e.printStackTrace();
            }
        }
        int pusType = this.psuType(psuIndex);
        FRUInfo fruInfo = ipmiFRUCommand.getFRUData((byte)pusType);
        if (fruInfo == null) {
            MOut.G().println("FRU" + pusType + " is empty");
        } else {
            BufferedReader bufReader = new BufferedReader(new StringReader(fruInfo.toReadableStringForFRU1()));
            String line = null;
            String productModel = "";
            String productVersion = "";
            try {
                while ((line = bufReader.readLine()) != null) {
                    if (line.indexOf("(PPM)") > -1 && line.split("=").length > 1) {
                        productModel = line.split("=")[1].trim();
                    }
                    if (line.indexOf("(PV)") <= -1 || line.split("=").length <= 1) continue;
                    productVersion = line.split("=")[1].trim();
                }
                bufReader.close();
                if ("".equals(productModel)) {
                    this.print("", "Product Model Name", modelName);
                } else {
                    this.print("", "Product Model Name", productModel + " v" + productVersion);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getSwitchInfo(IPMIFRUCommand ipmiFRUCommand, IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand, String switchIndex) {
        block32: {
            byte sIndex = (byte)SwitchInfo.getIndex(switchIndex);
            try {
                SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch(sIndex, (byte)1);
                if (switchInfo.isPresent()) {
                    BufferedReader bufReader = new BufferedReader(new StringReader(switchInfo.toFormatedString()));
                    String line = null;
                    String FWVersion = "";
                    try {
                        while ((line = bufReader.readLine()) != null) {
                            if (line.indexOf("FW version") <= -1 || line.split("\\|").length <= 1) continue;
                            FWVersion = line.split("\\|")[1].trim();
                        }
                        this.print("Switch " + switchIndex, "Switch Firmware Revision", FWVersion);
                        break block32;
                    }
                    catch (IOException iOException) {
                        break block32;
                    }
                    finally {
                        try {
                            bufReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                MOut.G().println("Switch " + switchIndex + " is not presented");
                return;
            }
            catch (IPMIException e1) {
                e1.printStackTrace();
            }
        }
        int switchType = this.switchType(switchIndex);
        FRUInfo fruInfo = null;
        try {
            fruInfo = ipmiFRUCommand.getFRUData((byte)switchType);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (fruInfo == null) {
            MOut.G().println("FRU" + switchType + " is empty");
        } else {
            BufferedReader bufReader = new BufferedReader(new StringReader(fruInfo.toReadableStringForFRU1()));
            String line = null;
            String productModel = "";
            String productVersion = "";
            try {
                while ((line = bufReader.readLine()) != null) {
                    if (line.indexOf("(PPM)") > -1 && line.split("=").length > 1) {
                        productModel = line.split("=")[1].trim();
                    }
                    if (line.indexOf("(PV)") <= -1 || line.split("=").length <= 1) continue;
                    productVersion = line.split("=")[1].trim();
                }
                this.print("", "Switch Model Name", productModel + " " + productVersion);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    bufReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    boolean validateSwitch(String sdr) {
        sdr = sdr.replace("\n", "").replace("\r", "");
        String swhREGEX = ".*Swh[A-Z][0-9]Status.*";
        Pattern swhPattern = Pattern.compile(swhREGEX);
        return swhPattern.matcher(sdr).matches();
    }

    boolean validatePSU(String sdr) {
        sdr = sdr.replace("\n", "").replace("\r", "");
        String swhREGEX = ".*PSU[A-Z][0-9]Status.*";
        Pattern swhPattern = Pattern.compile(swhREGEX);
        return swhPattern.matcher(sdr).matches();
    }

    boolean isPSUModleNameContainDF(String sdr) {
        sdr = sdr.replace("\n", "").replace("\r", "");
        String swhREGEX = ".*DF.*";
        Pattern swhPattern = Pattern.compile(swhREGEX);
        return swhPattern.matcher(sdr).matches();
    }

    int psuType(String psuName) {
        int type = 0;
        switch (psuName) {
            case "A1": {
                type = 7;
                break;
            }
            case "A2": {
                type = 8;
                break;
            }
            case "A3": {
                type = 9;
                break;
            }
            case "A4": {
                type = 10;
                break;
            }
            case "B1": {
                type = 11;
                break;
            }
            case "B2": {
                type = 12;
                break;
            }
            case "B3": {
                type = 13;
                break;
            }
            case "B4": {
                type = 14;
            }
        }
        return type;
    }

    int switchType(String switchName) {
        int type = 0;
        switch (switchName) {
            case "A1": {
                type = 3;
                break;
            }
            case "A2": {
                type = 4;
                break;
            }
            case "B1": {
                type = 5;
                break;
            }
            case "B2": {
                type = 6;
            }
        }
        return type;
    }

    void print(String location, String status, String description) {
        if (!this.isHeaderShown) {
            this.printHeader("-----------------", " -------------------------------------------------------------------- ", "");
            this.printHeader("    Location     ", "                            Failure Reason                            ", "");
            this.printHeader("-----------------", " -------------------------------------------------------------------- ", "");
            this.isHeaderShown = true;
        }
        this.list.add(String.format(formatTemplate, location, status, description));
        if (this.isShowLog) {
            MOut.G().print(String.format(formatTemplate, location, status, description));
        }
    }

    void printHeader(String location, String status, String description) {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
        }
        this.list.add(String.format(formatTemplate, location, status, description));
        if (this.isShowLog) {
            MOut.G().print(String.format(formatHeaderTemplate, location, status, description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToFile(String fileName) {
        File file = new File(fileName);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            String listString = this.list.stream().map(Object::toString).collect(Collectors.joining(""));
            writer.write(listString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        MOut.G().println("Analysis Result filepath: " + fileName);
    }

    public IPMIInterface getIPMIInterface(IPMIInterfaceConfig config) throws Exception {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiGlobalCommand);
        if (ipmiGlobalCommand.getIPMIInterface() != null) {
            return ipmiGlobalCommand.getIPMIInterface();
        }
        return null;
    }
}

