/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;

public class GB
extends AbstractModuleInfo {
    public static final int GB_LENGTH = 16;
    public byte pVCC;
    public byte pVCore;
    public byte pwrGD;
    public byte boardTemp;
    public int swFabricTemp;
    public int boardFrontTemp;
    public int boardBackTemp;
    public byte[] unused;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.pVCC = raw[index++];
        this.pVCore = raw[index++];
        this.pwrGD = raw[index++];
        this.boardTemp = raw[index++];
        byte[] temp = new byte[2];
        System.arraycopy(raw, index, temp, 0, 2);
        this.swFabricTemp = ByteUtility.twoBytesToIntLSB(temp);
        System.arraycopy(raw, index += 2, temp, 0, 2);
        this.boardFrontTemp = ByteUtility.twoBytesToIntLSB(temp);
        System.arraycopy(raw, index += 2, temp, 0, 2);
        this.boardBackTemp = ByteUtility.twoBytesToIntLSB(temp);
        this.unused = ByteUtility.getBytes(raw, index += 2, 3);
        index += 3;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npVCC =" + this.pVCC);
        sb.append("\npVCore =" + this.pVCore);
        sb.append("\npwrGD =" + this.pwrGD);
        sb.append("\nboardTemp =" + this.boardTemp);
        sb.append("\nunused =" + ByteUtility.bytesToHex(this.unused));
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }
}

