/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.junit;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SelfTestResultInfo;
import com.supermicro.ipmi.junit.TestSuiteForIPMI;
import junit.framework.TestCase;

public class TestIPMIGlobalCommand
extends TestCase {
    ISessionController sessionController;
    private IPMIGlobalCommand ipmiGlobalCommand = null;

    public TestIPMIGlobalCommand(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.sessionController = TestSuiteForIPMI.getSessionController();
        IPMINetworkInterface ipmiInterface = this.sessionController.startup(TestSuiteForIPMI.getIPMIInterfaceConfig());
        this.ipmiGlobalCommand = new IPMIGlobalCommand(ipmiInterface);
    }

    protected void tearDown() throws Exception {
        this.sessionController.closeSession();
    }

    public void testGetDevice() {
        DeviceInfo deviceInfo = this.ipmiGlobalCommand.getDevice();
        TestIPMIGlobalCommand.assertNotNull((Object)deviceInfo);
        System.out.println(deviceInfo.toString());
    }

    public void testGetSelfTestResult() {
        SelfTestResultInfo selfTestResultInfo = this.ipmiGlobalCommand.getSelfTestResult();
        TestIPMIGlobalCommand.assertNotNull((Object)selfTestResultInfo);
        System.out.println("Self tset result =" + selfTestResultInfo.getResultInfo());
        System.out.println("Self tset result desc =" + selfTestResultInfo.getDescriptionInfo());
    }

    public void testGetACPI() {
        ACPIInfo acpiInfo = this.ipmiGlobalCommand.getACPI();
        TestIPMIGlobalCommand.assertNotNull((Object)acpiInfo);
        System.out.println("System state info = " + acpiInfo.getSystemStateInfo());
        System.out.println("System state desc = " + acpiInfo.getSystemStateDescription());
        System.out.println("Device state info = " + acpiInfo.getDeviceStateInfo());
        System.out.println("Device state desc = " + acpiInfo.getDeviceStateDescription());
    }

    public void testColdReset() {
        boolean result = this.ipmiGlobalCommand.coldReset();
        System.out.println("cold reset = " + result);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

