/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.cmtest;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SOLSessionController;
import com.supermicro.ipmi.cmtest.CMServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;

class IPMI
implements CMServer.Service {
    IPMI() {
    }

    @Override
    public void serve(InputStream i, OutputStream o) throws IOException {
        boolean result = false;
        BufferedReader in = new BufferedReader(new InputStreamReader(i));
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(o)));
        String str = in.readLine();
        StringTokenizer st = new StringTokenizer(str, ",");
        String ip = null;
        String commandStr = null;
        try {
            ip = st.nextToken();
            commandStr = st.nextToken();
        }
        catch (Exception ex) {
            System.out.println("Parameter error");
            out.print("1");
            out.close();
            in.close();
            return;
        }
        int command = Integer.parseInt(commandStr);
        System.out.print("IP = " + ip + " command = " + commandStr);
        switch (command) {
            case 1: {
                result = this.testLogin(ip);
                break;
            }
            case 2: {
                result = this.testSOL(ip);
                break;
            }
        }
        System.out.println(", result = " + (result ? "0" : "1"));
        out.print(result ? "0" : "1");
        out.close();
        in.close();
    }

    public boolean testLogin(String ip) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(0);
        config.setTimeout(10);
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface rmcp = null;
        try {
            rmcp = sessionController.startup(config);
        }
        catch (Exception ex) {
            return false;
        }
        if (rmcp != null) {
            boolean result = sessionController.closeSession();
            return result;
        }
        return false;
    }

    public boolean testSOL(String ip) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(0);
        config.setTimeout(10);
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setCipherSuiteID((byte)1);
        config.setPrivilege((byte)4);
        SOLSessionController solSessionController = new SOLSessionController();
        IPMINetworkInterface ipmiInterface = solSessionController.startup(config);
        if (!solSessionController.isSOLActivated) {
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[] keys = new byte[]{83, 79, 76, 13};
        solSessionController.dropKey(keys);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean result = solSessionController.closeSession();
        return result;
    }
}

