/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.cmtest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class GenericClient {
    public static void main(String[] args) throws IOException {
        try {
            String line;
            if (args.length < 2) {
                throw new IllegalArgumentException("Wrong number of args");
            }
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            Socket s = new Socket(host, port);
            final InputStreamReader from_server = new InputStreamReader(s.getInputStream());
            PrintWriter to_server = new PrintWriter(s.getOutputStream());
            BufferedReader from_user = new BufferedReader(new InputStreamReader(System.in));
            final PrintWriter to_user = new PrintWriter(System.out, true);
            to_user.println("Connected to " + s.getInetAddress() + ":" + s.getPort());
            Thread t = new Thread(){

                @Override
                public void run() {
                    char[] buffer = new char[1024];
                    try {
                        int chars_read;
                        while ((chars_read = from_server.read(buffer)) != -1) {
                            to_user.write(buffer, 0, chars_read);
                            to_user.flush();
                        }
                    }
                    catch (IOException e) {
                        to_user.println(e);
                    }
                    System.exit(0);
                }
            };
            t.start();
            while ((line = from_user.readLine()) != null) {
                to_server.print(line + "\r\n");
                to_server.flush();
            }
            s.close();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Usage: java GenericClient <hostname> <port>");
        }
    }
}

