/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B10DRI_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_B10DRG_SensorEntity
extends MB_B10DRI_SensorEntity {
    public static final String GPU1 = "GPU1 Temp";
    public static final String GPU2 = "GPU2 Temp";
    public static final int IBF = 0;
    public static final int TP = 1;
    protected byte gpu1Temp;
    protected byte gpu2Temp;
    protected byte gpu1TempLimit;
    protected byte gpu2TempLimit;
    String IBtempName;

    public MB_B10DRG_SensorEntity(int IBType) {
        switch (IBType) {
            case 0: {
                this.IBtempName = "IB Temp";
                break;
            }
            case 1: {
                this.IBtempName = "10G Temp";
                break;
            }
            default: {
                this.IBtempName = "IB Temp";
            }
        }
    }

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.vccp0 = raw[2];
        this.vccp1 = raw[3];
        this.vDIMMABVoltage = raw[4];
        this.vDIMMCDVoltage = raw[5];
        this.vDIMMEFVoltage = raw[6];
        this.vDIMMGHVoltage = raw[7];
        this.p1v05 = raw[8];
        this.p1v5 = raw[9];
        this.p1v2 = raw[10];
        this.p3v3 = raw[11];
        this.p3v3sb = raw[12];
        this.p5v = raw[13];
        this.p5vsb = raw[14];
        this.p12v = raw[15];
        this.batteryVoltage = raw[16];
        this.remoteCPU1Temp = raw[17];
        this.remoteCPU2Temp = raw[18];
        this.systemTemp = raw[19];
        this.system2Temp = raw[20];
        this.pchTemp = raw[21];
        this.ibTemp = raw[23];
        this.cpu1vrmT = raw[24];
        this.cpu2vrmT = raw[25];
        this.dimABTemp = raw[26];
        this.dimCDTemp = raw[30];
        this.dimEFTemp = raw[31];
        this.dimGHTemp = raw[32];
        this.dimmA1Temp = raw[33];
        this.dimmB1Temp = raw[34];
        this.dimmC1Temp = raw[35];
        this.dimmD1Temp = raw[36];
        this.dimmE1Temp = raw[37];
        this.dimmF1Temp = raw[38];
        this.dimmG1Temp = raw[39];
        this.dimmH1Temp = raw[40];
        this.gpu1Temp = raw[41];
        this.gpu2Temp = raw[42];
        this.cpu1TempLimit = raw[43];
        this.cpu2TempLimit = raw[44];
        this.gpu1TempLimit = raw[45];
        this.gpu2TempLimit = raw[46];
        byte[] powerconsumption = new byte[2];
        System.arraycopy(raw, 47, powerconsumption, 0, 2);
        this.pwr = ByteUtility.twoBytesToInt(powerconsumption);
        this.systemHealth = raw[49];
        this.hdd0Status = raw[50];
        this.hdd1Status = raw[51];
        this.hdd2Status = raw[52];
        this.hdd3Status = raw[53];
        this.watchdog = raw[54];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Temp"));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Temp"));
        }
        if (this.checkGPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, GPU1));
        }
        if (this.checkGPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, GPU2));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "System"));
        }
        if (this.checkSystemTemp2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "Peripheral"));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VCPU1"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VCPU2"));
        }
        if (this.checkVDIMMABVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VDIMMAB"));
        }
        if (this.checkVDIMMCDVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VDIMMCD"));
        }
        if (this.checkVDIMMEFVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VDIMMEF"));
        }
        if (this.checkVDIMMGHVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VDIMMGH"));
        }
        if (this.checkp1v05() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "1.05V PCH"));
        }
        if (this.checkp1v5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "1.5V PCH"));
        }
        if (this.checkp1v2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "1.2V BMC"));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3VCC"));
        }
        if (this.checkV3p3sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3VSB"));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5VCC"));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5VSB"));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "12V"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        if (this.checkPCHTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "PCH"));
        }
        if (this.checkIBTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, this.IBtempName));
        }
        if (this.checkCPU1VRMTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 VRM"));
        }
        if (this.checkCPU2VRMTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 VRM"));
        }
        if (this.checkDIMMXXTemp(this.dimABTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMMAB VRM"));
        }
        if (this.checkDIMMXXTemp(this.dimCDTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMMCD VRM"));
        }
        if (this.checkDIMMXXTemp(this.dimEFTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMMEF VRM"));
        }
        if (this.checkDIMMXXTemp(this.dimGHTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMMGH VRM"));
        }
        if (this.checkDIMMTemp(this.dimmA1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_A1"));
        }
        if (this.checkDIMMTemp(this.dimmB1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_B1"));
        }
        if (this.checkDIMMTemp(this.dimmC1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_C1"));
        }
        if (this.checkDIMMTemp(this.dimmD1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_D1"));
        }
        if (this.checkDIMMTemp(this.dimmE1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_E1"));
        }
        if (this.checkDIMMTemp(this.dimmF1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_F1"));
        }
        if (this.checkDIMMTemp(this.dimmG1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_G1"));
        }
        if (this.checkDIMMTemp(this.dimmH1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "DIMM_H1"));
        }
        if (this.checkPower() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "Power Consumption"));
        }
        return failures;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.cpu1TempLimit));
        this.addRaw(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.cpu2TempLimit));
        this.addRaw(this.checkGPU1Temp(), GPU1, this.showCandF(this.getGpu1Temp()), "N/A", "" + this.showCandF(this.gpu1TempLimit));
        this.addRaw(this.checkGPU2Temp(), GPU2, this.showCandF(this.getGpu2Temp()), "N/A", "" + this.showCandF(this.gpu2TempLimit));
        this.addRaw(this.checkSystemTemp(), "System", this.showCandF(this.systemTemp), "N/A", "" + this.showCandF(this.getSystemHighTempLimit()));
        this.addRaw(this.checkSystemTemp2(), "Peripheral", this.showCandF(this.system2Temp), "N/A", "" + this.showCandF(this.getSystemHighTempLimit()));
        this.addRaw(this.checkCPU1VRMTemp(), "CPU1 VRM", this.showCandF(this.cpu1vrmT), "N/A", "" + this.showCandF(this.getCPUVRMTempHighLimit()));
        this.addRaw(this.checkCPU2VRMTemp(), "CPU2 VRM", this.showCandF(this.cpu2vrmT), "N/A", "" + this.showCandF(this.getCPUVRMTempHighLimit()));
        this.addRaw(this.checkDIMMXXTemp(this.dimABTemp), "DIMMAB VRM", this.showCandF(this.dimABTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkDIMMXXTemp(this.dimCDTemp), "DIMMCD VRM", this.showCandF(this.dimCDTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkDIMMXXTemp(this.dimEFTemp), "DIMMEF VRM", this.showCandF(this.dimEFTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkDIMMXXTemp(this.dimGHTemp), "DIMMGH VRM", this.showCandF(this.dimGHTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkPCHTemp(), "PCH", this.showCandF(this.pchTemp), "N/A", "" + this.showCandF(this.getControllerHighTempLimit()));
        this.addRaw(this.checkIBTemp(), this.IBtempName, this.showCandF(this.ibTemp), "N/A", "" + this.showCandF(this.getControllerHighTempLimit()));
        this.addRaw(this.checkDIMMTemp(this.dimmA1Temp), "DIMM_A1", this.showCandF(this.dimmA1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmB1Temp), "DIMM_B1", this.showCandF(this.dimmB1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmC1Temp), "DIMM_C1", this.showCandF(this.dimmC1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmD1Temp), "DIMM_D1", this.showCandF(this.dimmD1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmE1Temp), "DIMM_E1", this.showCandF(this.dimmE1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmF1Temp), "DIMM_F1", this.showCandF(this.dimmF1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmG1Temp), "DIMM_G1", this.showCandF(this.dimmG1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmH1Temp), "DIMM_H1", this.showCandF(this.dimmH1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkCpu1CoreVoltage(), "VCPU1", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getVccpLowLimit()), this.d2StrV(this.getVccpHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "VCPU2", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getVccpLowLimit()), this.d2StrV(this.getVccpHighLimit()));
        this.addRaw(this.checkVDIMMABVoltage(), "VDIMMAB", this.d2StrV(this.getVDIMMABVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkVDIMMCDVoltage(), "VDIMMCD", this.d2StrV(this.getVDIMMCDVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkVDIMMEFVoltage(), "VDIMMEF", this.d2StrV(this.getVDIMMEFVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkVDIMMEFVoltage(), "VDIMMGH", this.d2StrV(this.getVDIMMGHVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkp1v05(), "1.05V PCH", this.d2StrV(this.getP1V05Formula()), this.d2StrV(this.getP1V05LowLimit()), this.d2StrV(this.getP1V05HighLimit()));
        this.addRaw(this.checkp1v5(), "1.5V PCH", this.d2StrV(this.getP1V5Formula()), this.d2StrV(this.getP1V5LowLimit()), this.d2StrV(this.getP1V5HighLimit()));
        this.addRaw(this.checkp1v2(), "1.2V BMC", this.d2StrV(this.getP1V2Formula()), this.d2StrV(this.getP1V2LowLimit()), this.d2StrV(this.getP1V2HighLimit()));
        this.addRaw(this.checkV3p3(), "3.3VCC", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getP3V3LowLimit()), this.d2StrV(this.getP3V3HighLimit()));
        this.addRaw(this.checkV3p3sb(), "3.3VSB", this.d2StrV(this.getV3p3sbFormula()), this.d2StrV(this.getP3V3LowLimit()), this.d2StrV(this.getP3V3HighLimit()));
        this.addRaw(this.checkV5(), "5VCC", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV5sb(), "5VSB", this.d2StrV(this.getV5sbFormula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        this.addRaw(this.checkPower(), "Power Consumption", Integer.toString(this.pwr & 0xFF), "0", "" + this.getPowerHighLimit());
        this.addRaw(2, "Watchdog", this.getWatchDogStatus(), "N/A", "N/A");
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.cpu1TempLimit)));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.cpu2TempLimit)));
        list.add(this.createTemperatureData(this.checkGPU1Temp(), GPU1, this.showCandF(this.getGpu1Temp()), "N/A", "" + this.showCandF(this.gpu1TempLimit)));
        list.add(this.createTemperatureData(this.checkGPU2Temp(), GPU2, this.showCandF(this.getGpu2Temp()), "N/A", "" + this.showCandF(this.gpu2TempLimit)));
        list.add(this.createTemperatureData(this.checkSystemTemp(), "System", this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.staticSystemTempHighLimit)));
        list.add(this.createTemperatureData(this.checkSystemTemp2(), "Peripheral", this.showCandF(this.system2Temp), "N/A", "" + this.showCandF(this.staticSystemTempHighLimit)));
        list.add(this.createTemperatureData(this.checkPCHTemp(), "PCH", this.showCandF(this.pchTemp), "N/A", "" + this.showCandF(this.getControllerHighTempLimit())));
        list.add(this.createTemperatureData(this.checkIBTemp(), this.IBtempName, this.showCandF(this.ibTemp), "N/A", "" + this.showCandF(this.getControllerHighTempLimit())));
        list.add(this.createTemperatureData(this.checkLSITemp(), "LSI Temp", this.showCandF(this.lsiTemp), "N/A", "" + this.showCandF(this.getLSITempLimit())));
        list.add(this.createTemperatureData(this.checkCPU1VRMTemp(), "CPU1 VRM", this.showCandF(this.cpu1vrmT), "N/A", "" + this.showCandF(this.getCPUVRMTempHighLimit())));
        list.add(this.createTemperatureData(this.checkCPU2VRMTemp(), "CPU2 VRM", this.showCandF(this.cpu2vrmT), "N/A", "" + this.showCandF(this.getCPUVRMTempHighLimit())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimABTemp), "DIMMAB VRM", this.showCandF(this.dimABTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimCDTemp), "DIMMCD VRM", this.showCandF(this.dimCDTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimEFTemp), "DIMMEF VRM", this.showCandF(this.dimEFTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimGHTemp), "DIMMGH VRM", this.showCandF(this.dimGHTemp), "N/A", "" + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmA1Temp), "DIMM_A1", this.showCandF(this.dimmA1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmB1Temp), "DIMM_B1", this.showCandF(this.dimmB1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmC1Temp), "DIMM_C1", this.showCandF(this.dimmC1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmD1Temp), "DIMM_D1", this.showCandF(this.dimmD1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmE1Temp), "DIMM_E1", this.showCandF(this.dimmE1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmF1Temp), "DIMM_F1", this.showCandF(this.dimmF1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmG1Temp), "DIMM_G1", this.showCandF(this.dimmG1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmH1Temp), "DIMM_H1", this.showCandF(this.dimmH1Temp), "N/A", "" + this.showCandF((byte)85)));
        return list;
    }

    public byte getGpu1Temp() {
        return this.gpu1Temp;
    }

    public byte getGpu2Temp() {
        return this.gpu2Temp;
    }

    public byte getGpu1TempLimit() {
        return this.gpu1TempLimit;
    }

    public byte getGpu2TempLimit() {
        return this.gpu2TempLimit;
    }

    public int checkGPU1Temp() {
        if (this.getGpu1Temp() == -127) {
            return 2;
        }
        if (this.gpu1TempLimit == 0) {
            return 2;
        }
        if (this.getGpu1Temp() < this.gpu1TempLimit) {
            return 0;
        }
        return 1;
    }

    public int checkGPU2Temp() {
        if (this.getGpu2Temp() == -127) {
            return 2;
        }
        if (this.gpu2TempLimit == 0) {
            return 2;
        }
        if (this.getGpu2Temp() < this.gpu2TempLimit) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkPower() {
        if (this.pwr == 0) {
            return 2;
        }
        if ((double)this.pwr < this.getPowerHighLimit()) {
            return 0;
        }
        return 1;
    }

    public String getIBtempName() {
        return this.IBtempName;
    }
}

