/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.activation;

import com.supermicro.ipmi.ByteUtility;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class VerifySignature {
    private static String publicKey = "-----BEGIN PUBLIC KEY-----\nMIIBIDANBgkqhkiG9w0BAQEFAAOCAQ0AMIIBCAKCAQEAvDb4MxWw/FTi8pscP6S2\nYAl/3gmVOj/StG0lu3PdCSmdpzmzbOU9KBS3t0yPZ0ynUQj/qXOwaVLvBJ+uCE0p\nGIRWkzBersVUzmXXN8Dza5yOzlLIdsVnamUrKcRHgC+otRE/gnCxIiioacy9TkA9\n6otbAvztCl1j1W8oCixazpfwZrayy12yCcOyquZr3prngLCgOWa9e9cLSekKuvYX\nPKPC0CogLz0ueg+y+gcWGHGwbMtERLGfWYDrXD1mdlV0EL4A5H4v9bqzn0yHe9dI\nb7+tdMHiN+qLjMzcVSzwfXu7Abk7rPOzwBY6gMvfhfaOTj8aU5JFQ3DEBdTPOwgt\nSwIBAw==\n-----END PUBLIC KEY-----\n";

    private static RSAPublicKey getRSAPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        String publicKeyContent = new String(publicKey);
        publicKeyContent = publicKeyContent.replaceAll("\\n", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyContent));
        return (RSAPublicKey)kf.generatePublic(keySpecX509);
    }

    public static boolean verify(String signature, String message) {
        byte[] signatureBytes = Base64.getDecoder().decode(signature);
        RSAPublicKey rsaPK = null;
        try {
            rsaPK = VerifySignature.getRSAPublicKey();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            // empty catch block
        }
        Signature sign = null;
        try {
            sign = Signature.getInstance("SHA256withRSA");
            sign.initVerify(rsaPK);
            sign.update(message.getBytes());
            return sign.verify(signatureBytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
        return false;
    }

    public static boolean verify(Type type, byte[] mac, String signature) {
        String message = "";
        switch (type) {
            case OOB: {
                message = String.valueOf(ByteUtility.bytesToHexNoSpace(mac)) + "+OOB";
                break;
            }
            case DCMS: {
                message = String.valueOf(ByteUtility.bytesToHexNoSpace(mac)) + "+DCMS";
                break;
            }
        }
        return VerifySignature.verify(signature, message);
    }

    public static enum Type {
        Others,
        OOB,
        DCMS;

    }
}

