/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.activation;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.activation.CSWProductKey;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;

public class SoftwareFRU {
    public byte[] mac;
    public byte[] raw;
    public byte[] result;

    private byte[] md5(String str) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(str.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Encoding MD5 is failed.");
        }
    }

    private byte[] AES128CBCDecoding(byte[] raw, String key, String iv) throws Exception {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivs = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)skeySpec, ivs);
            return cipher.doFinal(raw);
        }
        catch (Exception e) {
            throw new Exception("Decoding AES CBC 128 failed.");
        }
    }

    public SoftwareFRU(byte[] mac, byte[] raw) throws Exception {
        this.mac = mac;
        this.raw = raw;
        this.parse();
    }

    public void parse() throws Exception {
        if (this.mac.length == 0) {
            throw new Exception("MAC is emtpy.");
        }
        if (this.raw.length == 0) {
            throw new Exception("RawData is emtpy.");
        }
        byte[] pkHeader = Arrays.copyOfRange(this.raw, 0, 16);
        byte[] pkBody = Arrays.copyOfRange(this.raw, 16, this.raw.length);
        String ejmb = String.valueOf(ByteUtility.bytesToHexNoSpace(this.mac)) + "ejmb";
        byte[] ejmbMD5 = this.md5(ejmb);
        String iv = ByteUtility.bytesToHexNoSpace(Arrays.copyOfRange(ejmbMD5, 0, 8)).toLowerCase();
        String key = ByteUtility.bytesToHexNoSpace(Arrays.copyOfRange(ejmbMD5, 8, ejmbMD5.length)).toLowerCase();
        byte[] temp = this.AES128CBCDecoding(pkBody, key, iv);
        this.result = ArrayUtils.addAll(pkHeader, temp);
    }

    public CSWProductKey toCSWProductKey() throws Exception {
        return new CSWProductKey(this.result);
    }
}

