/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.activation;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.text.MOut;
import java.util.Arrays;
import java.util.stream.IntStream;

public class CSWProductKey {
    private int fruSize = 255;
    public byte formatVersion;
    public enSWID swID;
    public String swName;
    public String swVersion;
    public String invoiceNum;
    public byte[] creationDate;
    public byte[] expirationDate;
    public byte[] property;
    public byte[] secretData;
    public byte checksum;
    public int swFRULocation = -1;
    public int licenseID;
    public String signature;
    public String createDate;
    public String expireDate;
    public byte[] raw;
    public boolean bInvalid;
    public boolean bKeyBad;
    public boolean bExpire;

    public CSWProductKey(byte[] raw) throws Exception {
        this.raw = raw;
        this.parse();
    }

    public CSWProductKey() {
    }

    public byte swIDToByte() {
        switch (this.swID) {
            case enSWIDReserve: {
                return 0;
            }
            case enSWIDSSM: {
                return 1;
            }
            case enSWIDSD5: {
                return 2;
            }
            case enSWIDSUM: {
                return 3;
            }
            case enSWIDSPM: {
                return 4;
            }
            case enSWIDSCM: {
                return 5;
            }
            case enSWIDALL: {
                return 6;
            }
            case enSWIDSITE: {
                return 7;
            }
            case enSWIDCALLHOME: {
                return 8;
            }
            case enSWIDSVC: {
                return 9;
            }
            case enSWIDSMIS: {
                return -56;
            }
            case enSWIDSDDCSINGLE: {
                return -46;
            }
            case enSWIDSDDCTRIAL: {
                return -36;
            }
        }
        return -1;
    }

    public enSWID byteToSWID(byte swID) {
        switch (swID) {
            case 0: {
                return enSWID.enSWIDReserve;
            }
            case 1: {
                return enSWID.enSWIDSSM;
            }
            case 2: {
                return enSWID.enSWIDSD5;
            }
            case 3: {
                return enSWID.enSWIDSUM;
            }
            case 4: {
                return enSWID.enSWIDSPM;
            }
            case 5: {
                return enSWID.enSWIDSCM;
            }
            case 6: {
                return enSWID.enSWIDALL;
            }
            case 7: {
                return enSWID.enSWIDSITE;
            }
            case 8: {
                return enSWID.enSWIDCALLHOME;
            }
            case 9: {
                return enSWID.enSWIDSVC;
            }
            case -56: {
                return enSWID.enSWIDSMIS;
            }
            case -46: {
                return enSWID.enSWIDSDDCSINGLE;
            }
            case -36: {
                return enSWID.enSWIDSDDCTRIAL;
            }
        }
        return enSWID.enSWIDUnknwon;
    }

    public String swIDToString() {
        switch (this.swID) {
            case enSWIDReserve: {
                return "RESERVED";
            }
            case enSWIDSSM: {
                return "SSM";
            }
            case enSWIDSD5: {
                return "SD5";
            }
            case enSWIDSUM: {
                return "SUM";
            }
            case enSWIDSPM: {
                return "SFT-SPM-LIC";
            }
            case enSWIDSCM: {
                return "SCM";
            }
            case enSWIDALL: {
                return "SFT-DCMS-SINGLE";
            }
            case enSWIDSITE: {
                return "DCMS-SITE";
            }
            case enSWIDCALLHOME: {
                return "DCMS-CALL-HOME";
            }
            case enSWIDSVC: {
                return "SFT-DCMS-SVC-KEY";
            }
            case enSWIDSMIS: {
                return "SMIS";
            }
            case enSWIDSDDCSINGLE: {
                return "SFT-SDDC-SINGLE";
            }
            case enSWIDSDDCTRIAL: {
                return "SFT_SDDC-TRIAL";
            }
        }
        return "UNKNOWN";
    }

    public void parse() throws Exception {
        if (this.raw.length == 0) {
            throw new Exception("No node product keys exist.");
        }
        if (this.raw.length != this.fruSize) {
            throw new Exception("Maximum length of node product key exceeded.");
        }
        if (this.raw[0] != this.raw[16]) {
            throw new Exception("Format version does not match. (" + this.raw[0] + ":" + this.raw[16] + ")");
        }
        this.formatVersion = this.raw[0];
        if (this.raw[1] != this.raw[17]) {
            throw new Exception("SW ID does not match. (" + this.raw[1] + ":" + this.raw[17] + ")");
        }
        this.swID = this.byteToSWID(this.raw[1]);
        int i2 = 2;
        while (i2 <= 15) {
            if (this.raw[i2] != 0) {
                throw new Exception("Found invalid data in unencrypted block.");
            }
            ++i2;
        }
        int beg = 18;
        int end = -1;
        end = IntStream.range(beg, this.raw.length).filter(i -> this.raw[i] == 0).findFirst().orElse(-1);
        if (end < beg) {
            throw new Exception("Failed to parse SWName.");
        }
        this.swName = new String(Arrays.copyOfRange(this.raw, beg, end));
        beg = end + 1;
        end = IntStream.range(beg, this.raw.length).filter(i -> this.raw[i] == 0).findFirst().orElse(-1);
        if (end < beg) {
            throw new Exception("Failed to parse SWVersion.");
        }
        this.swVersion = new String(Arrays.copyOfRange(this.raw, beg, end));
        beg = end + 1;
        end = IntStream.range(beg, this.raw.length).filter(i -> this.raw[i] == 0).findFirst().orElse(-1);
        if (end < beg) {
            throw new Exception("Failed to parse InvoiceNum.");
        }
        this.invoiceNum = new String(Arrays.copyOfRange(this.raw, beg, end));
        beg = end + 1;
        this.creationDate = Arrays.copyOfRange(this.raw, beg, beg + 4);
        this.createDate = ByteUtility.fourBytesToLongByLSBFirst(this.creationDate) != 0L ? ByteUtility.fourByteToDateFormat2(this.creationDate) : "";
        this.expirationDate = Arrays.copyOfRange(this.raw, beg += 4, beg + 4);
        String string = this.expireDate = ByteUtility.fourBytesToLongByLSBFirst(this.expirationDate) != 0L ? ByteUtility.fourByteToDateFormat2(this.expirationDate) : "";
        if (this.raw[beg += 4] == 0) {
            ++beg;
        } else {
            this.property = Arrays.copyOfRange(this.raw, beg + 1, beg + this.raw[beg]);
            beg += this.raw[beg] + 1;
        }
        if (this.raw[beg] == 0) {
            ++beg;
        } else {
            this.secretData = Arrays.copyOfRange(this.raw, beg + 1, beg + this.raw[beg]);
            beg += this.raw[beg] + 1;
        }
        this.checksum = this.raw[beg];
        byte calculatedCheckSum = 0;
        int i3 = 0;
        while (i3 < beg) {
            calculatedCheckSum = (byte)(calculatedCheckSum + this.raw[i3]);
            ++i3;
        }
        if (calculatedCheckSum != this.checksum) {
            throw new Exception("Found Checksum mismatches.");
        }
        ++beg;
        while (beg < this.raw.length) {
            if (this.raw[beg] != 0) {
                throw new Exception("Padding data is incorrect.");
            }
            ++beg;
        }
    }

    public void printInfo() {
        if (this.swFRULocation != -1) {
            MOut.G().printf("%-18s : %d%s\n", "ID", this.swFRULocation, this.bExpire ? " (Key has expired)" : "");
        }
        MOut.G().printf("%-18s : %s (0x%s)\n", "Software Type", this.swIDToString(), ByteUtility.byteToHex(this.swIDToByte()));
        MOut.G().printf("%-18s : %s\n", "Software Name", this.swName);
        MOut.G().printf("%-18s : %s\n", "Software Version", this.swVersion);
        MOut.G().printf("%-18s : %s\n", "Creation Date", ByteUtility.fourBytesToLongByLSBFirst(this.creationDate) != 0L ? ByteUtility.fourByteToDateFormat2(this.creationDate) : "N/A");
        MOut.G().printf("%-18s : %s\n", "Expiration Date", ByteUtility.fourBytesToLongByLSBFirst(this.expirationDate) != 0L ? ByteUtility.fourByteToDateFormat2(this.expirationDate) : "N/A");
    }

    public String getSwName() {
        return this.swName;
    }

    public void setSwName(String swName) {
        this.swName = swName;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    public int getLicenseID() {
        return this.licenseID;
    }

    public void setLicenseID(int licenseID) {
        this.licenseID = licenseID;
    }

    public static enum enSWID {
        enSWIDReserve,
        enSWIDSSM,
        enSWIDSD5,
        enSWIDSUM,
        enSWIDSPM,
        enSWIDSCM,
        enSWIDALL,
        enSWIDSITE,
        enSWIDCALLHOME,
        enSWIDSVC,
        enSWIDSMIS,
        enSWIDSDDCSINGLE,
        enSWIDSDDCTRIAL,
        enSWIDUnknwon;

    }
}

