/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.MessageCenter;

public class MidplaneFRUCommand
extends IPMICommand {
    public MidplaneFRUCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void CMD____________() {
    }

    public IPMIMessage getMidFRUCommand(byte[] offset, byte length) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        data[0] = -112;
        data[1] = 4;
        System.arraycopy(offset, 0, data, 2, 2);
        data[4] = length;
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage writeMidFRUCommand(byte[] offset, byte[] value) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4 + value.length];
        data[0] = -112;
        data[1] = 5;
        System.arraycopy(offset, 0, data, 2, 2);
        System.arraycopy(value, 0, data, 4, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte[] getSystemInfoStructure() {
        byte[] offset = new byte[2];
        offset[1] = -128;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)92);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return null;
    }

    public byte getSystemSignatureCode() {
        byte[] offset = new byte[2];
        offset[1] = -128;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return (Byte)null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return (Byte)null;
    }

    public String getSystemModelNumber() {
        byte[] offset = new byte[2];
        offset[1] = -123;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)21);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return "";
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return "";
    }

    public String getSystemSerialNumber() {
        byte[] offset = new byte[2];
        offset[1] = -102;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)32);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return "";
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return "";
    }

    public byte getSGPIOMode() {
        byte[] offset = new byte[2];
        offset[1] = -70;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return (Byte)null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return (Byte)null;
    }

    public byte getZoneConfig() {
        byte[] offset = new byte[2];
        offset[1] = -69;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return (Byte)null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return (Byte)null;
    }

    public byte[] getReservedByte() {
        byte[] offset = new byte[2];
        offset[1] = -68;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)31);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return null;
    }

    public byte getSystemChecksum() {
        byte[] offset = new byte[2];
        offset[1] = -37;
        offset[0] = 0;
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return (Byte)null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return (Byte)null;
    }

    public boolean writeSystemInfo(byte[] input) {
        byte[] offset = new byte[2];
        offset[1] = -128;
        offset[0] = 0;
        IPMIMessage resMessage = this.writeMidFRUCommand(offset, input);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return false;
    }

    public FRUInfo getChassisFRU() {
        byte[] offset = new byte[2];
        offset[1] = 0;
        offset[0] = 1;
        byte[] raw = new byte[384];
        IPMIMessage resMessage = this.getMidFRUCommand(offset, (byte)-128);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                System.arraycopy(resMessage.data, 0, raw, 0, resMessage.data.length);
                offset[1] = -128;
                offset[0] = 1;
                IPMIMessage resMessage2 = this.getMidFRUCommand(offset, (byte)-128);
                System.arraycopy(resMessage2.data, 0, raw, 128, resMessage2.data.length);
                offset[1] = 0;
                offset[0] = 2;
                IPMIMessage resMessage3 = this.getMidFRUCommand(offset, (byte)-128);
                System.arraycopy(resMessage3.data, 0, raw, 256, resMessage3.data.length);
                FRUInfo fru = FRUInfo.fromRaw(raw);
                return fru;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return null;
    }

    public boolean cleanChassisInfo() {
        byte[] offset = new byte[2];
        offset[1] = 0;
        offset[0] = 1;
        int total = 384;
        for (int index = 0; index < total; index += 128) {
            IPMIMessage resMessage;
            byte temp;
            byte[] part;
            if (total - index > 128) {
                part = new byte[128];
                ByteUtility.intTo2Bytes(offset, 0, index + 256);
                temp = offset[1];
                offset[1] = offset[0];
                offset[0] = temp;
                resMessage = this.writeMidFRUCommand(offset, part);
                if (resMessage != null) {
                    if (resMessage.completionCode == 0) continue;
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                    return false;
                }
                return false;
            }
            part = new byte[total - index];
            ByteUtility.intTo2Bytes(offset, 0, index + 256);
            temp = offset[1];
            offset[1] = offset[0];
            offset[0] = temp;
            resMessage = this.writeMidFRUCommand(offset, part);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    return true;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                return false;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute command");
            return false;
        }
        return false;
    }

    public boolean writeChassisInfo(byte[] input) {
        byte[] offset = new byte[2];
        offset[1] = 0;
        offset[0] = 1;
        for (int index = 0; index < input.length; index += 128) {
            IPMIMessage resMessage;
            byte temp;
            byte[] part;
            if (input.length - index > 128) {
                part = new byte[128];
                System.arraycopy(input, index, part, 0, part.length);
                ByteUtility.intTo2Bytes(offset, 0, index + 256);
                temp = offset[1];
                offset[1] = offset[0];
                offset[0] = temp;
                resMessage = this.writeMidFRUCommand(offset, part);
                if (resMessage != null) {
                    if (resMessage.completionCode == 0) continue;
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                    return false;
                }
                return false;
            }
            part = new byte[input.length - index];
            System.arraycopy(input, index, part, 0, part.length);
            ByteUtility.intTo2Bytes(offset, 0, index + 256);
            temp = offset[1];
            offset[1] = offset[0];
            offset[0] = temp;
            resMessage = this.writeMidFRUCommand(offset, part);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    return true;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                return false;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute command");
            return false;
        }
        return false;
    }

    public boolean clearChassisInfo() {
        byte[] offset = new byte[2];
        offset[1] = 0;
        offset[0] = 1;
        byte[] data = new byte[8];
        data[0] = 1;
        data[7] = -1;
        IPMIMessage resMessage = this.writeMidFRUCommand(offset, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute command");
        return false;
    }
}

