/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.text.MOut;

public class MDRRegionLockCommand
extends IPMICommand {
    final byte intelRSDSpec = (byte)4;
    final byte lockSessionHandle = 0;
    final byte smbiosRegion = 1;
    final byte iSCSIRegion = (byte)4;
    final byte unlockComplete = 0;
    final byte strickLock = 1;
    final byte preemptibleLock = (byte)2;
    final int timeout = 10000;
    byte completionCode;
    byte sessionLockHandle;
    boolean isSessionLock = false;

    public MDRRegionLockCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public byte getSessionLock() {
        return this.sessionLockHandle;
    }

    public MDRRegionLockCommand getMDRRegionLock() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, 0, 4, 2, 16, 39};
        ipmiMessage.setCommandAndData((byte)-80, (byte)36, data);
        IPMIMessage resMessage = this.getIPMIInterface().send(ipmiMessage);
        MDRRegionLockCommand mdrRegionLock = new MDRRegionLockCommand(this.getIPMIInterface());
        if (resMessage != null) {
            mdrRegionLock.completionCode = resMessage.completionCode;
            switch (this.completionCode) {
                case -127: {
                    MOut.G().println("Region is in use or session handle is invalid (0x81)");
                    break;
                }
                case -55: {
                    MOut.G().println("Invalid Region Specified (0xC9)");
                    break;
                }
                case -43: {
                    MOut.G().println("Data region locked (0xD5)");
                    break;
                }
                case 0: {
                    try {
                        mdrRegionLock.sessionLockHandle = resMessage.data[1];
                        mdrRegionLock.isSessionLock = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return mdrRegionLock;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-20s | %14s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String format = " %-20s | %14s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Session Lock Handle", this.isSessionLock ? "0x" + ByteUtility.byteToHex(this.getSessionLock()) : "N/A"));
        return fStr.toString();
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.136.160.82");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        MDRRegionLockCommand mdrRegionLock = new MDRRegionLockCommand(rmcp);
        mdrRegionLock = mdrRegionLock.getMDRRegionLock();
        MOut.G().print(mdrRegionLock.toFormatedHeader());
        MOut.G().print(mdrRegionLock.toFormatedString());
    }
}

