/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.MessageCenter;

public class IPMIWatchdogCommand
extends IPMICommand {
    public IPMIWatchdogCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage ResetTimerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)34, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage SetTimerCommand(byte action, byte interval, int countdown) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = 4;
        data[1] = action;
        data[2] = interval;
        data[3] = 16;
        ByteUtility.intTo2Bytes(data, 4, countdown);
        ipmiMessage.setCommandAndData((byte)24, (byte)36, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetTimerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)37, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean ResetTimer() {
        IPMIMessage resMessage = this.ResetTimerCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute reset timer command.");
        return false;
    }

    public boolean SetTimer(int action, int interval, int countdown) {
        IPMIMessage resMessage = this.SetTimerCommand((byte)action, (byte)interval, countdown);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set timer command.");
        return false;
    }

    public GetWatchdog getAllInfo() throws Exception {
        GetWatchdog getWatchdog = new GetWatchdog();
        IPMIMessage resMessage = this.GetTimerCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                try {
                    getWatchdog.timerUse = resMessage.data[0] & 7;
                    getWatchdog.isTimerUse = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    getWatchdog.timerIs = resMessage.data[0] & 0x40;
                    getWatchdog.isTimerIs = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    getWatchdog.timerActions = resMessage.data[1] & 7;
                    getWatchdog.isTimerActions = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    getWatchdog.timeoutInterval = resMessage.data[2];
                    getWatchdog.isTimeoutInterval = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    getWatchdog.expirationFlags = resMessage.data[3];
                    getWatchdog.isExpirationFlags = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    byte[] initCD = new byte[]{resMessage.data[4], resMessage.data[5]};
                    getWatchdog.initialCountdown = ByteUtility.twoBytesToIntLSB(initCD);
                    getWatchdog.isInitialCountdown = true;
                }
                catch (Exception initCD) {
                    // empty catch block
                }
                try {
                    byte[] preCD = new byte[]{resMessage.data[6], resMessage.data[7]};
                    getWatchdog.presentCountdown = ByteUtility.twoBytesToIntLSB(preCD);
                    getWatchdog.isPresentCountdown = true;
                }
                catch (Exception exception) {}
            } else {
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"Can't execute get timer command.");
        }
        return getWatchdog;
    }

    public class GetWatchdog {
        public int timerUse;
        public int timerIs;
        public int timerActions;
        public int timeoutInterval;
        public byte expirationFlags;
        public int initialCountdown;
        public int presentCountdown;
        public boolean isTimerUse;
        public boolean isTimerIs;
        public boolean isTimerActions;
        public boolean isTimeoutInterval;
        public boolean isExpirationFlags;
        public boolean isInitialCountdown;
        public boolean isPresentCountdown;

        public String TimerUse() {
            switch (this.timerUse) {
                case 1: {
                    return "BIOS FRB2 (0x01)";
                }
                case 2: {
                    return "BIOS/POST (0x02)";
                }
                case 3: {
                    return "OS Load (0x03)";
                }
                case 4: {
                    return "SMS/OS (0x04)";
                }
                case 5: {
                    return "OEM (0x05)";
                }
            }
            return "reserved";
        }

        public String TimerIs() {
            if (this.timerIs == 64) {
                return "Started/Running";
            }
            return "Stopped";
        }

        public String getTimerActions() {
            switch (this.timerActions) {
                case 0: {
                    return "No Action (0x00)";
                }
                case 1: {
                    return "Hard Reset (0x01)";
                }
                case 2: {
                    return "Power Down (0x02)";
                }
                case 3: {
                    return "Power Cycle (0x03)";
                }
            }
            return "reserved";
        }

        public int getTimeoutInterval() {
            return this.timeoutInterval;
        }

        public String getExpirationFlags() {
            switch (this.expirationFlags) {
                case 1: {
                    return "BIOS FRB2 (0x01)";
                }
                case 2: {
                    return "BIOS/POST (0x02)";
                }
                case 3: {
                    return "OS Load (0x03)";
                }
                case 4: {
                    return "SMS/OS (0x04)";
                }
                case 5: {
                    return "OEM (0x05)";
                }
            }
            return "0x" + ByteUtility.byteToHex(this.expirationFlags);
        }

        public int getInitialCountdown() {
            return this.initialCountdown / 10;
        }

        public int getPresentCountdown() {
            return this.presentCountdown / 10;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %30s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f = " %-30s | %30s \n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(f, "Watchdog Timer Use", this.isTimerUse ? this.TimerUse() : "N/A"));
            fStr.append(String.format(f, "Watchdog Timer Is", this.isTimerIs ? this.TimerIs() : "N/A"));
            fStr.append(String.format(f, "Watchdog Timer Actions", this.isTimerActions ? this.getTimerActions() : "N/A"));
            fStr.append(String.format(f, "Pre-timeout interval", this.isTimeoutInterval ? "" + this.getTimeoutInterval() + " seconds" : "N/A"));
            fStr.append(String.format(f, "Timer Expiration Flags", this.isExpirationFlags ? this.getExpirationFlags() : "N/A"));
            fStr.append(String.format(f, "Initial Countdown", this.isInitialCountdown ? "" + this.getInitialCountdown() + " sec" : "N/A"));
            fStr.append(String.format(f, "Present Countdown", this.isPresentCountdown ? "" + this.getPresentCountdown() + " sec" : "N/A"));
            return fStr.toString();
        }
    }
}

