/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICMMDiagCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.lang.L;
import com.supermicro.ipmi.loc.TagLocSDR;
import com.supermicro.ipmi.microblade.cmmdiag.CMMDiagScenario;
import com.supermicro.ipmi.microblade.cmmdiag.Discrete;
import com.supermicro.ipmi.text.IPMISensorDisplayForCMMDiag;
import java.io.IOException;
import java.util.ArrayList;

public class IPMISDRCommandForCMMDiag
extends IPMICommand {
    public IPMISDRCommandForCMMDiag(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getSDRRepositoryInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)32, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage deleteSDRCommand(byte[] reservationID, byte[] recordID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(reservationID, 0, data, 0, 2);
        System.arraycopy(recordID, 0, data, 2, 2);
        ipmiMessage.setCommandAndData((byte)40, (byte)38, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearSDRCommand(byte[] reservationID, byte cmd) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(reservationID, 0, data, 0, 2);
        data[2] = 67;
        data[3] = 76;
        data[4] = 82;
        data[5] = cmd;
        ipmiMessage.setCommandAndData((byte)40, (byte)39, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage addSDRCommand(byte[] data) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)40, (byte)36, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ReserveSDR() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)34, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSDRCommand(byte[] reservationID, byte[] recordID, byte offset, byte bytesToRead) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(reservationID, 0, data, 0, 2);
        System.arraycopy(recordID, 0, data, 2, 2);
        data[4] = offset;
        data[5] = bytesToRead;
        ipmiMessage.setCommandAndData((byte)40, (byte)35, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorReadingCommand(byte sensorNumber) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{sensorNumber};
        ipmiMessage.setCommandAndData((byte)16, (byte)45, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorThresholdCommand(byte sensorNumber) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{sensorNumber};
        ipmiMessage.setCommandAndData((byte)16, (byte)39, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDutyCycleCommand(byte sensorNumber) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-120, sensorNumber};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPWMDutyCycleCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte[] getDutyCycle(Byte sensorNumber) throws IPMIException {
        IPMIMessage resMessage = this.getDutyCycleCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] data = new byte[]{resMessage.data[0], resMessage.data[1]};
                return data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute get Duty Cycle command");
    }

    public byte[] getPWMDutyCycle() throws IPMIException {
        IPMIMessage resMessage = this.getPWMDutyCycleCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] data = new byte[resMessage.data.length / 3];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = resMessage.data[i * 3 + 2];
                }
                return data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute get PWM Duty Cycle command");
    }

    public SDRInfo getSDRRepositoryInfoModal() {
        IPMIMessage resMessage = this.getSDRRepositoryInfoCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return SDRInfo.fromRaw(resMessage.data);
            }
            if (resMessage.completionCode == 129) {
                MessageCenter.getInstance().put(this, (Object)"cannot execute command, SEL erase in progress");
            } else {
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get SDR repository info");
        return null;
    }

    public byte[] getSDRReservationID() {
        IPMIMessage resMessage = this.ReserveSDR();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Reserve SDR ID");
        return null;
    }

    public boolean clearSDR() {
        byte[] reservationID = this.getSDRReservationID();
        byte initErease = -86;
        byte getStatus = 0;
        if (reservationID == null) {
            return false;
        }
        IPMIMessage resMessage = this.clearSDRCommand(reservationID, initErease);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                for (int i = 0; i < 20; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    reservationID = this.getSDRReservationID();
                    resMessage = this.clearSDRCommand(reservationID, getStatus);
                    if (resMessage.completionCode == 0) {
                        if (resMessage.data[0] != 1) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute delete SDR");
        return false;
    }

    public boolean addSDR(byte[] data) {
        IPMIMessage resMessage = this.addSDRCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute delete SDR");
        return false;
    }

    public void addSDRRecord(byte[] data) throws IPMIException {
        IPMIMessage resMessage = this.addSDRCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute delete SDR");
    }

    public void deleteSDRRecord(byte[] recordID) throws IPMIException {
        byte[] reservationID = this.getSDRReservationID();
        if (reservationID == null) {
            throw new IPMIException("Failed to get Reservation ID");
        }
        IPMIMessage resMessage = this.deleteSDRCommand(reservationID, recordID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute delete SDR");
    }

    public boolean deleteSDR(int recordID) {
        byte[] recordIDBytes = new byte[2];
        ByteUtility.intTo2Bytes(recordIDBytes, 0, recordID);
        byte[] reservationID = this.getSDRReservationID();
        if (reservationID == null) {
            return false;
        }
        IPMIMessage resMessage = this.deleteSDRCommand(reservationID, recordIDBytes);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute delete SDR");
        return false;
    }

    public ArrayList getSDRs(int length) {
        ArrayList<SDRRecord> list = new ArrayList<SDRRecord>();
        byte[] recordID = new byte[2];
        byte[] nextRecordID = new byte[2];
        byte offset = 0;
        byte byteToRead = 8;
        for (int i = 0; i < length; ++i) {
            byte[] reservationID = this.getSDRReservationID();
            if (reservationID == null) {
                return null;
            }
            recordID[0] = nextRecordID[0];
            recordID[1] = nextRecordID[1];
            MessageCenter.getInstance().put(this, (Object)(L.t("sdr.Getting_SDR_entry") + " (" + (i + 1) + ")"));
            IPMIMessage resMessage = this.getSDRCommand(reservationID, recordID, offset, byteToRead);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    System.arraycopy(resMessage.data, 0, nextRecordID, 0, 2);
                    byte recordType = resMessage.data[5];
                    if (recordType != 1) continue;
                    byte recordLength = (byte)(resMessage.data[6] + 5);
                    byte[] bytes = new byte[5 + recordLength];
                    System.arraycopy(resMessage.data, 2, bytes, 0, byteToRead);
                    byte aByteToRead = (byte)(recordLength - byteToRead);
                    IPMIMessage aResMessage = this.getSDRCommand(reservationID, recordID, byteToRead, aByteToRead);
                    if (aResMessage != null && aResMessage.completionCode == 0) {
                        System.arraycopy(aResMessage.data, 2, bytes, byteToRead, aByteToRead);
                    } else {
                        MessageCenter.getInstance().put("Get SDR error: " + (aResMessage != null ? GlobalDefine.completionCodeString.get(ByteUtility.byteToHex(aResMessage.completionCode)) : " Command sending failed"));
                    }
                    list.add(SDRRecord.fromRaw(bytes));
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)("ccode =" + ByteUtility.byteToHex(resMessage.completionCode)));
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get SDR");
            break;
        }
        return list;
    }

    public ArrayList getCurrentSDR(int recordCount) throws IOException {
        return this.getCurrentSDR(recordCount, 0);
    }

    public ArrayList getCurrentSDR(int recordCount, int start) throws IOException {
        try {
            return this.getSDRsEx(recordCount);
        }
        catch (IPMIException e) {
            long s = new Double(Math.pow(2.0, start)).longValue();
            try {
                Thread.sleep(s * 1000L);
            }
            catch (InterruptedException e1) {
                throw new IOException("SDR Timeout !!");
            }
            int retry = start + 1;
            if (retry > 6) {
                throw new IOException("SDR Timeout !!");
            }
            return this.getCurrentSDR(recordCount, retry);
        }
    }

    public ArrayList getSDRbyLine(int length, boolean showThreshold, boolean ispowerOn, byte[] guid, IPMIInterfaceConfig config) throws IOException, IPMIException {
        ArrayList<SDRRecord> list = new ArrayList<SDRRecord>();
        ArrayList<String> sdrRecordList = new ArrayList<String>();
        byte[] recordID = new byte[2];
        byte[] nextRecordID = new byte[2];
        byte offset = 0;
        byte byteToRead = 8;
        Discrete systemStatusDiscrete = null;
        for (int i = 0; i < length; ++i) {
            byte[] reservationID = this.getSDRReservationID();
            if (reservationID == null) {
                throw new IPMIException("Cannot get ReservationID.");
            }
            recordID[0] = nextRecordID[0];
            recordID[1] = nextRecordID[1];
            MessageCenter.getInstance().put(this, (Object)(L.t("sdr.Getting_SDR_entry") + " (" + (i + 1) + ")"));
            if (recordID[0] == -1 && recordID[1] == -1) {
                return list;
            }
            IPMIMessage resMessage = this.getSDRCommand(reservationID, recordID, offset, byteToRead);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    System.arraycopy(resMessage.data, 0, nextRecordID, 0, 2);
                    byte recordType = resMessage.data[5];
                    byte recordLength = (byte)(resMessage.data[6] + 5);
                    byte[] bytes = new byte[5 + recordLength];
                    System.arraycopy(resMessage.data, 2, bytes, 0, byteToRead);
                    byte aByteToRead = (byte)(recordLength - byteToRead);
                    IPMIMessage aResMessage = this.getSDRCommand(reservationID, recordID, byteToRead, aByteToRead);
                    if (aResMessage != null && aResMessage.completionCode == 0) {
                        System.arraycopy(aResMessage.data, 2, bytes, byteToRead, aByteToRead);
                    } else {
                        MessageCenter.getInstance().put("Get SDR error: " + (aResMessage != null ? GlobalDefine.completionCodeString.get(ByteUtility.byteToHex(aResMessage.completionCode)) : " Command sending failed"));
                    }
                    SDRRecord sdrRecord = null;
                    switch (recordType) {
                        case 1: {
                            sdrRecord = SDRRecord.fromRaw(bytes);
                            break;
                        }
                        case 2: {
                            sdrRecord = SDRRecord.fromRawSDRType2(bytes);
                        }
                    }
                    if (sdrRecord == null) continue;
                    sdrRecord.setIsValueAvailable(this.isAvailable(sdrRecord.getSensorNumber()));
                    if (sdrRecord.isIsValueAvailable() && sdrRecord.getReading() < sdrRecord.getHiLimit() && sdrRecord.getReading() > sdrRecord.getLowLimit()) {
                        sdrRecord.setSensorStatus(true);
                    }
                    Discrete discrete = null;
                    IPMISensorDisplayForCMMDiag ipmiDisplay = new IPMISensorDisplayForCMMDiag(this.ipmiInterface);
                    try {
                        discrete = ipmiDisplay.print(sdrRecord, showThreshold, ispowerOn, guid, sdrRecordList);
                        if (discrete != null && discrete.isSystemStatus()) {
                            systemStatusDiscrete = discrete;
                        }
                    }
                    catch (IPMIException iPMIException) {
                        // empty catch block
                    }
                    list.add(sdrRecord);
                    continue;
                }
                if (resMessage.completionCode == -59) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    reservationID = this.getSDRReservationID();
                    --i;
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)("ccode = " + ByteUtility.byteToHex(resMessage.completionCode)));
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            throw new IOException("Cannot execute Get SDR.");
        }
        CMMDiagScenario cmmdiag = new CMMDiagScenario();
        byte systemStatusDiscreteReading = systemStatusDiscrete == null ? (byte)-1 : (byte)systemStatusDiscrete.getReading();
        cmmdiag.run(new IPMICMMDiagCommand(this.ipmiInterface), systemStatusDiscreteReading, sdrRecordList, config);
        return list;
    }

    public ArrayList getSDRsEx(int length) throws IOException, IPMIException {
        ArrayList<SDRRecord> list = new ArrayList<SDRRecord>();
        byte[] recordID = new byte[2];
        byte[] nextRecordID = new byte[2];
        byte offset = 0;
        byte byteToRead = 8;
        for (int i = 0; i < length; ++i) {
            byte[] reservationID = this.getSDRReservationID();
            if (reservationID == null) {
                throw new IPMIException("Cannot get ReservationID");
            }
            recordID[0] = nextRecordID[0];
            recordID[1] = nextRecordID[1];
            MessageCenter.getInstance().put(this, (Object)(L.t("sdr.Getting_SDR_entry") + " (" + (i + 1) + ")"));
            if (recordID[0] == -1 && recordID[1] == -1) {
                return list;
            }
            IPMIMessage resMessage = this.getSDRCommand(reservationID, recordID, offset, byteToRead);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    System.arraycopy(resMessage.data, 0, nextRecordID, 0, 2);
                    byte recordType = resMessage.data[5];
                    byte recordLength = (byte)(resMessage.data[6] + 5);
                    byte[] bytes = new byte[5 + recordLength];
                    System.arraycopy(resMessage.data, 2, bytes, 0, byteToRead);
                    byte aByteToRead = (byte)(recordLength - byteToRead);
                    IPMIMessage aResMessage = this.getSDRCommand(reservationID, recordID, byteToRead, aByteToRead);
                    if (aResMessage != null && aResMessage.completionCode == 0) {
                        System.arraycopy(aResMessage.data, 2, bytes, byteToRead, aByteToRead);
                    } else {
                        MessageCenter.getInstance().put("Get SDR error: " + (aResMessage != null ? GlobalDefine.completionCodeString.get(ByteUtility.byteToHex(aResMessage.completionCode)) : " Command sending failed"));
                    }
                    SDRRecord sdrRecord = null;
                    switch (recordType) {
                        case 1: {
                            sdrRecord = SDRRecord.fromRaw(bytes);
                            break;
                        }
                        case 2: {
                            sdrRecord = SDRRecord.fromRawSDRType2(bytes);
                        }
                    }
                    if (sdrRecord == null) continue;
                    sdrRecord.setIsValueAvailable(this.isAvailable(sdrRecord.getSensorNumber()));
                    if (sdrRecord.isIsValueAvailable() && sdrRecord.getReading() < sdrRecord.getHiLimit() && sdrRecord.getReading() > sdrRecord.getLowLimit()) {
                        sdrRecord.setSensorStatus(true);
                    }
                    list.add(sdrRecord);
                    continue;
                }
                if (resMessage.completionCode == -59) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    reservationID = this.getSDRReservationID();
                    --i;
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)("ccode =" + ByteUtility.byteToHex(resMessage.completionCode)));
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            throw new IOException("Can't execute Get SDR");
        }
        return list;
    }

    public SDRRecordC0h_NMOEMSDR getNMSDR() throws IOException, IPMIException {
        byte[] recordID = new byte[2];
        byte[] nextRecordID = new byte[2];
        byte offset = 0;
        byte byteToRead = -1;
        SDRInfo sdrInfo = this.getSDRRepositoryInfoModal();
        if (sdrInfo == null) {
            throw new IPMIException("Get SDRRepository error");
        }
        byte[] reservationID = this.getSDRReservationID();
        if (reservationID == null) {
            throw new IPMIException("Cannot get ReservationID");
        }
        for (int i = 0; i < sdrInfo.getRecordCount(); ++i) {
            recordID[0] = nextRecordID[0];
            recordID[1] = nextRecordID[1];
            MessageCenter.getInstance().put(this, (Object)(L.t("sdr.Getting_SDR_entry") + " (" + (i + 1) + ")"));
            IPMIMessage resMessage = this.getSDRCommand(reservationID, recordID, offset, byteToRead);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    System.arraycopy(resMessage.data, 0, nextRecordID, 0, 2);
                    byte recordType = resMessage.data[5];
                    byte OEM_ID_1 = resMessage.data[7];
                    byte OEM_ID_2 = resMessage.data[8];
                    byte OEM_ID_3 = resMessage.data[9];
                    if (recordType != -64 || OEM_ID_1 != 87 || OEM_ID_2 != 1 || OEM_ID_3 != 0) continue;
                    SDRRecordC0h_NMOEMSDR nmOEMSDR = new SDRRecordC0h_NMOEMSDR();
                    nmOEMSDR.fromRaw(resMessage.data);
                    return nmOEMSDR;
                }
                if (resMessage.completionCode == -59) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    reservationID = this.getSDRReservationID();
                    --i;
                    continue;
                }
                throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get SDR");
            throw new IOException("Can't execute Get SDR");
        }
        return null;
    }

    public TagLocSDR getTagLocSDR() throws IPMIException {
        byte[] recordID = new byte[2];
        byte[] nextRecordID = new byte[2];
        byte offset = 0;
        byte byteToRead = -1;
        SDRInfo sdrInfo = this.getSDRRepositoryInfoModal();
        if (sdrInfo == null) {
            throw new IPMIException("Get SDRRepository error");
        }
        byte[] reservationID = this.getSDRReservationID();
        if (reservationID == null) {
            throw new IPMIException("Cannot get ReservationID");
        }
        for (int i = 0; i < sdrInfo.getRecordCount(); ++i) {
            recordID[0] = nextRecordID[0];
            recordID[1] = nextRecordID[1];
            MessageCenter.getInstance().put(this, (Object)(L.t("sdr.Getting_SDR_entry") + " (" + (i + 1) + ")"));
            IPMIMessage resMessage = this.getSDRCommand(reservationID, recordID, offset, byteToRead);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    System.arraycopy(resMessage.data, 0, nextRecordID, 0, 2);
                    if (!TagLocSDR.isTagLocSDR(resMessage.data)) continue;
                    TagLocSDR tagLocSDR = new TagLocSDR();
                    tagLocSDR.fromSDRRaw(resMessage.data);
                    return tagLocSDR;
                }
                throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            throw new IPMIException("Can't execute Get SDR");
        }
        return null;
    }

    public byte getSensorReading(byte sensorNumber, byte sensorType) {
        IPMIMessage resMessage;
        byte returnCode = -1;
        if (sensorType == 1) {
            returnCode = -128;
        }
        if ((resMessage = this.getSensorReadingCommand(sensorNumber)) != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return returnCode;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Sensor Reading");
        return returnCode;
    }

    public byte getSensorReading(byte sensorNumber) {
        return this.getSensorReading(sensorNumber, (byte)0);
    }

    public byte getDiscreteOffset(byte sensorNumber) {
        IPMIMessage resMessage = this.getSensorReadingCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[2];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Sensor Reading");
        return -1;
    }

    public byte getSensorThresholdMask(byte sensorNumber) {
        IPMIMessage resMessage = this.getSensorThresholdCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Sensor Threshold");
        return -1;
    }

    public byte[] getFullSensorValue(byte sensorNumber) {
        IPMIMessage resMessage = this.getSensorReadingCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[resMessage.data.length];
                System.arraycopy(resMessage.data, 0, bytes, 0, bytes.length);
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Sensor Value");
        return null;
    }

    private boolean isAvailable(byte sensorNumber) {
        IPMIMessage resMessage = this.getSensorReadingCommand(sensorNumber);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }
}

